"Idols of War" by "Victor Gijsbers"

The story headline is "An Interactive Dungeon Crawl"

Include Basic Help Menu by Emily Short.
Include Plurality by Emily Short.
Include Simple Chat by Mark Tilford.
Include Scheduled Activities by John Clemens.
Include Conditional Undo by Jesse McGrew.
Include Custom Library Messages by David Fisher.
Include Pronouns by Ron Newcomb.


Use no scoring, full-length room descriptions[ and undo prevention].

Use MAX_OBJ_PROP_COUNT of 128. [Because we define way more than 64  properties for persons/monsters!]

[Use MAX_STATIC_DATA of 300000.
Use dynamic memory allocation of at least 30000.]

Use Default Forbid Exiting Conversations. [Simple Chat]


When play begins, seed the random-number generator with 23481.




Volume 1 - The System



Chapter 1.0.0.1 - Preliminaries


Section 1.0.0.1.1 - Dummy variables declared

[We are going to need a bunch of dummy variables during the calculations we will make. Since Inform 7 does not have a rigid global/local distinction - as far as I know, the only local variables are those which are declared in the names of activities - we will define them globally.]

The first dummy is a number that varies.
The second dummy is a number that varies.
The third dummy is a number that varies.
The fourth dummy is a number that varies.

The room dummy is a room that varies.

The monster dummy is a person that varies.

The thing dummy is a thing that varies.

The first dummy boolean is a truth state that varies.


Section 1.0.0.1.2 - Other global variables

[The combat boolean is a number that is 1 if the player is in combat, and 0 if he is not.]

The combat boolean is a number that varies. The combat boolean is 0.


Section 1.0.0.1.3 - Time

[Some of the actions we define should take no time; and we wish to ensure that examining, smelling, and so on do not take time either. This will allow the player to look around in combat, which is to be encouraged.]

Examining something is acting fast.
Taking inventory is acting fast.
Smelling is acting fast.
Smelling something is acting fast.
Looking is acting fast.
Looking under something is acting fast.
Listening is acting fast.
Listening to something is acting fast.
Thinking is acting fast.


First turn sequence rule: if acting fast, rule succeeds.

To take no time:
    (- meta = true; -).


Section 1.0.0.1.4 - The Status Line

[We want to show the current location on the left side; and the current level, blood and zeal of the player on the right side.]

When play begins, change the left hand status line to "[bold type][location of the player][roman type]        Blood: [blood of the player]/[permanent blood of the player]   Zeal: [zeal of the player]/[permanent zeal of the player]    [excitement of the player]".

When play begins, change the right hand status line to "Circle: [level of the player]"


Section 1.0.0.1.5 - Printing Styles

Printing style is a kind of value. The printing styles are printing-normal and printing-fiery.

The printing state is a printing style that varies. The printing state is usually printing-normal.







Book 1.1 - The Combat System


Chapter 1.1.0.1 - Combat Stats of the Characters


Section 1.1.0.1.1 - Blood


A person has a number called blood. The blood of a person is usually 10. [Blood is a measure of health.]

Definition: A person is alive if its blood is 1 or more. Definition: A person is killed if its blood is 0 or less. [Once blood drops to zero, you are dead. This holds true for both the player and his enemies.] 

[Understand the alive property as describing a monster.]


A person has a number called permanent blood. [The maximum you can regain with healing.]

When play begins:
    repeat with the patient running through people begin;
        change the permanent blood of the patient to the blood of the patient;
    end repeat.

[We set the permanent blood of each individual to the blood it has at the beginning of the game. If we wish any character to start the game wounded or super-healthy, we will have to manually override this process.]

To restore the blood of (patient - a person): change the blood of the patient to the permanent blood of the patient. 

To heal (patient - a person) for (health - a number) blood:
	now the first dummy is the permanent blood of the patient minus the blood of the patient;
	if health is less than the first dummy, now the first dummy is health;
	increase the blood of the patient by the first dummy;
	say the first dummy.


A person has a number called gained blood. [This is the amount of blood the player will get when killing the character.]

When play begins:
	repeat with the patient running through people begin;
        	change the gained blood of the patient to a random number between 1 and the permanent blood of the patient;
		if the patient is summoned, now the gained blood of the patient is 0; 
	end repeat.



Section 1.1.0.1.2 - Zeal


A person has a number called zeal. The zeal of a person is usually 0. 



A person has a number called permanent zeal. [The maximum you can regain through rituals.]

When play begins:
    repeat with the patient running through people begin;
        change the permanent zeal of the patient to the zeal of the patient;
    end repeat.

[We set the permanent blood of each individual to the zeal it has at the beginning of the game. If we wish any character to start the game tired or over-zealous, we will have to manually override this process.]

To restore the zeal of (patient - a person): change the zeal of the patient to the permanent zeal of the patient.


Section 1.1.0.1.3 - Concentration

[Concentration allows you to hit more accurately, while doing more damage. With concentration 1: +1 to hit. With concentration 2: + 2 to hit, +1 to damage. With concentration 3 or more: +3 to hit, + 2 to damage.]

A person has a number called concentration. The concentration of a person is usually 0.



Section 1.1.0.1.4 - Melee, Mind, Defense

[These are pretty self-explanatory. You normally hit if 1d6 + melee is _higher_ than the defense of your enemy.]

A person has a number called melee. The melee of a person is usually 0. 

A person has a number called mind. The mind of a person is usually 0.

A person has a number called defense. The defense of a person is usually 7.


Section 1.1.0.1.5 - Separation

[Separated persons cannot attack each other. Those who are separation-privileged are exempt from this restriction.]

A person is either separated or not separated. A person is usually not separated.

A person is either separation-privileged or not separation-privileged. A person is usually not separation-privileged. 


Section 1.1.0.1.6 - Global Combat Variables

The deadly combat bonus is a number that varies. The deadly combat bonus is usually 0. [Whenever a combat round goes by in which nobody deals damage, the deadly combat bonus increases by 1. Whenever a combat round goes by in which somebody deals damage, it goes down by 1 to a minimum of 0. The deadly combat bonus is added to everyone;s to-hit modifier.]

The deadly combat boolean is a truth state that varies. The deadly combat boolean is usually true.

Every turn when a hostile alive monster is enclosed by the location (this is the global combat variables rule):
	if the deadly combat boolean is true, increase the deadly combat bonus by 1;
	if the deadly combat boolean is false, decrease the deadly combat bonus by 2;
	if the deadly combat bonus is less than 0, now the deadly combat bonus is 0;
	if the deadly combat bonus is greater than 5, now the deadly combat bonus is 5;
	if no hostile alive monster was enclosed by the location, now the deadly combat bonus is 0;
	do the tutorial deadly combat check;
	now the deadly combat boolean is true.

The global combat variables rule is listed last in the every turn rules.

Every turn when no hostile alive monster is enclosed by the location:
	now the deadly combat bonus is 0.


Section 1.1.0.1.7 - Excitement

Excitement is a kind of value. The excitements are Serene, Calm, Animated, Excited, Agitated, Frantic, Frenzied and Lost.

A person has an excitement. A person is usually animated.

A person has an excitement called the base excitement state. The base excitement state of a person is usually animated.

The player is calm. The base excitement state of the player is calm. 

To calculate the excitement to-hit bonus of (the subject - a person):
	if the subject is serene begin;
		say " - 1 (serene)";
		decrease the to-hit modifier by 1;
	end if;
	if the subject is agitated begin;
		say " + 1 (agitated)";
		increase the to-hit modifier by 1;
	end if;
	if the subject is frantic begin;
		say " + 2 (frantic)";
		increase the to-hit modifier by 2;
	end if;
	if the subject is frenzied begin;
		say " + 4 (frenzied)";
		increase the to-hit modifier by 4;
	end if.

To calculate the excitement damage bonus of (the subject - a person):
	if the subject is serene begin;
		say " - 3 (serene)";
		decrease the damage modifier by 3;
		now the modified boolean is 1;
	end if;
	if the subject is calm begin;
		say " - 1 (calm)";
		decrease the damage modifier by 1;
		now the modified boolean is 1;
	end if;
	if the subject is excited begin;
		say " + 1 (excited)";
		increase the damage modifier by 1;
		now the modified boolean is 1;
	end if;
	if the subject is agitated begin;
		say " + 2 (agitated)";
		increase the damage modifier by 2;
		now the modified boolean is 1;
	end if;
	if the subject is frantic begin;
		say " + 4 (frantic)";
		increase the damage modifier by 4;
		now the modified boolean is 1;
	end if;
	if the subject is frenzied begin;
		say " + 8 (frenzied)";
		increase the damage modifier by 8;
		now the modified boolean is 1;
	end if.

To calculate the excitement defence bonus of (the subject - a person):
	if the subject is serene begin;
		say " - 1 (opponent serene)";
		decrease the to-hit modifier by 1;
	end if;
	if the subject is calm begin;
		say " - 1 (opponent calm)";
		decrease the to-hit modifier by 1;
	end if;
	if the subject is frantic begin;
		say " + 1 (opponent frantic)";
		increase the to-hit modifier by 1;
	end if;
	if the subject is frenzied begin;
		say " + 2 (opponent frenzied)";
		increase the to-hit modifier by 2;
	end if.


To increase the excitement of (the subject - a person):
	change the excitement of the subject to the excitement after the excitement of the subject;
	if the excitement of the subject is lost begin;
		if the subject is the player begin;
			say "BETA: you would now have lost control.";
			change the base excitement state of the subject to the excitement after the base excitement state of the subject;
			if the base excitement state of the subject is lost, end the game saying "You have lost yourself."; 
		end if;
		now the excitement of the subject is frenzied;
	end if.

To decrease the excitement of (the subject - a person):
	change the excitement of the subject to the excitement before the excitement of the subject;
	if the excitement of the subject is lost, now the excitement of the subject is serene;
	if the excitement of the subject is the excitement before the base excitement state of the subject, now the excitement of the subject is the base excitement state of the subject.


Calming down is an action applying to nothing. Understand "calm" and "calm down" as calming down.

Check calming down:
	if a hostile alive monster is enclosed by the location, say "You cannot calm down while engaged in a fight." instead;
	if the excitement of the player is the base excitement state of the player, say "You are already as calm as you will get." instead.

Carry out calming down:
	now the excitement of the player is the base excitement state of the player;
	say "You take a couple of deep breaths until you are [excitement of the player] again.".






Part 1.1.1 - Modeling the Fight


Section 1.1.1.0.1 - Starting combat

The noattack boolean is a truth state that varies.


First every turn when a hostile alive monster is enclosed by the location:
	if the combat boolean is 0, start a combat.

To start a combat:
	calculate the initial combat significance;
	now the noattack boolean is true;
	now the combat boolean is 1.



Chapter 1.1.1.1 - Calculating an attack 


Attack type is a kind of value. The attack types are normal, silent, free and fiery. 

The attack state is an attack type that varies. The attack state is usually normal.





Section 1.1.1.1.1 - Define monster


A monster is a kind of person. 



Section 1.1.1.1.2 - Striking a blow

The to-hit roll is a number that varies. The to-hit modifier is a number that varies. The damage is a number that varies. The damage modifier is a number that varies. The final damage is a number that varies.

The global defender is a person that varies. The global attacker is a person that varies.

The global flavour text boolean is a truth state that varies. The global flavour text boolean is usually false.


To make (attacker - a person) strike a blow against (defender - a person):
	now the global attacker is the attacker;
	now the global defender is the defender;
	now the attacker is not at parry;
	now the attacker is not at dodge;
	if the attacker is the player, now the scouting boolean is false;
	if the attacker is the player, cancel all scheduled giving the await bonus;
	if the defender is gaseous begin;
		if the defender is the player, say "You are gaseous, so [the attacker] cannot hit you.";
		if the defender is not the player, say "[The defender] is gaseous, so [possessive of the attacker] attack fails.";
		stop;
	end if;
	if the attacker is separated and the attacker is not separation-privileged begin; [This part is for seperated attacker/defender pairs.]
		if the defender is the player, say "[The attacker] cannot reach you.";
		if the defender is not the player, say "[The attacker] cannot reach [the defender].";
		stop;
	end if;
	if the defender is separated begin;
		if the defender is the player, say "[The attacker] cannot reach you.";
		if the defender is not the player, say "[The attacker] cannot reach [the defender].";
		stop;
	end if; [Here the part for seperated attacker/defender pairs ends.]
	if the defender is an indifferent monster begin; [This part ensures that indifferent monsters become hostile when attacked.]
		repeat with the former indifferent running through the indifferent monsters enclosed by the location begin;
			now the former indifferent is hostile;
		end repeat;
		now the noattack boolean is false;
	end if;
	say "[italic type]";
	now the damage is 0; now the final damage is 0; [Resets the variables.]
	 say "Rolling ";
	change the to-hit roll to a random number between 1 and 10;
	say the to-hit roll;
	calculate the to-hit modifier of the attacker against the defender;
	increase the to-hit roll by the to-hit modifier;
	say " = ", the to-hit roll, ", ";
	if the to-hit roll is greater than the defense of the defender begin;
	if the attacker is the player, say "you beat "; otherwise say "[the attacker] beats ";
	say "[possessive of defender] defence rating of ", the defense of the defender;
	if the attacker is cursed, do remove curse with the attacker and the defender; [Curse]
	say ". ";
	change the damage to a random number between 1 and the damage die of the attacker;
	if the attack state is fiery, change the damage to a random number between 1 and 3;
	if the attacker is the player, say "You deal ", damage;
	if the attacker is not the player, say "[The attacker] deals ", damage; 
	calculate the damage modifier of the attacker against the defender;
	say " damage, ";
	if the damage is greater than 0, calculate the final damage the attacker does against the defender;
	if the final damage is greater than 0, now the deadly combat boolean is false; 
	if the final damage is 0 begin;
		if the defender is not the player, say "allowing [the defender] to escape unscathed.[run paragraph on]";
		if the defender is the player, say "allowing you to escape unscathed.[run paragraph on]";
	end if;
	if final damage is greater than 0 begin;
		if final damage is less than the blood of the defender begin;
			decrease the blood of the defender by the final damage;
			if the defender is not the player, say "wounding [the defender] to ", blood of the defender, " blood.[run paragraph on]" ;
			if the defender is the player, say "wounding you to ", blood of the defender, " blood.[run paragraph on]";
			let the defender lose concentration;
			if the attacker is the player and the defender is not non-exciting and a random chance of 1 in 20 succeeds, increase the excitement of the player;
			if the defender is the player and the attacker is not non-exciting and a random chance of 1 in 15 succeeds, increase the excitement of the player;
		otherwise;
			decrease the blood of the defender by the final damage;
			if the defender is not the player begin;
				say "killing [the defender].[run paragraph on]";
				receive blood for the defender;
				if a random chance of 1 in 3 succeeds and the defender is not non-exciting, increase the excitement of the player;
			end if;
			if the defender is the player begin;
				say "killing you.";
				end the game saying "You have been slain.";
			end if;
		end if;
	end if;        
	otherwise;
		if the attacker is the player, say "you do ";
		if the attacker is not the player, say "[the attacker] does ";
		say "not overcome [possessive of defender] defence rating of ", the defense of the defender, ".[run paragraph on]";
	end if;
	say "[roman type]";
	if the attacker is the player or the defender is the player begin; [We only print flavour text when it's not monster vs monster, because writing appropriate texts for all monster vs monster interactions is a quadratic rather than a linear task.]
		say "[paragraph break]"; [Here we start printing the flavour text.]
		now the global flavour text boolean is true; [To ensure that (killed) is not printed.]
		if the attacker is the player begin;
			choose a random row from the Player Flavour Texts of the defender;
		otherwise;
			if the defender is the player, choose a random row from the Monster Flavour Texts of the attacker;
		end if;
		if the defender is killed begin;
			if the defender is not boss, say "[Fatal Text entry]";
		otherwise;
			if the to-hit roll is not greater than the defense of the defender, say "[Miss Text entry]";
			if the to-hit roll is greater than the defense of the defender begin;
				if the final damage is greater than 0, say "[Hit Text entry]";
				if the final damage is 0, say "[Absorbed Text entry]";
			end if;
		end if;
	end if; 
	now the global flavour text boolean is false;
	if the player is not killed, determine aftereffects for the attacker and defender;
	if the defender is not killed or the defender is not boss, say "[paragraph break]".

Section 1.1.1.1.3 - Calculating the to-hit modifier

To calculate the to-hit modifier of (attacker - a person) against (defender - a person):
	now the to-hit modifier is 0;
		say " + ", the melee of the attacker;
	increase the to-hit modifier by the melee of the attacker;
	if the deadly combat bonus is greater than 0 begin;
		say " + ", the deadly combat bonus, " (deadly combat)";
		 increase the to-hit modifier by the deadly combat bonus;
	end if;
	calculate the excitement to-hit bonus of the attacker;
	if the concentration of the attacker is greater than 0 begin;
	if the concentration of the attacker is 1, now the first dummy is 2;
	if the concentration of the attacker is 2, now the first dummy is 4;
	if the concentration of the attacker is 3, now the first dummy is 8;
		say " + ", the first dummy, " (concentration)";
		increase the to-hit modifier by the first dummy;
	end if;
	if the attacker is cursed, do cursed with the attacker and the defender; [Curse]
	if the sacrificial number of the attacker is greater than 0 begin;
		say " + ", the sacrificial number of the attacker, " (sacrifice)";
		increase the to-hit modifier by the sacrificial number of the attacker;
		now the sacrificial number of the attacker is 0;
	end if;
	if the await bonus is not greater than 0, now the damage await bonus is 0;
	if the await bonus is greater than 0 begin;
		say " + ", the await bonus, " (awaiting)";
		increase the to-hit modifier by the await bonus;
		now the damage await bonus is the await bonus;
		now the await bonus is 0;
		now the potential await bonus is 0;
	end if;
	if the defender is onholder begin; [Defender is holding on]
		if the hold location of the defender is not 0 begin;
			say " + ", the hold self defence penalty of the defender, " (defender holding on)";
			increase the to-hit modifier by the hold self defence penalty of the defender; 
		end if;
	end if;
	if a hostile alive onholder monster is enclosed by the location, calculate the onholder melee bonus for the attacker against the defender;
	if the attack state is fiery begin; [Burning hands]
		say " + 1 (burning hands)";
		increase the to-hit modifier by 1;
	end if;
	calculate the excitement defence bonus of the defender;
	if the defender is at dodge begin;
		say " - 2 (defender dodging)";
		decrease the to-hit modifier by 2;
	end if;
	if the global guarding stick number is greater than 1 and the defender is the player begin; [Stick of Guarding]
		say " - ", global guarding stick number," (stick of guarding)";
		decrease the to-hit modifier by global guarding stick number;
	end if;
	determine visibility; [Visibility]
	if the total visibility is less than 0 begin;
		now the first dummy is the total visibility;
		if the attacker is darkvisioned, now the first dummy is 0;
		if the attacker is lowlightvisioned and the first dummy is less than 0, increase the first dummy by 1;
		if the attacker is lowlightvisioned and the first dummy is less than 0, increase the first dummy by 1;
		if the defender is on fire, now the first dummy is 0; [You can easily someone who is on fire!]
		if the hold location of the defender is not 0  and the first dummy is less than 0, increase the first dummy by 1; [Its easier to hit someone who is holding on to you/someone else.]
		now the first dummy is 0 minus the first dummy;
		if the first dummy is not 0, say " - ", first dummy, " (low visibility)";
		decrease the to-hit modifier by the first dummy;
	end if;
    continue the activity.

Section 1.1.1.1.4 - Calculating the damage

The modified boolean is a number that varies. [We use this to find out whether there have been modifications. If not, we don't wish to print an equals sign at the end. Just checking whether the damage modifier is not 0 doesn't work, as modifications can cancel each other out.]

To calculate the damage modifier of (attacker - a person) against (defender - a person):
	now the modified boolean is 0;
	now the damage modifier is 0;
	if the attack state is not fiery begin; [Things that do not work with touch attacks]
		if the attacker is crackling, do crackling weapon with attacker and defender; [Crackling weapon]
	end if;
	if the damage bonus of the attacker is not 0 begin;
		increase the damage modifier by the damage bonus of the attacker;
		now the modified boolean is 1;
		say " + ", damage bonus of the attacker, " (inherent damage bonus)";
	end if;
	if the deadly combat bonus is not 0 begin;
		increase the damage modifier by the deadly combat bonus;
		if the deadlier combat boolean is true, increase the damage modifier by the deadly combat bonus;
		now the modified boolean is 1;
		if the deadlier combat boolean is false, say " + ", deadly combat bonus, " (deadly combat)";
		if the deadlier combat boolean is true, say " + ", 2 times the deadly combat bonus, " (deadlier combat)";
	end if;
	calculate the excitement damage bonus of the attacker;
	if the concentration of the attacker is greater than 1 begin;
		if the concentration of the attacker is 2, now the first dummy is 2;
		if the concentration of the attacker is 3, now the first dummy is 4;
		say " + ", the first dummy, " (concentration)";
		increase the damage modifier by the first dummy; now the modified boolean is 1;
	end if;
	if the damage await bonus is greater than 0 begin;
			say " + ", the damage await bonus, " (awaiting)";
			increase the damage modifier by the damage await bonus; now the modified boolean is 1;
	end if;
	if the attacker is angry, do calculating anger with attacker and defender; [Anger]
	if the damage reduction of the defender is not 0 begin;
		say " - ", the damage reduction of the defender, " (inherent damage reduction)";
		decrease the damage modifier by the damage reduction of the defender; now the modified boolean is 1; 
	end if;
	if the attacker is smashing, do smashing blow with attacker and defender;  [Smashing blow]
	if the defender is at parry begin; [parrying]
		if the defender is not shielded, now the first dummy is a random number between 0 and 4;
		if the defender is shielded, now the first dummy is a random number between 2 and 6;
		if the first dummy is not 0, say " - ", first dummy, " (opponent parrying)";
		decrease the damage modifier by the first dummy;
		if the first dummy is not 0, now the modified boolean is 1;
	end if;
	increase the damage by the damage modifier;
	if the modified boolean is 1 begin; say " = ", damage; end if;
	continue the activity.

Section 1.1.1.1.5 - Calculating the final damage

To calculate the final damage (attacker - a person) does against (defender - a person):
    now the final damage is the damage;
    if the elda armour status of the defender is greater than 0, do elda armour with attacker and defender;
    continue the activity.

Section 1.1.1.1.6 - Receiving blood after a kill

To receive blood for (the victim - a person):
	now the third dummy is the permanent blood of the player - the blood of the player;
	now the fourth dummy is the gained blood of the victim;
	if the fourth dummy is greater than the third dummy, now the fourth dummy is the third dummy;
	if the fourth dummy is greater than 0, say " [bold type](Your blood increases by ", the fourth dummy, ".)[roman type][run paragraph on]";
	increase the Blood of the player by the fourth dummy.
	


Section 1.1.1.1.7 - Deal x damage to y

To deal (x - a number) damage to (the sucker - a person):
	decrease the blood of the sucker by x;
	  if the blood of the sucker is greater than 0 begin;
		let the sucker lose concentration between brackets;
		continue the activity;
	  end if;
          if the sucker is not the player begin;
		say "(killing [the sucker])[run paragraph on]";
		receive blood for the sucker;
		say "[paragraph break]";
		stop the action;
	  end if;
          if the sucker is the player begin;
              say "(killing you!)";
              end the game saying "You have been slain.";
          end if.


To deal (x - a number) damage to (the sucker - a person) with alternative layout:
	decrease the blood of the sucker by x;
	  if the blood of the sucker is greater than 0 begin;
		say "[paragraph break]";
		let the sucker lose concentration between brackets;
		continue the activity;
	  end if;
          if the sucker is not the player begin;
		say " This kills [the sucker]![run paragraph on]";
		receive blood for the sucker;
		say "[paragraph break]";
		stop the action;
	  end if;
          if the sucker is the player begin;
              say " This kills you!";
              end the game saying "You have been slain.";
          end if.



Section 1.1.1.1.8 - Aftereffects

To determine aftereffects for (the attacker - a person) and (the defender - a person):
	if the attack state is not free, now the concentration of the attacker is 0;
	if the attacker is vampiric, do sucking blood with the attacker and the defender;
	if the attack state is fiery begin;
		if the final damage is greater than 0 begin;
			if a random chance of 1 in 3 succeeds begin;
				if the attacker is the player, say " Unfortunately, [the defender] does not catch fire.[run paragraph on]";
				if the attacker is not the player, say  "Fortunately, you do not catch fire![run paragraph on]";
			otherwise;
				if the attacker is the player, say " In addition, [the defender] catches fire![run paragraph on]";
				if the attacker is not the player, say " [The attacker] sets you aflame![run paragraph on]";
				set fire to the defender;
			end if;
		end if;
	end if;
	determine crackle aftereffect;
	if the attacker is poisonous begin;
		if the final damage is greater than 0 begin;
			if the defender is the player, have the attacker poison the defender;
		end if;
	end if;
	if the attacker is onholder begin;
		if the final damage is greater than 0 begin;
			if the defender is the player, have the attacker hold on to the defender;
		end if;
	end if;
	if the defender is an alive onholder begin;
		if the final damage is not less than the hold release of the defender begin;
			if the hold location of the defender is not 0, say " Stunned by the blow, [the defender] releases you![run paragraph on]";
			now the hold location of the defender is 0;
		end if;
	end if;
	if the attacker is on fire begin;
		if a random chance of 1 in 4 succeeds begin;
			now the printing state is printing-fiery;
			say " Flames leap from [the attacker] to [the defender]![run paragraph on]";
			now the printing state is printing-normal;
			set fire to the defender;
		end if;
	end if;
	if the defender is on fire begin;
		if a random chance of 1 in 8 succeeds begin;
			now the printing state is printing-fiery;
			say " Flames leap from [the defender] to [the attacker]![run paragraph on]";
			now the printing state is printing-normal;
			set fire to the attacker;
		end if;
	end if;
	if an on fire monster is enclosed by the location begin;
		if the defender is not on fire begin;
			if the attacker is the player begin;
				now the monster dummy is a random on fire monster enclosed by the location;
				if a random chance of 1 in 6 succeeds begin;
					now the printing state is printing-fiery;
					say " Your furious attack pushes [the defender] towards [the monster dummy]. Flames leap from the latter to the former![run paragraph on]";
					now the printing state is printing-normal;
					set fire to the defender; 
				end if;
			end if;
		end if;
	end if;
	now the attack state is normal.

Section 1.1.1.1.9 - Lose concentration

To let (the defender - a person) lose concentration:
	if the concentration of the defender is 0, continue the activity;
	if the defender is determined begin;
		now the first dummy is a random number between 1 and 6;
		if the first dummy is not less than the final damage begin;
			say " Because you are so determined, you do not lose your concentration![run paragraph on]";
			continue the activity;
		end if;
	end if;
	now the concentration of the defender is 0;
	if the defender is the player, say " You lose your concentration![run paragraph on]";
	if the defender is not the player, say " [The defender] loses concentration![run paragraph on]".

To let (the defender - a person) lose concentration between brackets:
	if the concentration of the defender is 0, continue the activity;
	if the defender is determined begin;
		now the first dummy is a random number between 1 and 6;
		if the first dummy is not less than the final damage begin;
			say " (not making you lose your concentration, since you are so determined)[run paragraph on]";
			continue the activity;
		end if;
	end if;
	now the concentration of the defender is 0;
	if the defender is the player, say "(making you lose your concentration)[run paragraph on]";
	if the defender is not the player, say "(making [the defender] lose concentration)[run paragraph on]".



Chapter 1.1.1.2 - Standard Combat Actions


Section 1.1.1.2.1 - Attacking

The block attacking rule is not listed in any rulebook.

Understand "a [thing]" as attacking.

Does the player mean attacking a killed monster: it is unlikely.
Does the player mean attacking a hostile alive monster: it is very likely.

A check attacking rule: if the noun is not a person, say "Things are not your enemies." instead.

A check attacking rule: if the noun is not alive, say "[The noun] is already dead." instead.

A check attacking rule: if the noun is not a monster, say "Save your energy for monsters." instead.


A carry out attacking rule: 
   make the player strike a blow against the noun.



Section 1.1.1.2.2 - Parrying and Dodging
     

Parrying is an action applying to nothing. Understand "parry" and "p" as parrying.

A person can be at parry or not at parry. A person is usually not at parry.

Carry out parrying:
	now the actor is at parry;
	now the actor is not at dodge;
	say "You strike up a defensive pose.".




Dodging is an action applying to nothing. Understand "dodge" and "do" as dodging.

A person can be at dodge or not at dodge. A person is usually not at dodge.

Carry out dodging:
	now the actor is at dodge;
	now the actor is not at parry;
	say "You ready yourself for quick evasive maneuvers."





Section 1.1.1.2.3 - Retreating

Speed is a kind of value. The speeds are medium speed, fast and slow. A person has a speed. A person is usually medium speed.

The retreat location is room that varies. The retreat roll is a number that varies. The retreat monster is a person that varies. The retreat troolean is a number that varies. [0: no special messages; 1: surrounded; 2: specific monster.] The retreat troolean is 0.

Carry out going (this is the set the retreat location rule): now the retreat location is the location.
The set the retreat location rule is listed first in the carry out going rulebook.

Check going: 
	if a hostile alive monster is enclosed by the location begin; 
		say "You can't just [italic type]go[roman type] in the middle of a fight; all you can attempt to do is [italic type]retreat[roman type]."; 
		take no time;
		stop the action;
	end if;

Retreating is an action applying to nothing. Understand "retreat" as retreating.

Check retreating:
	if no hostile alive monster is enclosed by the location, say "You start shrieking and running--only to notice a few moments later that no enemies are around." instead;
	if a hostile alive onholder monster is enclosed by the location begin;
		repeat with the brute running through hostile alive onholder monsters enclosed by the location begin;
			if the hold location of the brute is not 0, say "You cannot retreat while [the brute] holds on to you!" instead;
		end repeat;
	end if;
	now the first dummy is 0; now the second dummy is 0; now the third dummy is 0; now the fourth dummy is 0; now the monster dummy is a random hostile monster enclosed by the location; [We will use the first dummy to calculate the retreat score of the current monster; the second dummy to calculate the final retreat score; the third dummy to calculate the number of monsters with retreat score higher than 0; the fourth dummy to store the highest retreat score; and the monster dummy to store a monster with the highest retreat score.]
	repeat with the opponent running through hostile alive monsters enclosed by the location begin;
		now the first dummy is 0;
		increase the first dummy by 1;
		if the opponent is fast, increase the first dummy by 1;
		if the opponent is slow, decrease the first dummy by 1;
		if the blood of the opponent is greater than the blood of the player, now the first dummy is the first dummy times 2;
		increase the second dummy by the first dummy;
		if the first dummy is greater than 0, increase the third dummy by 1;
		if the first dummy is greater than the fourth dummy begin;
			now the fourth dummy is the first dummy;
			now the monster dummy is the opponent;
		otherwise;
			if the first dummy is the fourth dummy begin;
				if a random chance of 1 in 2 succeeds, now the monster dummy is the opponent;
			end if;
		end if; 
	end repeat;
	change the retreat roll to a random number between 1 and 6;
	say "(Rolling ", retreat roll;
	if the scouting boolean is true begin;
		increase the retreat roll by 4;
		say " + 4 (scouting) = ", retreat roll;
	end if;
	say " against a target number of ", second dummy + 1, "... ";
	if the retreat roll is not greater than the second dummy begin;
		say "failure! ";
		decrease the third dummy by 1; [You cannot be surrounded by 1 monster.]
		now the first dummy is the third dummy + the fourth dummy; [first and second dummy have done their duties and are now again used as simple dummies]
		now the second dummy is a random number between 1 and the first dummy;
		if the second dummy is greater than the fourth dummy begin;
			say " Your enemies have surrounded you.)";
			now the retreat troolean is 1;
		otherwise;
			say " Quickly blocking your way, [the monster dummy] prevents your escape.)";
			now the retreat troolean is 2;
			now the retreat monster is the monster dummy;
		end if; 
		stop the action;
	otherwise;
		say "success!)";
		now the scouting boolean is false;
	end if.

Carry out retreating:
	if the retreat troolean is 0, say "You run away.";
	if the retreat troolean is 1, say "Breaking through the line of your enemies, you dash for safety.";
        if the retreat troolean is 2, say "Dashing past the [retreat monster], you flee the battlefield.";
	move the player to the retreat location;
	now the combat boolean is 0;
	now the retreat troolean is 0;
	now the concentration of the player is 0.



Section 1.1.1.2.4 - Concentrating

Concentrating is an action applying to nothing. Understand "concentrate" and "c" as concentrating.

Carry out concentrating:
	increase the concentration of the actor by 1;
	if the concentration of the actor is greater than 3, now the concentration of the actor is 3;
	if the actor is not the player, say "[The actor] concentrates.";
	if the actor is the player begin;
		if the concentration of the player is 1, say "You are now mildly concentrated.";
		if the concentration of the player is 2, say "You are now quite concentrated.";
		if the concentration of the player is 3, say "You are now maximally concentrated.";
	end if;
	if the concentration of the actor is 1 and a random chance of 1 in 4 succeeds, decrease the excitement of the actor;
	if the concentration of the actor is 2 and a random chance of 1 in 3 succeeds, decrease the excitement of the actor;
	if the concentration of the actor is 3 and a random chance of 1 in 2 succeeds, decrease the excitement of the actor.


Section 1.1.1.2.5 - Saving

Check saving the game:
	decrease the zeal of the player by the level of the player;
	if the zeal of player is less than 0, now the zeal of the player is zero.


Section 1.1.1.2.6 - Undo

Rule for deciding whether to allow undo:
		if the combat boolean is 1 begin;
			say "You cannot undo during fights.";
			deny undo;
		end if.




Chapter 1.1.1.3 - Artifical Intelligence

Section 1.1.1.3.1 - Making sure the monsters attack

The monster attack boolean is a truth state that varies.

Every turn when a not summoned hostile alive monster is enclosed by the location:
	if the noattack boolean is true begin;
		now the noattack boolean is false;
	otherwise;
		repeat with the opponent running through not summoned hostile alive monsters enclosed by the location begin;
       			if the player is killed, stop;
			now the monster attack boolean is true;
			if the opponent is an onholder begin; [Holding on]
				if the hold location of the opponent is greater than 0 begin;
					now the monster attack boolean is false;
					have the opponent deal hold damage to the player;
				end if;
			end if;
			if the opponent is an erratic attacker begin; [Erratic attacker]
				now the first dummy is a random number between 1 and 6;
				if the first dummy is greater than the erratic attack odds of the opponent begin;
					now the global attacker is the opponent; [to make the messages come out good]
					say the erratic attack failure text of the opponent;
					now the monster attack boolean is false;
				end if;
			end if;
			now the monster dummy is the player;
			repeat with the victim running through summoned hostile alive monsters enclosed by the location begin;
				if a random chance of 1 in 8 succeeds, now the monster dummy is the victim;
			end repeat;
			if the  monster attack boolean is true, make the opponent strike a blow against the monster dummy;
		end repeat;
	end if.

Every turn when a summoned alive monster is enclosed by the location:
	if the noattack boolean is true begin;
		now the noattack boolean is false;
	otherwise;
		repeat with the opponent running through summoned alive monsters enclosed by the location begin;
       			if the player is killed, stop;
			now the monster dummy is the player;
			if an alive not summoned monster is enclosed by the location begin;
				now the first dummy is a random number between 1 and 5;
				if the first dummy is not 1 begin;
					now the monster dummy is a random alive not summoned monster enclosed by the location;
				end if;
			end if;
			make the opponent strike a blow against the monster dummy;
		end repeat;
	end if.



Chapter 1.1.1.4 - Taking away active bonuses


Section 1.1.1.4.0 - Triggering the rules

Last every turn when no hostile alive monster is enclosed by the location and no indifferent monster is enclosed by the location:
	if the combat boolean is 1, grant zeal;
	now the combat boolean is 0;
	take away all end-of-combat bonuses.


Last every turn when no hostile alive monster is enclosed by the location:
	if a random chance of 1 in 4 succeeds, decrease the excitement of the player.


After going:
	take away all until-moving bonuses;
	continue the activity.


Section 1.1.1.4.1 - Taking away all the until end of combat bonuses

To take away all end-of-combat bonuses:
	if the player is angry begin; now the player is not angry; say "Your anger subsides."; end if; [Anger]
	now the deadlier combat boolean is false; [Deadlier Combat]
	now the sacrificial number of the player is 0; [Sacrifice]
	cancel all scheduled giving the await bonus; [Await]
	now the await bonus is 0; now the potential await bonus is 0;
	cancel all scheduled taking away the await bonus.
		

Section 1.1.1.4.2 - Taking away all the until moving bonuses

To take away all until-moving bonuses:
	now the player is not at dodge;
	now the player is not at parry;
	now the elda armour status of the player is 0; [Bronze/Iron/Steel Armour]
	now the player is not shielded; [Shield]
	now the player is not determined; [Determination]




Book 1.2 - Skills

Section - Skills as Value

Skill is a kind of value. The Skills are defined by the Table of Player Skills.

Part 1.2.1 - The Skills Defined


Chapter 1.2.1.1 - Groth Skills


Section 1.2.1.1.1 - Smashing Blow

A person can be smashing or not smashing. A person is usually not smashing.

Understand the command "smash" as something new.
Smashing is an action applying to one object. Understand "smash [something]" as smashing.

Does the player mean smashing a killed person: it is very unlikely.
Does the player mean smashing a hostile alive monster: it is likely.


Check smashing:
  choose row with a Skill of Smashing Blow in the Table of Player Skills;
  if the have entry is 0, say "You try - fruitlessly, since you do not possess that skill." instead;
  if the noun is not a person, say "Things are not your enemies." instead;
  if the noun is not alive, say "[The noun] is already dead." instead;
  if the noun is not a monster, say "Save your energy for monsters." instead;
  if the zeal of the actor is less than the zealcost entry, say "You have no zeal left!" instead.

Carry out smashing:
	choose row with a Skill of Smashing Blow in the Table of Player Skills;
	now the actor is smashing;
	decrease the zeal of the actor by the zealcost entry;
	make the actor strike a blow against the noun;
	now the actor is not smashing.

To do smashing blow with (attacker - a person) and (defender - a person):
	change the first dummy to a random number from 1 to 6;
	if the first dummy is 1, now the second dummy is 1;
	if the first dummy is 2, now the second dummy is 2;
	if the first dummy is 3, now the second dummy is 3;
	if the first dummy is 4, now the second dummy is 4;
	if the first dummy is 5, now the second dummy is 6;
	if the first dummy is 6, now the second dummy is 8;
	say " + ", second dummy, " (smashing blow)";
	increase the damage modifier by second dummy; now the modified boolean is 1;
	continue the activity.



Section 1.2.1.1.2 - Boost Climb

The climb boost is a number that varies. The climb boost is 0.

Boosting climb is an action applying to one number. Understand "boost climb [a number]" and "boost [a number]" as boosting climb.

Check boosting climb:
	choose row with a Skill of Boost Climb in the Table of Player Skills;
	if the have entry is 0, say "You try - fruitlessly, since you do not possess that skill." instead;
	if the number understood is less than 1, say "You can only use a positive amount of zeal for that.";
	if the zeal of the actor is less than the number understood, say "You don't have enough zeal." instead;
	if the climb boost is not less than two times the number understood, say "That would be useless: you still have an unused boost of ", climb boost, " points." instead;
	if the number understood is greater than two times the level of the player, say "At your current level, you can only use up to ", two times the level of the player, " zeal with this skill." instead.

Carry out boosting climb:
	choose row with a Skill of Boost Climb in the Table of Player Skills;
	decrease the zeal of the actor by the number understood;
	now the climb boost is two times the number understood;
	say "You will receive a +", climb boost, " bonus on your next climb attempt.".



Section 1.2.1.1.3 - Anger

A person is either angry or not angry. A person is usually not angry.

Becoming angry is an action out of world. Understand "angry" and "anger" as becoming angry.

Check becoming angry:
	choose row with a Skill of Anger in the Table of Player Skills;
	if the have entry is 0, say "You try - fruitlessly, since you do not possess that skill." instead;
	if the zeal of the actor is less than the zealcost entry, say "You don't have enough zeal." instead;
	if the actor is angry, say "You are angry already." instead.

Carry out becoming angry:
	choose row with a Skill of Anger in the Table of Player Skills;
	decrease the zeal of the player by the zealcost entry;
	say "Rising anger makes you fearsome but reckless.";
	now the actor is angry;
	calculate the combat significance;
	if the combat significance is greater than 1 begin;
		if a random chance of 1 in 2 succeeds, say "[one of] 'Yes, angry!', Groth exclaims.[or] 'Good! You real fighter!', Groth tells you in the back of your mind.[at random]";
	end if.

To do calculating anger with (attacker - a person) and (defender - a person):
	say " + 2 (attacker angry)";
	increase the damage modifier by 2; now the modified boolean is 1.



Section 1.2.1.1.4 - Deadlier combat

Deadlier combat boolean is a truth state that varies. Deadlier combat boolean is false.

Every turn: if no hostile monster is alive enclosed by the location, now deadlier combat boolean is false.

Starting deadlier combat is an action out of world. Understand "deadlier combat" as starting deadlier combat.

Check starting deadlier combat:
  choose row with a Skill of Deadlier Combat in the Table of Player Skills;
  if the have entry is 0, say "You try - fruitlessly, since you do not possess that skill." instead;
  if the zeal of the actor is less than the zealcost entry, say "You don't have enough zeal." instead;
  if deadlier combat boolean is true, say "This combat is already deadlier." instead.

Carry out starting deadlier combat:
	choose row with a Skill of Deadlier Combat in the Table of Player Skills;
	decrease the zeal of the player by the zealcost entry;
	say "The gods enthusiastically grant your request.";
	now the deadlier combat boolean is true.




  

Chapter 1.2.1.2 - Elda Skills 


Section 1.2.1.2.1 - Bronze Armour

A person has a number called elda armour status. The elda armour status of a person is usually 0.
A person has a number called the elda armour chance. The elda armour chance of a person is usually 0.
A person has a number called elda armour amount. The elda armour amount of a person is usually 0.

Metal is a kind of value. The metals are bronze, iron and steel.

Elda armour metal is a metal that varies.


Making bronze armour is an action applying to nothing. Understand "bronze armour" as making bronze armour.

Check making bronze armour:
	choose row with a Skill of Bronze Armour in the Table of Player Skills;
	if the have entry is 0, say "You try - fruitlessly, since you do not possess that skill." instead;
	if the zeal of actor is less than the zealcost entry, say "You do not have enough zeal!" instead.

Carry out making bronze armour:
	choose row with a Skill of Bronze Armour in the Table of Player Skills;
	now the elda armour status of the player is 4;
	now the elda armour chance of the player is 4;
	now the elda armour amount of the player is 3;
	now the elda armour metal is bronze;
	decrease the zeal of the actor by the zealcost entry;
	say "You feel your skin harden as if it were bronze[if a random chance of 1 in 4 succeeds]. 'Real men don't need armour!', Groth growls[end if].".


To do elda armour with (the attacker - a person) and (the defender - a person):
	if the elda armour status of the defender is greater than 0 begin;
		change the first dummy to a random number from 1 to 6;
		increase the first dummy by 1;
		if the first dummy is greater than the elda armour chance of the defender begin;
			now the second dummy is the final damage;
			if the second dummy is greater than the elda armour amount of the defender, now the second dummy is the elda armour amount of the defender;
			decrease the final damage by the second dummy;
			decrease the elda armour status of the defender by 1;
			if the final damage is 0 begin;
				say "all of which is absorbed by the [elda armour metal] armour";
			end if;
			if the final damage is greater than 0, say second dummy, " of which is absorbed by the [elda armour metal] armour (leaving ", final damage, ")";
			if the elda armour status of the defender is 0, say " (dispelling it)";
			say ", ";
			continue the activity;
		otherwise;
			say "bypassing the [elda armour metal] armour, ";
		end if;
	end if.



Section 1.2.1.2.2 - Curse

A person can be cursed or not cursed. A person is usually not cursed.

Cursing is an action applying to one thing. Understand "curse [person]" as cursing.

Check cursing:
	choose row with a Skill of Curse in the Table of Player Skills;
	if the have entry is 0, say "You try - fruitlessly, since you do not possess that skill." instead;
	if the zeal of actor is less than the zealcost entry, say "You do not have enough zeal!" instead.
	
Carry out cursing:
	choose row with a Skill of Curse in the Table of Player Skills;
	decrease the zeal of the actor by the zealcost entry;
	say "You [one of]raise your hands and trace intricate patterns in the air[or]point your finger at [the noun] and mutter a few arcane words[or]fix [the noun] with your cold stare and say a single Word of Power[or]shriek horribly at the top of your lungs, holding your sword straight up[at random].";
	now the noun is cursed.
	
	
To do cursed with (the attacker - a person) and (the defender - a person):
	say " -  2 (cursed)";
	decrease the to-hit modifier by 2.
	
To do remove curse with (the attacker - a person) and (the defender - a person):
	say " (breaking the curse!)[run paragraph on]";
	now the attacker is not cursed.



Section 1.2.1.2.3 - Shield

A person can be shielded or not shielded. A person is usually not shielded.

Shielding is an action applying to nothing. Understand "shield" as shielding.

Check shielding:
	choose row with a Skill of Shield in the Table of Player Skills;
	if the have entry is 0, say "You try - fruitlessly, since you do not possess that skill." instead;
	if the zeal of actor is less than the zealcost entry, say "You do not have enough zeal!" instead.

Carry out shielding:
	choose row with a Skill of Shield in the Table of Player Skills;
	decrease the zeal of the actor by the zealcost entry;
	now the actor is shielded;
	say "The magic will shield you, improving the [italic type]defend[roman type] action.".



Section 1.2.1.2.4 - Gaseous Form

A person can be gaseous or not gaseous. A person is usually not gaseous.

Becoming gaseous is an action applying to nothing. Understand "gas" and "gaseous" and "gaseous form" as becoming gaseous.

Check becoming gaseous:
	choose row with a Skill of Gaseous Form in the Table of Player Skills;
	if the have entry is 0, say "You try - fruitlessly, since you do not possess that skill." instead;
	if the zeal of actor is less than the zealcost entry, say "You do not have enough zeal!" instead.

Carry out becoming gaseous:
	choose row with a Skill of Gaseous Form in the Table of Player Skills;
	decrease the zeal of the actor by the zealcost entry;
	now the actor is gaseous;
	say "Your body turns insubstantial--for the rest of this turn, you will be immune to attacks!".


Last every turn:
	repeat with current person running through gaseous persons enclosed by the location begin;
		now the current person is not gaseous;
	end repeat.



Section 1.2.1.2.6 - Iron Armour


Making iron armour is an action applying to nothing. Understand "iron armour" as making iron armour.

Check making iron armour:
	choose row with a Skill of iron Armour in the Table of Player Skills;
	if the have entry is 0, say "You try - fruitlessly, since you do not possess that skill." instead;
	if the zeal of actor is less than the zealcost entry, say "You do not have enough zeal!" instead.

Carry out making iron armour:
	choose row with a Skill of iron Armour in the Table of Player Skills;
	now the elda armour status of the player is 3;
	now the elda armour chance of the player is 5;
	now the elda armour amount of the player is 3;
	now the elda armour metal is iron;
	decrease the zeal of the actor by the zealcost entry;
	say "You feel your skin harden as if it were iron[if a random chance of 1 in 4 succeeds]. 'Real men don't need armour!', Groth growls[end if].".


Section 1.2.1.2.12 - Steel Armour


Making steel armour is an action applying to nothing. Understand "steel armour" as making steel armour.

Check making steel armour:
	choose row with a Skill of steel Armour in the Table of Player Skills;
	if the have entry is 0, say "You try - fruitlessly, since you do not possess that skill." instead;
	if the zeal of actor is less than the zealcost entry, say "You do not have enough zeal!" instead.

Carry out making steel armour:
	choose row with a Skill of steel Armour in the Table of Player Skills;
	now the elda armour status of the player is 3;
	now the elda armour chance of the player is 5;
	now the elda armour amount of the player is 3;
	now the elda armour metal is steel;
	decrease the zeal of the actor by the zealcost entry;
	say "You feel your skin harden as if it were steel[if a random chance of 1 in 4 succeeds]. 'Real men don't need armour!', Groth growls[end if].".




Chapter 1.2.1.3 - Duncan Skills

Section 1.2.1.3.1 - Burning Hands

[First, we are going to define burning.]

A person is either on fire or not on fire. A person is usually not on fire.
A person has a number called the burn time.
A person has a number called the minimum burn damage.
A person has a number called the maximum burn damage.

After printing the name of an on fire monster:
	if the printing state is not printing-fiery, say " (burning)".

Every turn:
	repeat with burner running through on fire persons begin;
		if the player is killed, stop the action;
		if the burner is not enclosed by the location, decrease the burn time of the burner by 1;	
		if the burner is enclosed by the location begin;
			if the burner is alive begin;
				now the printing state is printing-fiery;
				now the first dummy is a random number between the minimum burn damage of the burner and the maximum burn damage of the burner;
				if the burner is not the player, say "The flames deal ", first dummy, " damage to [the burner].[run paragraph on]";
				if the burner is the player, say "The flames deal ", first dummy, " damage to you.[run paragraph on]";
				deal first dummy damage to the burner with alternative layout;
				now the printing state is printing-normal;
				decrease the burn time of the burner by 1;
			end if; 
		end if;
		if the burn time of the burner is 0 begin;
			now the burner is not on fire;
			if the burner is not the player, say "The flames around [the burner] die out.[paragraph break]";
			if the burner is the player, say "You are no longer on fire![paragraph break]";
		end if;
		if the burner is killed, now the burner is not on fire;
	end repeat.

[Second, we are going to define the effects of burning. But this is all done in the combat routines.]

[Third, we define the burning hands skills proper]

The block burning rule is not listed in any rulebook.

Check burning:
  choose row with a Skill of Burning Hands in the Table of Player Skills;
  if the have entry is 0, say "You will need the [italic type]Burning Hands[roman type] skill for that." instead;
  if the zeal of the actor is less than the zealcost entry, say "You don't have enough zeal." instead.

Carry out burning:
	if the noun is not an alive monster, say "It is no use trying to set fire to that." instead;
	choose row with a Skill of Burning Hands in the Table of Player Skills;
	decrease the zeal of the player by the zealcost entry;
	if the hold location of the noun is not greater than 0 begin;
		say "You approach [the noun], eliciting a free attack against you. ";
		now the attack state is free;
		make the noun strike a blow against the player;
	otherwise;
		say "Since [the noun] is holding on to you, you do not have to venture a dangerous approach. ";
	end if;
	now the attack state is fiery;
	make the player strike a blow against the noun.

[Fourth, we define setting fire to someone]

To set fire to (the sucker - a person):
	if the sucker is not fireproof begin;
		now the burn time of the sucker is 5;
		now the minimum burn damage of the sucker is 1;
		now the maximum burn damage of the sucker is 5;
		now the sucker is on fire;
	otherwise;
		say " (But [the sucker] is immune to fire!) ";
	end if.

To silently set fire to (the sucker - a person):
	if the sucker is not fireproof begin;
		now the burn time of the sucker is 5;
		now the minimum burn damage of the sucker is 1;
		now the maximum burn damage of the sucker is 5;
		now the sucker is on fire;
	end if.


Section 1.2.1.3.2 - Summon Imps

Summoning imps is an action applying to nothing. Understand "summon imps" and "summon imp" and "imps" and "imp" as summoning imps.

Check  summoning imps:
	choose row with a Skill of Summon Imps in the Table of Player Skills;
	if the have entry is 0, say "You do not have the appropriate skill!" instead;
	if the zeal of the actor is less than the zealcost entry, say "You don't have enough zeal." instead.

Carry out summoning imps:
	choose row with a Skill of Summon Imps in the Table of Player Skills;
	decrease the zeal of the player by the zealcost entry;
	say "You wave your hands, and three imps appear on the battlefield, eager to help your cause! Or so you hope.";
	move the green imp to the location;
	move the red imp to the location;
	move the blue imp to the location;
	now the blood of the green imp is 3;
	now the blood of the red imp is 3;
	now the blood of the blue imp is 4.


Section 1.2.1.3.3 - Scout

Scouting is an action applying to one visible thing. Understand "scout [a direction]" as scouting.

The scouting boolean is a truth state that varies. The scouting boolean is false.

Check scouting:
	choose row with a Skill of Scout in the Table of Player Skills;
	if the have entry is 0, say "You do not have the appropriate skill!" instead;
	if the zeal of the actor is less than the zealcost entry, say "You don't have enough zeal." instead.

Carry out scouting:
	choose row with a Skill of Scout in the Table of Player Skills;	
	decrease the zeal of the player by the zealcost entry;
	now the scouting boolean is true;
	say "You attempt to scout.";
	try going the noun.


Section 1.2.1.3.4 - Fire Bomb

Firebombing is an action applying to nothing. Understand "bomb" and "fire bomb" and "firebomb" as firebombing.

The fire bomb time is a number that varies.

The bomb is a thing. "Hovering in the air, a small red ball radiates heat onto the battlefield. It is the fire bomb." Instead of taking, pushing or pulling the bomb: say "It is far too hot to touch!". Instead of examining the bomb: say "It appears to be a metal ball, heated until it glows with a faint red glare.". Instead of listening to the bomb: say "The bomb hisses and clicks.". Understand "fire" and "ball" and "red" and "hot" as the bomb.

Check firebombing:
	choose row with a Skill of Fire Bomb in the Table of Player Skills;
	if the have entry is 0, say "You do not have the appropriate skill!" instead;
	if the zeal of the actor is less than the zealcost entry, say "You don't have enough zeal." instead;
	if the bomb is enclosed by the location, say "You cannot have multiple fire bombs at the same time." instead.

Carry out firebombing:
	choose row with a Skill of Fire Bomb in the Table of Player Skills;
	decrease the zeal of the player by the zealcost entry;
	say "You throw your hands in the air, and a fire bomb appears in the middle of the battlefield!";
	move the bomb to the location;
	now the fire bomb time is a random number between 1 and 3.

Every turn when the bomb is enclosed by the location:
	if the fire bomb time is 0 begin;
		say "With an enormous [bold type]BANG[roman type] the fire bomb explodes! (";
		now the printing state is printing-fiery;
		repeat with the sucker running through alive not gaseous monsters enclosed by the location begin;
			now the first dummy is a random number between 1 and 6;
			say "Rolling ", first dummy, " against a target number of 5, ";
			if the first dummy is less than 5 begin;
				if the sucker is not fireproof begin;
					say "[the sucker] catches fire. ";
					silently set fire to the sucker;
				otherwise;
					say "[the sucker] would have caught fire if it had not been resistant. ";
				end if;
			otherwise;
				say "[the sucker] does not catch fire. ";
			end if;
		end repeat;
		if the player is not gaseous begin;
			now the first dummy is a random number between 1 and 6;
			say "Anticipating the explosion and rolling ", first dummy, " against a target number of 3, ";
			if the first dummy is less than 3 begin;
				set fire to the player;
				say "you, alas, catch fire!)";
			otherwise;
				say "you duck away at right moment!)";
			end if;
		otherwise;
			say "You are gaseous, and escape the fire.)";
		end if;
		remove the bomb from play;
		now the printing state is printing-normal;
	end if;
	decrease the fire bomb time by 1.


Chapter 1.2.1.4 - Shliss Skills



Section 1.2.1.4.1 - Needle

Needling is an action applying to one thing. Understand "needle [a person]" as needling.

Check needling:
	choose row with a Skill of Needle in the Table of Player Skills;
	if the have entry is 0, say "Shliss doesn't answer your request, since you do not possess that skill." instead;
	if the zeal of the actor is less than the zealcost entry, say "You don't have enough zeal." instead;
	if the noun is not an alive monster, say "You can only needle live opponents." instead.

Carry out needling:
	choose row with a Skill of Needle in the Table of Player Skills;
	decrease the zeal of the player by the zealcost entry;
	if a random chance of 1 in 6 succeeds, say "Your needle misses." instead;
	say "[one of]Your needle deals 2 damage to [the noun][or]A sharp needle speeds from your hand and hits [the noun] for 2 damage[or]You point a finger at [the noun] and speak a Word of Power. A magical needle shoots from your finger, dealing 2 damage[at random].[run paragraph on]";
	deal 2 damage to the noun with alternative layout. 



Section 1.2.1.4.2 - Determination

Determining is an action applying to nothing. Understand "determination" and "det" as determining.

Determining is acting fast.

A person is either determined or not determined. A person is usually not determined.


Check determining:
	choose row with a Skill of Determination in the Table of Player Skills;
	if the have entry is 0, say "Shliss doesn't answer your request, since you do not possess that skill." instead;
	if the zeal of the actor is less than the zealcost entry, say "You don't have enough zeal." instead.

Carry out determining:
	choose row with a Skill of Needle in the Table of Player Skills;
	decrease the zeal of the player by the zealcost entry;
	now the player is determined;
	say "You are determined to win this fight!".



Section 1.2.1.4.3 - Sacrifice

Sacrificing is an action applying to one number. Understand "sacrifice [a number]" as sacrificing.

Sacrificing is acting fast.

A person has a number called the sacrificial number. The sacrificial number of a person is usually 0.

Check sacrificing:
	choose row with a Skill of Sacrifice in the Table of Player Skills;
	if the have entry is 0, say "Shliss doesn't answer your request, since you do not possess that skill." instead;
	if the number understood is less than 1, say "You have to sacrifice a positive amount of Blood." instead;
	if the zeal of the actor is less than the zealcost entry, say "You don't have enough zeal." instead.

Carry out sacrificing:
	choose row with a Skill of Sacrifice in the Table of Player Skills;
	decrease the zeal of the player by the zealcost entry;
	say "You sacrifice ", the number understood, " Blood for a +", the number understood, " bonus on your next attack.[run paragraph on]";
	deal the number understood damage to the player with alternative layout;
	now the sacrificial number of the player is the number understood.



Section 1.2.1.4.4 - Await

Awaiting is an action applying to one number. Understand "await [a number]" as awaiting.

The await bonus is a number that varies. The await bonus is 0. The potential await bonus is a number that varies. The potential await bonus is 0. The damage await bonus is a number that varies. The damage await bonus is 0.

Giving the await bonus is an activity. Taking away the await bonus is an activity.

Rule for giving the await bonus:
	say "[bold type](Remember: you now have your await bonus!)[roman type][paragraph break]";
	now the await bonus is the potential await bonus;
	now the potential await bonus is 0.

Rule for taking away the await bonus:
	now the await bonus is 0.

Check awaiting:
	choose row with a Skill of Await in the Table of Player Skills;
	if the have entry is 0, say "Shliss doesn't answer your request, since you do not possess that skill." instead;
	if the number understood is less than 1, say "You must Await a positive number of turns." instead;
	if the zeal of the actor is less than the zealcost entry, say "You don't have enough zeal." instead.

Carry out awaiting:
	choose row with a Skill of Await in the Table of Player Skills;
	decrease the zeal of the player by the zealcost entry;
	if there is giving the await bonus scheduled begin;
		say "You override your earlier Await command.";
	otherwise;
		say "You await your chance.";
	end if;
	now the potential await bonus is the number understood;
	now the first dummy is the number understood - 1;
	schedule giving the await bonus in the first dummy turns;
	schedule taking away the await bonus in the number understood turns.





Section 1.2.1.4.99 - Crackling Weapon 

[TODO]

A person is either crackling or not crackling. A person is usually not crackling. A person is either crackled or not crackled. A person is usually not crackled.

Getting crackling weapon is an action applying to nothing. Understand "crackling weapon" and "crackling" and "crackle" as getting crackling weapon.

[Check getting crackling weapon:
  choose row with a Skill of Crackling Weapon in the Table of Player Skills;
  if the have entry is 0, say "Shliss doesn't answer your request, since you do not possess that skill." instead;
  if the zeal of the actor is less than the zealcost entry, say "You don't have enough zeal." instead;
  if the actor is crackling, say "Your weapon is crackling already!" instead.

Carry out getting crackling weapon:
  choose row with a Skill of Crackling Weapon in the Table of Player Skills;
  decrease the zeal of the player by the zealcost entry;
  say "Lightning flashes across the sky, hitting your sword!";
  now the actor is crackling.]

To do crackling weapon with (attacker - a person) and (defender - a person):
       change the first dummy to a random number from 1 to 6;
       if the first dummy is 1, now the second dummy is 0;
       if the first dummy is 2, now the second dummy is 0;
       if the first dummy is 3, now the second dummy is 0;
       if the first dummy is 4, now the second dummy is 2;
       if the first dummy is 5, now the second dummy is 5;
       if the first dummy is 6, now the second dummy is 0;
       if the second dummy is greater than 0 begin;
		 say " + ", second dummy, " (crackling weapon)";
       		increase the damage modifier by second dummy;
		now the modified boolean is 1;
	end if;
	if the first dummy is 6, now the attacker is crackled.
	
To determine crackle aftereffect:
	if the player is crackled begin;
		now the player is not crackled;
		say "[paragraph break]Lightning from your weapon strikes back at you for 3 damage![if a random chance of 1 in 6 succeeds] 'I love this skill,' Shliss happily remarks.[end if][run paragraph on]";
		deal 3 damage to the player;
	end if;
	








Chapter 1.2.1.5 - The four skill checks


Section 1.2.1.5.1 - Climbing

The climb boolean is a number that varies.

To make a climb check of difficulty (difficulty - a number):
	now the climb boolean is 1;
	now the first dummy is 0; now the second dummy is 0; now the third dummy is 0;
	change the first dummy to a random number between 1 and 6;
	now the second dummy is the climb boost;
	now the third dummy is the first dummy + the second dummy;
	say "(Climb check: ", first dummy, " + ", second dummy, " = ", third dummy, ", against a difficulty of ", difficulty, ".)[paragraph break]";
	now the climb boost is 0;
	if the difficulty is greater than the third dummy, now the climb boolean is 0.
	







Part 1.2.2 - Skill Table




Table 3.6 - Player Skills
Skill					Type			Have	OffDefNeu	ZealCost		Lev
Smashing Blow		"Groth"		0			"OFF"		1			1
Boost Climb			"Groth"		0			"NEU"		1			1
Anger				"Groth"		0			"OFF"		1			1
Deadlier Combat		"Groth"		0			"OFF"		1			1
Groth 5				"Groth"		0			"NEU"		2			2
Cleave				"Groth"		0			"OFF"		0			2
Fury					"Groth"		0			"OFF"		2			2
Groth 8				"Groth"		0			"NEU"		3			3
Armour of Blood		"Groth"		0			"DEF"		2			3
Crushing Blow			"Groth"		0			"OFF"		0			3
Improved Cleave		"Groth"		0			"OFF"		3			4
Rage				"Groth"		0			"OFF"		3			4
Duel				"Groth"		0			"OFF"		5			5
Bronze Armour		"Elda"		0			"DEF"		1			1
Curse				"Elda"		0			"NEU"		1			1
Shield				"Elda"		0			"DEF"		1			1
Gaseous Form		"Elda"		0			"DEF"		1			1
Elda 5				"Elda"		0			"NEU"		2			2
Iron Armour			"Elda"		0			"DEF"		2			2
Improved Curse		"Elda"		0			"NEU"		1			2
Mirror Image			"Elda"		0			"DEF"		3			3
Steel Armour			"Elda"		0			"DEF"		1			3
Elda 10				"Elda"		0			"NEU"		3			3
Mass Curse			"Elda"		0			"NEU"		4			4
Ethereal				"Elda"		0			"DEF"		5			4
Doppelganger			"Elda"		0			"DEF"		5			5
Burning Hands		"Duncan"	0			"OFF"		1			1
Summon Imps		"Duncan"	0			"NEU"		2			1
Scout				"Duncan"	0			"NEU"		1			1
Fire Bomb			"Duncan"	0			"OFF"		2			1
Duncan 5			"Duncan"	0			"NEU"		2			2
Chaos				"Duncan"	0			"NEU"		2			2
Skirmish				"Duncan"	0			"NEU"		2			2
Summon Demons		"Duncan"	0			"NEU"		3			3
Fireball				"Duncan"	0			"OFF"		3			3
Utter Chaos			"Duncan"	0			"NEU"		4			3
Duncan 11			"Duncan"	0			"NEU"		4			4
Summon Horde		"Duncan"	0			"NEU"		5			4
Duncan 13			"Duncan"	0			"NEU"		4			5
Needle				"Shliss"		0			"OFF"		1			1
Determination			"Shliss"		0			"OFF"		2			1
Sacrifice				"Shliss"		0			"NEU"		1			1
Await				"Shliss"		0			"NEU"		2			1
Dominate			"Shliss"		0			"NEU"		2			2
Bleed				"Shliss"		0			"NEU"		2			2
Doom				"Shliss"		0			"OFF"		3			2
Combat Superiority		"Shliss"		0			"NEU"		3			3
Improved Determination	"Shliss"		0			"NEU"		2			3
Shliss 10				"Shliss"		0			"NEU"		0			3
Mass Dominate		"Shliss"		0			"NEU"		4			4
Shliss 12				"Shliss"		0			"NEU"		5			4
Knell				"Shliss"		0			"OFF"		5			5



Part 1.2.3 - The Commands and Learning


Section 1.2.3.0.1 - Learning Skills

An Idol is a kind of thing. A Groth Idol is a kind of Idol. An Elda Idol is a kind of idol. A Duncan Idol is a kind of idol. A Shliss Idol is a kind of idol.

After taking an idol for the first time: say "[italic type]A female voice say: 'Good! As you collect these idols, we will allow you to learn skills. You should search especially well for statues of a female bearing a shield: those are mine, Elda's, and my skills are the most useful.'[paragraph break]'You bet!', snorts a young man.[paragraph break](Type 'skills' if you need help with learning and using skills. If you have not done so already, you may also wish to type 'help'.)[roman type][paragraph break]".

Instead of examining a Groth Idol: say "A little stone statue, apparently quite old, of a naked man carrying a sword. The symbol of the sun is engraved on his forehead.".
Instead of examining an Elda Idol: say "A little stone statue, apparently quite old, of an armoured woman bearing a large shield. The symbol of the moon is engraved on the shield.".
Instead of examining a Duncan Idol: say "A little stone statue, apparently quite old, of a person enveloped in flames.".
Instead of examining a Shliss Idol: say "A little stone statue, apparently quite old, of a robed man. Instead of a head, a grinning skull looks out of the robe's hood.".


Learning is an action applying to one skill. Understand "learn [a skill]" as learning.

Instead of learning a skill listed in the Table of Player Skills:
	if the have entry is 1, say "You already know it!" instead;
	if the Lev entry is greater than the level of the player, say "You must be at least level ", Lev entry, " to learn that skill." instead;
	if the type entry is "Groth" begin;
	        if the number of Groth idols carried by the player is less than 1 begin;
			say "You do not have enough Groth Idols!" instead;
		otherwise;
		        change the have entry to 1;
			say "Groth blesses you with the knowledge of [skill entry]!";
		end if; 
	end if;
	if the type entry is "Elda" begin;
	        if the number of Elda idols carried by the player is less than 1 begin;
			say "You do not have enough Elda Idols!" instead;
		otherwise;
		        change the have entry to 1;
			say "Elda mercifully grants you knowledge of [skill entry].";
		end if;
	end if; 
	if the type entry is "Duncan" begin;
	        if the number of Duncan idols carried by the player is less than 1 begin;
			say "You do not have enough Duncan Idols!" instead;
		otherwise;
		        change the have entry to 1;
			say "Duncan teaches you the secrets of [skill entry]!";
		end if; 
	end if;
	if the type entry is "Shliss" begin;
	        if the number of Shliss idols carried by the player is less than 1 begin;
			say "You do not have enough Shliss Idols!" instead;
		otherwise;
		        change the have entry to 1;
			say "Shliss burdens you with the knowledge of [skill entry]!";
		end if; 
	end if. 


Section 1.2.3.0.2 - The Skills command

Bringing up the skills menu is an action out of world. Understand "skills" as bringing up the skills menu.

Carry out bringing up the skills menu:
	change the current menu to the Table of Skills;
	carry out the displaying activity;
	clear the screen;
	try looking.

Section 1.2.3.0.3 - The List Skills command

Listing the skills is an action out of world. Understand "list skill" and "list skills" as listing the skills.

Carry out listing the skills:
	[First, we count the number of skills the player has.]
	now the first dummy is 0; now the second dummy is 0;
	repeat through the Table of Player Skills begin;
		if the have entry is 1, increase the first dummy by 1;
	end repeat;
	if the first dummy is 0 begin;
		say "You still have to learn your first skill."; stop the action;
	end if;
	say "You know the following skills: ";
	repeat through the Table of Player Skills begin;
		if the have entry is 1 begin;
			increase the second dummy by 1;
			say "[skill entry]";
			if the type entry is "Groth", say " (G)";
			if the type entry is "Elda", say " (E)";
			if the type entry is "Duncan", say " (D)";
			if the type entry is "Shliss", say " (S)";
			if the second dummy + 1 is less than the first dummy, say ", ";
			if the second dummy + 1 is the first dummy, say " and ";
			if the second dummy is the first dummy, say ".";
		end if;
	end repeat.

Section 1.2.3.0.4 - The learnable Skills command

Listing the learnable skills is an action out of world. Understand "learnable skills" and "learn skill" and "learn skills" as listing the learnable skills.

Carry out listing the learnable skills:
	[First, we count the number of skills the player can learn.]
	now the first dummy is 0; now the second dummy is 0;
	repeat through the Table of Player Skills begin;
	    if the Lev entry is not greater than the level of the player begin;
		if the have entry is 0 begin;
			increase the first dummy by 1;
		end if;
	   end if;
	end repeat;
	if the first dummy is 0 begin;
		say "You can't learn any skill."; stop the action;
	end if;
	say "You can learn the following skills: ";
	repeat through the Table of Player Skills begin;
		if the have entry is 0 begin;
		    if the Lev entry is not greater than the level of the player begin;
			if the type entry is "Groth" begin;
				say "[skill entry] (G)";
				increase the second dummy by 1; now the third dummy is 1;
			end if;
			if the type entry is "Elda" begin;
				say "[skill entry] (E)";
				increase the second dummy by 1; now the third dummy is 1;
			end if;
			if the type entry is "Duncan" begin;
				say "[skill entry] (D)";
				increase the second dummy by 1; now the third dummy is 1;
			end if;
			if the type entry is "Shliss" begin;
				say "[skill entry] (S)";
				increase the second dummy by 1; now the third dummy is 1;
			end if;
			if the third dummy is 1 begin;
				if the second dummy + 1 is less than the first dummy, say ", ";
				if the second dummy + 1 is the first dummy, say " and ";
				if the second dummy is the first dummy, say ".";
			end if;
			now the third dummy is 0;
		   end if;
		end if;
	end repeat.
	
	

Section 1.2.3.0.5 - The Usable Skills command

Listing the usable skills is an action out of world. Understand "usable skills" and "use skill" and "use skills" as listing the usable skills.

Carry out listing the usable skills:
	[First, we count the number of skills the player can use.]
	now the first dummy is 0; now the second dummy is 0;
	repeat through the Table of Player Skills begin;
		if the have entry is 1 begin;
			if the zealcost entry is not greater than the zeal of the player, increase the first dummy by 1;
		end if;
	end repeat;
	if the first dummy is 0 begin;
		say "You cannot use any skill."; stop the action;
	end if;
	say "You can use the following skills: ";
	repeat through the Table of Player Skills begin;
		if the have entry is 1 begin;
			if the zealcost entry is not greater than the zeal of the player begin;
				increase the second dummy by 1;
				say "[skill entry]";
				if the type entry is "Groth", say " (G)";
				if the type entry is "Elda", say " (E)";
				if the type entry is "Duncan", say " (D)";
				if the type entry is "Shliss", say " (S)";
				if the second dummy + 1 is less than the first dummy, say ", ";
				if the second dummy + 1 is the first dummy, say " and ";
				if the second dummy is the first dummy, say ".";
			end if;
		end if;
	end repeat.





Book 1.3 - Zeal



Part 1.3.2 - Zeal

To grant zeal:
	now the third dummy is the zeal of the player;
	if the third dummy is less than the permanent zeal of the player, now the third dummy is the permanent zeal of the player; [Zeal shouldn't become higher than maximum, unless it already is, in which case it should stay the same]	
	if the initial combat significance is greater than 0 begin;
		now the second dummy is 0;
		if the initial combat significance is 1, now the second dummy is 1;
		if the initial combat significance is 2, now the second dummy is 2;
		if the initial combat significance is 3 begin;
			now the second dummy is a random number between 3 and the level of the player;
			if the second dummy is less than 3, now the second dummy is 3;
		end if;
		if the initial combat significance is 4 begin;
			now the second dummy is a random number between 5 and 2 times the level of the player;
			if the second dummy is less than 5, now the second dummy is 5;
		end if;
		say "The Gods collectively reward you with ", second dummy, " zeal![run paragraph on]";
		if the zeal of the player is not less than the permanent zeal of the player, say " (But you already were at your maximum.)[run paragraph on]";
		increase the zeal of the player by the second dummy;
		now the first dummy is 1;
	end if;
	say "[paragraph break]";
	now the combat boolean is 0;
	if the zeal of the player is greater than the permanent zeal of the player, now the zeal of the player is the third dummy;
	continue the activity.




Book 1.5 - Menu

Understand "menu" as asking for help.

Chapter 1.5.0.1 - The Menu Structure

When play begins:
     choose row 1 in Table of Basic Help Options;
     change description entry to "Een vette descriptie!";
     choose row 2 in Table of Basic Help Options;
     change title entry to "Standard Combat Actions";
     change subtable entry to Table of Actions Help.

Table of Basic Help Options (continued)
Title			Subtable		Description			Toggle
"Skills"		Table of Skills	a text				a rule


Chapter 1.5.0.2 - Actions Help


Table 43.1 - Actions Help
Title				Subtable		Description			Toggle
"Combat Basics"	--		"[combat basics first part][combat basics second part]"		--
"Attack"		--			"ATTACK[paragraph break]The most basic combat action is attacking. You will attempt to hit your enemy from close by and deal damage to him, which will be subtracted from his Blood. Once his Blood drops to 0 or below, the enemy will die.[paragraph break]Everyone has a melee attack skill and a defence skill. You hit your enemy if a random roll between 1 and 6, plus your melee attack skill, is [italic type]higher[roman type] than his defence skill. Additional modifiers may apply, and will be detailed when the attack is attempted.[paragraph break][italic type]Grammar:[roman type] attack [italic type]opponent[roman type]; a [italic type]opponent[roman type]."			--
"Defend"		--			"DEFEND[paragraph break]When you defend, you strike up a defensive pose, making your enemies less likely to harm you.[paragraph break]Defending decreases the damage of all attacks done against you by a random number between 0 and 3. This bonus stays in place as long as you do not take offensive actions. Defending, concentrating, waiting and attempting a retreat will not break off your defensive stance, but attacking or using an offensive skill will.[paragraph break][italic type]Grammar:[roman type] defend."
"Concentrate"	--			"CONCENTRATE[paragraph break]When you concentrate, you are preparing to strike a more accurate and more devastating blow.[paragraph break]You build op concentration by concentrating for a number of turns. After one turn, you have mild concentration, which gives you a +1 to hit on your next attack. After two turns of concentration, you will have a +2 to hit and a +1 to damage. After three turns of concentrating, you will have a +3 to hit and a +2 to damage. However, your concentration can also be broken! Retreating, moving, and using most skills will break your concentration, as will being damaged.[paragraph break][italic type]Grammar:[roman type] concentrate; c."
"Retreat"		--			"RETREAT[paragraph break]If you fear to lose a fight, you can always attempt to retreat. Your chance of success depends on the numbers, health and speed of your opponents.[paragraph break]To successfully retreat, a random roll of one die must be higher than the total retreat score of your enemies. Each enemy you face contributes 1 to this total retreat score, with the following modifiers: particularly slow enemies contribute 0; particularly fast enemies contribute 2; contributions from enemies with more Blood than you have count double. Thus, a fast enemy with more Blood than you adds 4 to the total retreat score.[paragraph break][italic type]Grammar:[roman type] retreat."
"Statistics"		--			"STATISTICS[paragraph break]The most vital information about your character--her blood and zeal--is always displayed at the top of the screen. However, sometimes you may wish to review some more advanced information, such as which skills you have activated, how concentrated you are, what your melee modifier is, whether you are poisoned, and so forth. The statistics, or stats, command exists for this purpose. It will show you a brief overview of the current status of your character.[paragraph break][italic type]Grammar:[roman type] stats."

To say combat basics first part:
	say "COMBAT BASICS[paragraph break]Tactical combat plays an important role in [italic type]Idols of War[roman type]. So before you even start playing, you should familiarise yourself with the basics of the combat system.[paragraph break]Combat is [italic type]turn based[roman type]. This means that you get to take a single action, and than all the other characters present in the current location get to take a single action. Once everybody has done what they wish to, it is your turn again.[paragraph break]In combat, you will generally wish to take one of the standard combat actions or use one of the special skills you have learned. When the game starts, you know no special skills, so you don't have to worry about them until later. There are four standard combat actions, which you should know well if you wish to survive. If you wish to deal damage, you [bold type]attack[roman type]. If you wish to get less damage from the attacks of your opponents, you [bold type]defend[roman type]. If you wish to boost your chance to hit and your damage for the next attack, you [bold type]concentrate[roman type]. And if the combat proves too much for you, you [bold type]retreat[roman type]. For details,".
	
To say combat basics second part:
	say "read the descriptions of the individual actions.[paragraph break]When you attack, a virtual die is rolled to check if you hit. If you do hit, you deal an amount of damage--normally a random number between 1 and 6, but the amount can be increased or decreased by concentrating, using skills or items, or by special abilities of your opponents. When you deal damage, your opponent loses an amount of blood equal to the damage you dealt. As soon as the opponent has 0 or less damage, he is dead. If you kill all monsters in a location, you have won the fight.[paragraph break]If you keep losing a fight, try out different tactics. Maybe you need to concentrate more, to get your damage modifier up. Maybe you need to use a certain skills or get a certain kind of object. Or maybe you're just not good enough yet--you can always come back later and try again.[paragraph break]Don't forget to [bold type]save[roman type], but don't save too often: saving costs Zeal, which you also need to use your skills. The command [bold type]undo[roman type] is even costlier; use it sparingly.".


Chapter 1.5.0.3 - Skills Help



Table 1.5.0.3.0 - Skills
Title					Subtable			Description			Toggle
"How do skills work?"	--		"WHAT ARE SKILLS?[paragraph break]Your character knows several standard combat moves, such as attacking, shooting, charging and defending, but those moves will not be enough to grant her victory in all the many fights she will find herself in. Luckily, the Gods of War are willing to teach her special skills that give her new and powerful tactical options.[paragraph break]WHAT SKILLS ARE THERE?[paragraph break]In the previous menu (which you can always view by typing SKILLS), you saw entries for each of the four Gods of War. Following these will show you lists of all the skills the respective Gods can teach you. Selecting those skills will give you a description.[paragraph break]WHAT SKILLS DO I HAVE?[paragraph break]You start the game with no skills at all, but will gradually learn more. During the game, you can always type LIST SKILLS in order to review the skills you already have.[paragraph break]HOW DO I LEARN SKILLS?[paragraph break]You can learn skills by finding idols of the four gods. So if you wish Groth to teach you a skill, you will need to find idols of Groth. You can then request Groth to teach you a skill by typing LEARN [italic type]name of the skill[roman type] (for example: LEARN SMASHING BLOW). The number of idols it costs to learn a skill can be found in the skill description. You can always type LEARN SKILL to find out which skills you can currently learn.[paragraph break]HOW DO I USE SKILLS?[paragraph break]Every skill description contains a grammar entry, which tells you the right command to use that skill. Using a skill costs Zeal: if you do not have enough Zeal, you cannot use the skill. You can always type USE SKILL to find out which skills you can currently use."	a rule
"Groth's Skills"		Table of Groth's Skills	--
"Elda's Skills"		Table of Elda's Skills
"Duncan's Skills"	Table of Duncan's Skills
"Shliss's Skills"		Table of Shliss Skills





Table 1.5.0.3.1 - Groth's Skills
Title					Subtable			Description			Toggle
"Smashing Blow"	--			"SMASHING BLOW[paragraph break]Groth lends strength to your attack, allowing you to do extra damage. If you miss, the blow is wasted. If you hit, a die is rolled to calculate the effect: on a 1 or 2, you do 1 extra damage; on a 3 or 4, you do 2 extra damage; on a 5, you do 3 extra damage; on a 6, you do 5 extra damage. Smashing blow counts as a regular melee attack.[paragraph break][italic type]Grammar:[roman type] smash [italic type]opponent[roman type].[paragraph break][italic type]Level:[roman type] 1[paragraph break][italic type]Cost to use:[roman type] 1 zeal."
"Boost Climb"			--			"BOOST CLIMB[paragraph break]When you invoke the Boost Climb ability, you choose to pay [italic type]n[roman type] zeal. Groth gives you a bonus to your next attempt to climb something, equal to 2 times [italic type]n[roman type]. So if you paid 3 zeal, you will get a +6 bonus on your climb attempt. Boosting climb is a regular action.[paragraph break][italic type]Grammar:[roman type] boost climb [italic type]n[roman type][paragraph break][italic type]Level:[roman type] 1[paragraph break][italic type]Cost to use:[roman type] [italic type]n[roman type] zeal."
"Anger"			--			"ANGER[paragraph break]Groth fills your mind with red-hot anger. As long as you are angry, you have a +1 bonus to damage on all your melee attacks. On the negative side, as long as you are angry you cannot retreat or defend, and concentrating has a 30% chance to fail. Anger lasts as long as the current combat, or until you become furious or enraged. Becoming angry is a free action.[paragraph break][italic type]Grammar:[roman type] anger; angry; become angry.[paragraph break][italic type]Level:[roman type] 1[paragraph break][italic type]Cost to use:[roman type] 1 zeal."
"Deadlier Combat"	--			"DEADLIER COMBAT[paragraph break]Only the brave call on the power of Groth to make the fight they find themselves in more deadly. Once deadlier combat has been granted, the damage bonus granted by deadly combat is doubled. So if the deadly combat modifier is 2, all attacks will be made at +2 attack and +4 damage. This effect lasts until the end of the fight. Asking for deadlier combat is a free action.[paragraph break][italic type]Grammar:[roman type] deadlier combat.[paragraph break][italic type]Level:[roman type] 1[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."
"Fury"			--			"FURY[paragraph break]Groth fills your mind with white-hot fury. As long as you are furious, you have a +2 bonus to damage on all your melee attacks. On the negative side, as long as you are furious you cannot retreat, defend or use defensive skills, and concentrating has a 50% chance to fail. Fury lasts as long as the current combat, or until you become enraged. Becoming furious is a free action.[paragraph break][italic type]Grammar:[roman type] fury; furious; become furious.[paragraph break][italic type]Cost to learn:[roman type] 2 Groth Idols.[paragraph break][italic type]Cost to use:[roman type] 1 Zeal if already angry; 2 Zeal otherwise."
"Armour of Blood"			--			"ARMOUR OF BLOOD[paragraph break]Being able to deal loads of damage is all very well, but it will little avail you if you're dead. Groth frowns on normal armour, but he does grant the Armour of Blood to his beloved fighters. It gives you a bonus to your defence against the next attack equal to the damage you received from the current attack. So if you are hit for 3 damage, you will have +3 defence against the next attack. The armour lasts as long as the current combat, or until you get another armour. Getting the armour is a standard action.[paragraph break][italic type]Grammar:[roman type] armour of blood.[paragraph break][italic type]Cost to learn:[roman type] 2 Groth Idols.[paragraph break][italic type]Cost to use:[roman type] 2 Zeal."



Table 1.5.0.3.2 - Elda's Skills
Title					Subtable			Description			Toggle
"Shadow Armour"	--			"BRONZE ARMOUR[paragraph break]Through Elda's subtle magics, a suit of armour seemingly made of bronze will form around you. Whenever an enemy hits you, the suit has a one in three chance of absorbing up to 3 damage. After three hits, or when the fight ends, the suit will disappear. Getting the shadow armour is a standard action.[paragraph break][italic type]Grammar:[roman type] shadow armour.[paragraph break][italic type]Cost to learn:[roman type] 1 Elda Idol.[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."				a rule
"Curse"	--			"CURSE[paragraph break]With this skill, you can curse a single opponent. That opponent will then have a -2 modifier to all his melee attacks against you, which lasts until he manages to hit you despite this penalty.[paragraph break][italic type]Grammar:[roman type] curse [italic type]opponent[roman type].[paragraph break][italic type]Cost to learn:[roman type] 1 Elda Idol.[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."



Table 1.5.0.3.3 - Duncan's Skills
Title					Subtable			Description			Toggle
"Burning Hands"	--			"BURNING HANDS[paragraph break]When the burning hands skill is used, small flames flare up in the hands of the user. These flames can be used to set fire to inflammable materials, but they can also be used to set fire to people. If you try to set fire to an enemy, you must move very close to him. This allows him to make a free attack against you. You then make an attack against him at a +1 bonus, dealing 1 to 3 damage. There is a 2 in 3 chance that the enemy will catch flame; if he does, the flames will deal him 1 to 2 damage for 4 consecutive rounds.[paragraph break][italic type]Grammar:[roman type] burn [italic type]item[roman type]; burn [italic type]opponent[roman type].[paragraph break][italic type]Cost to learn:[roman type] 1 Duncan Idol.[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."				a rule
"Summon Imps"	--			"SUMMON IMPS[paragraph break]You summon three small creatures to your aid. They generally have 3 Blood, a melee score of 0, a defense score of 0, and deal between 1 and 2 damage, although each of them has a specific bonus. They will attack your enemies every turn, and sometimes your enemies will attack them instead of you.[paragraph break]There is one drawback to this spell: the loyalty of the imps is very fickle, and they may turn against you. This can happen occasionally during the fight, but if they are still alive when your enemies are defeated, they will turn against you for certain.[paragraph break][italic type]Grammar:[roman type] summon imps; imps.[paragraph break][italic type]Cost to learn:[roman type] 1 Duncan Idol.[paragraph break][italic type]Cost to use:[roman type] 2 Zeal."
"Fire Bomb"	--			"FIRE BOMB[paragraph break]You drop a small explosive device on the battlefield, which will explode in 1d3 round. Once it explodes, all your enemies have a 2 in 3 chance of catching fire, in which case the flames will deal them 1 to 2 damage for 4 consecutive rounds. There is also a 1 in 3 chance that [italic type]you[roman type] will catch fire.[paragraph break][italic type]Grammar:[roman type] fire bomb; bomb.[paragraph break][italic type]Cost to learn:[roman type] 2 Duncan Idols.[paragraph break][italic type]Cost to use:[roman type] 2 Zeal."




Table 1.5.0.3.4 - Shliss Skills
Title					Subtable			Description			Toggle
"Needle"	--			"NEEDLE[paragraph break]A needle speeds from your hand at the designated enemy. It has a 5 in 6 chance of hitting, and does 1 damage. The needle is so sharp that it bypasses normal damage reduction (such as is afforded by a thick hide or carapace).[paragraph break][italic type]Grammar:[roman type] needle [italic type]opponent[roman type].[paragraph break][italic type]Cost to learn:[roman type] 2 Shliss Idols.[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."				a rule
"Determination"	--			"DETERMINATION[paragraph break]When you are determined, you have a chance to stay concentrated even when you receive damage. A die is rolled; if its result is equal to or exceeds the amount of damage you received, your concentration will not be broken. Determination lasts as long as the combat lasts. Becoming determined is a free action.[paragraph break][italic type]Grammar:[roman type] determination.[paragraph break][italic type]Cost to learn:[roman type] 2 Groth Idols.[paragraph break][italic type]Cost to use:[roman type] 2 Zeal."
"Crackling Weapon"	--			"CRACKLING WEAPON[paragraph break]Shliss charges your melee weapon with fearsome but dangerously unpredictable electrical energy. Whenever you hit, a die is rolled to calculate the effect: on a 1, 2 or 3, nothing happens; on a 4, your enemy receives 2 extra electrical damage; on a 5, your enemy receives 4 extra electrical damage; but on a 6, [italic type]you[roman type] receive 3 electrical damage as the energy lashes back at you. Crackling weapon lasts until the end of the combat. Getting Shliss to imbue your weapon is a standard action.[paragraph break][italic type]Grammar:[roman type] crackling weapon.[paragraph break][italic type]Cost to learn:[roman type] 1 Shliss Idol.[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."




Book 1.6 - New Actions


Chapter 1.6.0.1 - Swimming

Swimming is an action applying to nothing. Understand "swim" and "dive" as swimming. Instead of swimming: say "There is no suitable body of water here.".


Chapter 1.6.0.2 - New grammar for entering

Understand "go through [thing]" as entering. Understand "go behind [thing]" as entering.


Chapter 1.6.0.3 - Xyzzy

Xyzzying is an action applying to nothing. Understand "xyzzy" as xyzzying.

Instead of xyzzying:
	say "Uh-oh. That was [italic type]not[roman type] a good idea.";
	now the xyzzied tarrasque is in the location;
	calculate the initial combat significance;
	now the combat boolean is 1.


Chapter 1.6.0.4 - Throwing

Throwing is an action applying to one thing. Understand the command "throw" as something new. Understand "throw [a thing]" as throwing.

Instead of throwing something: say "Only missile weapons can be thrown.".


Chapter 1.6.0.5 - Talking to

A person is either talkative, limited-talkative or dumb. A person is usually dumb.

A person has a table-name called the responses.

The responses of a person is usually the Table of Silence.

Table of Silence
topic					response				link				done		repeating		summary
"the weather"			"You have nothing to say to each other."		c_silence		0		1		a text

c_silence is a chat node.

Instead of giving link to c_silence: do nothing.
Instead of giving text for c_silence: do nothing.
Instead of finding responses to c_silence: forbid exiting on zero; do nothing.



Instead of asking someone about something:
	try telling the noun about it.

Understand "t [a person] about [text]" and "t [a person] [text]" and "talk to [a person] about [text]" and "talk to [a person] [text]" and "t to [a person] about [text]" and "t to [a person] [text]" as telling it about.


Talking to is an action applying to one visible thing. Understand "talk to [person]" and "speak to [person]" and "talk with [person]" and "speak with [a person]" and "t to [a person]" and "t [a person]" as talking to.

A person has a text called the standard topic. The standard topic of a person is usually "the weather".



Carry out talking to:
	say "You will have to specify what you wish to talk about. In this case, I would suggest the topic '[the standard topic of the noun]'. (Type 't [the noun] [the standard topic of the noun]'.)".



Instead of telling someone about something:
	if the noun is killed, say "The only sound emanating from the corpse is that of slow putrefaction." instead;
	if the noun is dumb, say "You cannot converse with [the noun]." instead;
	if the noun is limited-talkative begin;
		say "(I'd love to tell you what the only subject is you can talk about with [the noun], but that currently produces a fatal error in Gargoyle. So I can't.)[paragraph break]";
	end if;
	let the source be the responses of the noun;
	sort source in done order;
	if topic understood is a topic listed in source begin;
		if the done entry is greater than 1 and the repeating entry is 0 begin;
			say "[The noun] has already told you [summary entry].";
		otherwise;
			now the done entry is 3 minus the done entry; [0 -> 3, 1 -> 2]
			if there is a response entry, say "[response entry][paragraph break]";
			if there is a link entry, run a conversation from link entry;
		end if;
	otherwise;
		say "You can't talk about that with [the noun].";
	end if. 






Book 1.7 - Miscellaneous


Chapter 1.7.0.1 - Determinable Kind

A determinable is a kind of thing.

A determinable is usually scenery. The description of a determinable is usually "ERROR: you should never see this text.".

The global determinable is a determinable that varies.

A determinable has a number called the determinate number. The determinate number of a determinable is usually 0.

[A determinable has an indexed text called the referencing name. Understand the referencing name property as describing a determinable. The referencing name of a determinable is usually "abcdefghijklmnopqrtsuvwxyz".] [THIS IS THE LINE!]
A determinable has a number called the options number.
A determinable has some text called the current room description text.
A determinable has some text called the first option text.
A determinable has some text called the first room description text.
A determinable has some text called the first description text.
A determinable has some text called the first printed text.
A determinable has a number called the first spirit. The first spirit is usually 0.
A determinable has some text called the second option text.
A determinable has some text called the second room description text.
A determinable has some text called the second description text.
A determinable has some text called the second printed text.
A determinable has a number called the second spirit. The second spirit is usually 0.
A determinable has some text called the third option text.
A determinable has some text called the third room description text.
A determinable has some text called the third description text.
A determinable has some text called the third printed text.
A determinable has a number called the third spirit. The third spirit is usually 0.

Before examining a determinable:
	if the determinate number of the noun is 0 begin; 
		now the global determinable is the noun;
		run a conversation from c_determinable_1;
		stop;
	end if.


c_determinable_1, c_determinable_2, c_determinable_3, c_determinable_4 are chat nodes.

Instead of giving text for c_determinable_1: say "Well, what [italic type]do[roman type] you see?".
Instead of finding responses to c_determinable_1: forbid exiting on zero; link to c_determinable_2; if the options number of the global determinable is greater than 1, link to c_determinable_3; if the options number of the global determinable is greater than 2, link to c_determinable_4.

Instead of giving link to c_determinable_2: say "[first option text of the global determinable][if the first spirit of the global determinable is greater than 0][bold type] (+ [first spirit of the global determinable] Spirit)[roman type][end if][if the first spirit of the global determinable is less than 0][bold type] ([first spirit of the global determinable] Spirit)[roman type][end if][paragraph break]".
Instead of giving text for c_determinable_2: say "".
Instead of finding responses to c_determinable_2: now the determinate number of the global determinable is 1; now the current room description text of the global determinable is the first room description text of the global determinable; now the printed name of the global determinable is the first printed text of the global determinable; now the description of the global determinable is the first description text of the global determinable[; now the referencing name of the global determinable is the second room description text of the global determinable]; say "Right, [the global determinable]."; increase the spirit of the player by the first spirit of the global determinable.

Instead of giving link to c_determinable_3: say "[second option text of the global determinable][if the second spirit of the global determinable is greater than 0][bold type] (+ [second spirit of the global determinable] Spirit)[roman type][end if][if the second spirit of the global determinable is less than 0][bold type] ([second spirit of the global determinable] Spirit)[roman type][end if][paragraph break]".
Instead of giving text for c_determinable_3: say "".
Instead of finding responses to c_determinable_3: now the determinate number of the global determinable is 2; now the current room description text of the global determinable is the second room description text of the global determinable; now the printed name of the global determinable is the second printed text of the global determinable; now the description of the global determinable is the second description text of the global determinable[; now the referencing name of the global determinable is the printed name of the global determinable]; say "Right, [the global determinable]."; increase the spirit of the player by the second spirit of the global determinable.

Instead of giving link to c_determinable_4: say "[third option text of the global determinable][if the third spirit of the global determinable is greater than 0][bold type] (+ [third spirit of the global determinable] Spirit)[roman type][end if][if the third spirit of the global determinable is less than 0][bold type] ([third spirit of the global determinable] Spirit)[roman type][end if][paragraph break]".
Instead of giving text for c_determinable_4: say "".
Instead of finding responses to c_determinable_4: now the determinate number of the global determinable is 3; now the current room description text of the global determinable is the third room description text of the global determinable; now the printed name of the global determinable is the third printed text of the global determinable; now the description of the global determinable is the third description text of the global determinable[; now the referencing name of the global determinable is the printed name of the global determinable]; say "Right, [the global determinable]."; increase the spirit of the player by the third spirit of the global determinable.


The undetermined thing is a determinable. [This is a dummy object that serves as a template for other determinables.]

The options number of the undetermined thing is 3.
The current room description text of the undetermined thing is "What goes in the room description.".
The first option text of the undetermined thing is "Choose the first option.".
The first room description text of the undetermined thing is "Room description of the first option.".
The first description text of the undetermined thing is "Describing the first option.".
The first printed text of the undetermined thing is "Printed text of first option.".
The second option text of the undetermined thing is "Choose the second option.".
The second room description text of the undetermined thing is "Room description of the second option.".
The second description text of the undetermined thing is "Describing the second option.".
The second printed text of the undetermined thing is "Printed text of second option.".
The third option text of the undetermined thing is "Choose the third option.".
The third room description text of the undetermined thing is "Room description of the third option.".
The third description text of the undetermined thing is "Describing the third option.".
The third printed text of the undetermined thing is "Printed text of third option.".


Chapter 1.7.0.2 - Detailer Kind

A detailer is a kind of thing. A detailer is always scenery. [Examining detailers changes the room description. The idea is that you can have a terse room description, which is fleshed out with detail as the player examines more objects.]

A detailer has some text called the current room description text.
A detailer has some text called the detailed room description text.

Before examining a detailer:
	now the current room description text of the noun is the detailed room description text of the noun.




Chapter 1.7.0.3 - Dungeons


A dungeon is a kind of region.

Before printing the name of a room in a dungeon:
	say "[bracket]D[close bracket] ".

Dungeon-kinship relates rooms to each other in groups. The verb to be dungeon-kin to implies the dungeon-kinship relation.

[When play begins:
	repeat with the original room running through rooms begin;
		if the original room is in a dungeon begin;
			repeat with the potential kin running through rooms adjacent to the original room begin;
				if the potential kin is in a dungeon, now the potential kin is dungeon-kin to the original room;
			end repeat;
		end if;
	end repeat.]


Every turn:
	 if no alive monster is in the Bat Cave and the location of the player is not in the Bat Cave and a random chance of 1 in 10 succeeds begin;
		repeat with the sucker running through monsters in the Bat Cave begin;
			now the blood of the sucker is the permanent blood of the sucker;
			now the room dummy is a random room in the Bat Cave;
			move the sucker to the room dummy;
		end repeat;
		repeat with the treasure running through things in the cache of the Bat Cave begin;
			if a random chance of 1 in 5 succeeds begin;
				move the treasure to a random treasure chest in the Bat Cave;
			end if;
		end repeat;
		repeat with the chest running through treasure chests in the Bat Cave begin;
			now the chest is closed;
		end repeat;
	end if.


A treasure chest is a kind of container. A treasure chest is usually openable, closed and scenery.

A dungeon has a treasure chest called the cache.



Chapter 1.7.0.4 - Visbility

A room has a number called the room visibility. The room visibility of a room is usually 0. [Darker rooms get lower, therefore NEGATIVE, room visibility.]

Total visibility is a number that varies. The total visibility is usually 0. [This is the global variable that tracks how dark a room is.]

A person is either darkvisioned or not darkvisioned. A person is usually not darkvisioned. [Darkvisioned persons disregard all darkness.]

A person is either lowlightvisioned or not lowlightvisioned. A person is usually not lowlightvisioned. [Lowlightvisioned person disregard up to two levels of darkness.]

A thing has a number called the illumination. The illumination of a thing is usually 0.


To determine visibility:
	now the total visibility is the room visibility of the location;
	if the total visibility is 0, stop; [Only go on to search for light sources if the room is dark]
	repeat with the potential light source running through things enclosed by the location begin;
		if the potential light source is visible begin;
			if the potential light source is an on fire person, increase the total visibility by 2;
			increase the total visibility by the  illumination of the potential light source;
		end if;
	end repeat;
	if the total visibility is greater than 0, now the total visibility is 0.








Volume 2 - Monsters, Player, Combat Items



Chapter 2.0.0.1 - The Player Character


Section 2.0.0.1.1 - Statistics

[Here we define the initial statistics of the player character.]

The blood of the player is 20.
The zeal of the player is 10.
The melee of the player is 1.
The mind of the player is 1.
The defense of the player is 7. 

The player has a number called the spirit. The spirit of the player is 0.


Section 2.0.0.1.2 - Leveling up

[The player starts on level 1, and proceeds to level 5. There is a one-to-one correspondence between "player level" and "dungeon level", and for the game we will make them semantically the same concept. Also, we will use monster level to find out how cool it is to fight them; but this works a little differently - see 2.0.0.2.2.]

A person has a number called level. The level of the player is 1. [We modify the status bar in section 2.2.]

[Now we define the activity of leveling up.]

To level up:
   increase the level of the player by 1;
   increase the permanent blood of the player by 10;
   increase the permanent zeal of the player by 10;
   restore the blood of the player;
   restore the zeal of the player;
   increase the mind of the player by 1;
   increase the melee of the player by 1;
   increase the defense of the player by 1;
   say "You have gained a level! The Gods reward you accordingly.".


Section 2.0.0.1.3 - Appearance and initial possessions

Instead of examining the player:
	if the level of the player is 1, say "Strong. Competent. Someone who is not going to be stopped.";
	if the level of the player is 2, say "TODO";
	if the level of the player is 3, say "TODO";
	if the level of the player is 4, say "TODO";
	if the level of the player is 5, say "TODO".
	
Golden hair is a part of the player. Understand "blond" as the golden hair. Instead of examining the golden hair:
	if the level of the player is 1, say "Long, sleek, golden--it reflects the light with metallic purity.";
	if the level of the player is 2, say "TODO";
	if the level of the player is 3, say "TODO";
	if the level of the player is 4, say "TODO";
	if the level of the player is 5, say "TODO".

The player carries a sword. The sword is a determinable. The sword is not scenery. Understand "ornate" and "huge" and "practical" as the sword.

The options number of the sword is 3.
The first option text of the sword is "It is a grand and majestic sword: the blade has been inlaid with platinum designs, while the hilt is encrusted with big jewels encased in purest gold. This is the kind of blade that makes people [italic type]adore[roman type] and [italic type]respect[roman type] you.".
The first description text of the sword is "It is a grand and majestic sword: the blade has been inlaid with platinum designs, while the hilt is encrusted with big jewels encased in purest gold. This is the kind of blade that makes people [italic type]adore[roman type] and [italic type]respect[roman type] you.".
The first printed text of the sword is "ornate sword".
The second option text of the sword is "The sword is huge and made of an unknown, deeply black metal. The pommel is shaped as a skull. This is the kind of blade that makes people [italic type]fear[roman type] and [italic type]obey[roman type] you.".
The second description text of the sword is "The sword is huge and made of an unknown, deeply black metal. The pommel is shaped as a skull. This is the kind of blade that makes people [italic type]fear[roman type] and [italic type]obey[roman type] you.".
The second printed text of the sword is "huge sword".
The third option text of the sword is "The sword is short and sharp, well-balanced and well-maintained, but its appearance is entirely mundane. This is the kind of blade that nobody looks at twice.".
The third description text of the sword is "The sword is short and sharp, well-balanced and well-maintained, but its appearance is entirely mundane. This is the kind of blade that nobody looks at twice.".
The third printed text of the sword is "practical".


Instead of dropping the sword: say "You don't want to walk around without a sword.". Instead of putting the sword on something: say "You don't want to walk around without a sword.". Instead of inserting the sword into something: say "You don't want to walk around without a sword.". 

[The player carries four groth idols, four shliss idols, three duncan idols and three elda idols.] [TODO]


Section 2.0.0.1.4 - Responses to standard actions

Instead of waking up: say "You have never been more awake in your life.".

Instead of kissing: say "You are not exactly in a friendly mood.".

[Instead of answering that: say "You cannot talk. You do not have a tongue.".
Instead of telling something about: say "You cannot talk. You do not have a tongue.".
Instead of asking something about: say "You cannot talk. You do not have a tongue.".
Instead of asking something for: say "You cannot talk. You do not have a tongue.".
Instead of saying sorry: say "You cannot talk. You do not have a tongue.".
Instead of swearing mildly: say "You cannot talk. You do not have a tongue.".
Instead of swearing obscenely: say "You cannot talk. You do not have a tongue.".]

Instead of saying yes: say "You nod your assent.".
Understand "nod" as saying yes.

Instead of saying no: say "You shake your head in dissent.".

Instead of waiting: say "You freeze.".

Instead of waving hands: say "You wave your sword in a threatening manner.".

Instead of jumping: say "You jump forward, as deadly as a viper.".

Instead of singing: say "You hum a tune that, somewhere, somewhen, will be known as the Ride of the Valkyries.".

Instead of sleeping: say "If you do not stay awake, you will soon be sleeping the sleep of Death.".


Section 2.0.0.1.5 - The Stats action

Showing the stats is an action out of world. Understand "stats" and "statistics" and "diagnose" and "show stats" as showing the stats.


Carry out showing the stats:
	say "[bold type]Your statistics:[roman type][line break]";
	say " Blood: ", blood of the player, " out of ", permanent blood of the player, "[line break]";
	say " Zeal: ", zeal of the player, " out of ", permanent zeal of the player, "[line break]";
	say " Melee: ", melee of the player, "[line break]";
	say " Defense: ", defense of the player, "[line break]";
	say "[line break]";
	say "[bold type]Special conditions:[roman type][line break]";
	if the player is at dodge, say " Dodging (+2 defense)[line break]";
	if the player is at parry, say " Parrying (damage reduction when hit)[line break]";
	if the concentration of the player is greater than 0 begin;
		if the concentration of the player is 1, say " Concentrated (+2 melee on your attack)[line break]";
		if the concentration of the player is 2, say " Concentrated (+4 melee and +2 damage on your next attack)[line break]";
		if the concentration of the player is 3, say " Concentrated (+8 melee and +4 damage on your next attack)[line break]";
	end if;
	if the deadly combat bonus is greater than 0, say " Deadly Combat (currently +", deadly combat bonus," melee and damage for all characters)[line break]";
	if the deadlier combat boolean is true and the deadly combat bonus is greater than 0, say " Deadlier Combat (an additional +", deadly combat bonus," damage bonus for all characters)[line break]";
	if the climb boost is greater than 0, say " Boost climb (a +", climb boost," bonus on your next climb attempt)[line break]";
	if the player is angry, say " Angry (+1 damage, no retreat and defend, 30% concentration failure)[line break]";
	if the elda armour status of the player is greater than 0 begin;
		if the elda armour metal is bronze, say " Bronze armour";
		if the elda armour metal is iron, say " Iron armour";
		if the elda armour metal is steel, say " Steel armour";
		say " (a ", 7 - elda armour chance of the player, " in 6 chance of absorbing up to ", elda armour amount of the player, " damage up to ", elda armour status of the player, " more times)[line break]";
	end if;
	if the player is cursed, say " Cursed (-2 melee modifier until curse is lifted)[line break]";
	if the player is shielded, say " Shield (defending reduces damage by 1 to 6, instead of 0 to 3)[line break]";
	if the player is gaseous, say " Gaseous (cannot be attacked this turn)[line break]";
	if the scouting boolean is true, say " Scouting (+4 bonus to retreat)[line break]";
	if the player is determined, say " Determined (you sometimes keep your concentration even if you are damaged)[line break]";
	if the sacrificial number of the player is greater than 0, say " Sacrifice (+", the sacrificial number of the player," melee on your next attack)[line break]";
	if the player is poisonous, say " Poisoned (receive between ", minimum poison damage of the player, " and ", maximum poison damage of the player, " damage for ", poison time of the player, " more turns)[line break]";
	if the player is on fire, say " Burning (receive between ", minimum burn damage of the player, " and ", maximum burn damage of the player, " damage for ", burn time of the player, " more turns)[line break]";
	if the global guarding stick number is greater than 0, say "Stick of Guarding (+",  global guarding stick number," defence)[line break]";
	determine visibility;
	if the total visibility is less than 0 begin;
		now the first dummy is 0 minus total visibility;
		say " Low visibility ( -", first dummy, " attack, unless one has low light vision or darkvision)[line break]";
	end if. [TODO]


Section 2.0.0.1.6 - Action redirections

Instead of going down when the player is on a supporter: try exiting.




Chapter 2.0.0.2 - Monster Preliminaries


Section 2.0.0.2.1 - Hostility

A monster can be hostile, indifferent or friendly. A monster is usually hostile. [There are three kinds of monsters: hostile, indifferent and friendly. The first attack you; the second do nothing; the third help you. For now, I'll stick to implementing the first class.] [OK, I have implemented that all monsters become hostile once attacked.]



Section 2.0.0.2.2 - The senses

Instead of listening to a killed monster: say "Not even the beating of a heart.".

Instead of touching an alive monster: say "That is not an advisable combat move!"; take no time.

Instead of tasting an alive monster: say "That is not an advisable combat move!"; take no time.

Check touching a killed monster: 
	if a hostile alive monster is enclosed by the location begin;
		say "That can wait until you have disposed of your other enemies.";
		take no time;
	end if.

Check tasting a killed monster: 
	if an alive hostile monster is enclosed by the location begin;
		say "That can wait until you have disposed of your other enemies.";
		take no time;
	end if.
	

Section 2.0.0.2.3 - General responses

Check taking an alive monster: say "That doesn't sound like a very good move."; take no time instead.

Check taking a killed monster: say "You do not have a use for corpses."; take no time instead.



Section 2.0.0.2.4 - Level and significance

[Inform only has integers, so we are going to rescale monster level compared to player level. What we want is that a fight is standard if the added levels of the monsters are at least the level of the player; but to make more precise calculations possible, we will make this TEN TIMES the level of the player. So a monster with level 10 is significant on level 1.]

The initial combat significance is a number that varies. [This is calculated at the start of a combat, and will be used to see what the Gods think of you afterward.] The combat significance is a number that varies.

To calculate the initial combat significance:
	calculate the combat significance;
	now the initial combat significance is the combat significance.
	[say "Initial combat significance calculated at: ", initial combat significance.]

To calculate the combat significance:
	now the combat significance is 0; now the first dummy is 0; now the second dummy is 0;
	repeat with the opponent running through hostile alive monsters enclosed by the location begin;
		now the first dummy is the level of the opponent times the blood of the opponent;
		now the first dummy is the first dummy divided by the permanent blood of the opponent;
		increase the second dummy by the first dummy;
	end repeat;
	if the second dummy is greater than 5 times the level of the player, now the combat significance is 1;
	if the second dummy is greater than 9 times the level of the player, now the combat significance is 2;
	if the second dummy is greater than 15 times the level of the player, now the combat significance is 3;
	if the second dummy is greater than 20 times the level of the player, now the combat significance is 4.  

[So: if the combat significance is 0, you are almost guaranteed to win. If it is 2, it's interesting. If it's 4, it would be almost amazing if you win.]


Section 2.0.0.2.5 - Flavour text

[Flavour text describes the battles.]

A person has a table-name called the player flavour texts. The player flavour texts of a person is usually the table of generic player flavour texts.

A person has a table-name called the monster flavour texts. The monster flavour texts of a person is usually the table of generic monster flavour texts.


Table 2.0.0.2.5.1 - Generic Player Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text				
"Swinging your sword, you aim for the head of [the global defender]. You put the sword in through the [one of]left[or]right[purely at random] eye, all the way down into the brain!"		"Swinging your sword, you aim for the head of [the global defender]. The sharp edge makes a bloody gash right across [possessive of the global defender] face."	"Swinging your sword, you aim for the head of [the global defender]. Your target ducks at the right moment, and your swing goes wide."		"Swinging your sword, you aim for the head of [the global defender]. You hit, but inflict only a scratch."
"You scream a foul oath as you attack, and with a mighty blow you open your opponent's arteries. Blood spurts everywhere around you!"		"You scream a foul oath as you attack, and manage to land a solid blow."		"You scream a foul oath as you attack, and miss. [The global defender] is not impressed."	"You scream a foul oath as you attack, and manage to hit [the global defender]. However, the force of the blow is too little to do any damage."
"Swinging your sword, you aim for the legs of [the global defender]. You chop right through the bone! [The global defender] falls down, and you finish it off with a couple of quick thrusts."		"Swinging your sword, you aim for the legs of [the global defender]. The sharp edge bites deep into the flesh."		"Swinging your sword, you aim for the legs of [the global defender]. Your target jumps at the right moment, evading your swing."	"Swinging your sword, you aim for the legs of [the global defender]. You manage to scratch the skin, but no more than that."


Table 2.0.0.2.5.1 - Generic Monster Flavour Texts
Fatal Text					Hit Text			Miss Text					Absorbed Text				
"[The global attacker] aims for your groin, and hits you with a fatal blow. Your intestines rip apart under the force. After several minutes of intense agony, you die."		"[The global attacker] aims for your groin, hitting you. You stumble back under the force of the blow."	"[The global attacker] aims for your groin, but you step aside easily."	"[The global attacker] aims for your groin, hitting you. Fortunately, your hard muscles absorb the weak blow."
"With a sudden rush, [the global attacker] attacks you. You fall backwards under the force of the onslaught, and within seconds, [the global attacker] is upon you and opens your jugular vein. You die in a pool of your own blood."		"With a sudden rush, [the global attacker] attacks you. Your ineffectual defence cannot stop the attack."		"With a sudden rush, [the global attacker] attacks you.  You sidestep easily, avoiding the blow."	"With a sudden rush, [the global attacker] attacks you. It is more show than substance, and he fails to do any real damage."
"[The global attacker] aims for your legs, and hits you with a bone-smashing blow! You fall down, unable to defend yourself, and are killed seconds later."		"[The global attacker] aims for your legs, hitting your [one of]left[or]right[purely at random] one. Luckily, you manage to remain upright."	"[The global attacker] aims for your legs, but you jump aside with a laugh."	"[The global attacker] aims for your legs, hits, but inflicts no worse than a bruise."


Section 2.0.0.2.6 - Grouping



	
After printing the name of a killed monster while not grouping together:
	if the global flavour text boolean is true, stop;
	if the monster is killed, say " (killed)".

After printing the plural name of a killed monster while not grouping together:
	if the global flavour text boolean is true, stop;
	if the monster is killed, say " (killed)".

After printing the name of an alive monster while asking which do you mean:
	if the global flavour text boolean is true, stop;
	if the monster is killed, say " (alive)".

[TODO] [This stuff must be put back as soon as the Gargoyle bug is solved!]


[Rule for writing a paragraph about a monster:
	if the number of monsters in the location is greater than one begin;
		say "You can see ";
		let monster-list be the list of monsters in the location grouped-by-kind;
		let n be the number of entries in monster-list;
		let g be 1;
		repeat with group running through monster-list begin;
			say group by-details;
			if g is n begin;
				say ".";
			otherwise if g is n - 1;
				say " and ";
			otherwise;
				say ", ";
			end if;
			let g be g + 1;
		end repeat;
		now every monster in the location is mentioned;
	end if.]

[To decide what list of lists of objects is the (o-list - a list of objects) grouped-by-kind:
	let grouped-list be a list of lists of objects;
	let test-name be an indexed text;
	while the number of entries in o-list is greater than 0 begin;
		let sub-list be a list of objects;
		let x be entry 1 in o-list;
		change test-name to the printed name of x;
			repeat with item running through o-list begin;
				if the printed name of item exactly matches the text "][test-name][" begin;
					add item to sub-list;
				end if;
			end repeat;
		add sub-list to grouped-list;
		remove sub-list from o-list;
		truncate sub-list to 0 entries;
	end while;
	decide on grouped-list.]

[To say (group - a list of objects) by-details:
	let n be the number of entries in group;
	if n is one begin;
		say "][group with indefinite articles][";
	otherwise;
		say n in words;
		say " ][the printed plural name of entry 1 in group][";
		let k be 0;
		repeat with item running through group begin;
			if item is killed, increase k by one;
		end repeat;
		if k is n begin;
			say " (all killed)";
		otherwise if k is one;
			say " (one of which is killed)";
		otherwise if k is greater than one;
			say " (][k in words][ of which are killed)";
		end if;
	end if.]




Book 2.1 - Monster Skills


Chapter 2.1.0.1 - Regeneration 

[Regeneration means that the monster will get regeneration rate blood back every turn. Note 1: this only happens when the monster is alive. Note 2: the maximum blood remains the permanent blood. Note 3: the player should try to maximise damage against such monsters; even deadlier combat becomes a viable tactical option.]


A monster is either regenerating or not regenerating. A monster is usually not regenerating.

A monster has a number called the regeneration rate. The regeneration rate of a monster is usually 0. 

Every turn:
	repeat with the patient running through alive regenerating monsters begin;
		if the blood of the patient is less than the permanent blood of the patient begin;
			increase the blood of the patient by the regeneration rate of the patient;
			if the blood of the patient is greater than the permanent blood of the patient, now the blood of the patient is the permanent blood of the patient; 
		end if;
	end repeat. 



Chapter 2.1.0.2 - Poisonous

A person can be poisonous or not poisonous. A person is usually not poisonous.

A person has a number called the poison chance. The poison chance of a person is usually 0.
A person has a number called the minimum poison damage. The minimum poison damage is usually 0.
A person has a number called the maximum poison damage. The maximum poison damage is usually 0.
A person has a number called the poison time. The poison time is usually 0.

[If bitten by a poisonous monster, you must first roll against the poison chance. If you do not beat the number, you are poisoned. You will then get a random amount between minimum and maximum damage every turn for poison time turns.]

[We are going to use these same numbers for the player!]

Every turn when the player is poisonous:
	decrease the poison time of the player by 1;
	now the first dummy is a random number between the minimum poison damage of the player and the maximum poison damage of the player;
	say "The poison in your blood deals you ", first dummy, " damage!";
	deal first dummy damage to the player;
	if the poison time of the player is 0, now the player is not poisonous.
	
[And to get him poisoned]

To have (the attacker - a person) poison (the defender - a person):
	now the first dummy is a random number between 1 and 6;
	say " [italic type](You roll ", first dummy, " against a poison chance of ", poison chance of the attacker;
	if the first dummy is greater than the poison chance of the attacker begin;
		say ", resisting the poison of [the attacker]!)[roman type]";
		continue the activity;
	end if;
	say ". You are poisoned!)[roman type]";
	now the minimum poison damage of the defender is the minimum poison damage of the attacker;
	now the maximum poison damage of the defender is the maximum poison damage of the attacker;
	now the poison time of the defender is the poison time of the attacker;
	now the defender is poisonous.
	

Chapter 2.1.0.3 - Special damage

A person has a number called the damage die. The damage die of a person is usually 6.

A person has a number called the damage bonus. The damage bonus of a person is usually 0.


Chapter 2.1.0.4 - Holding on

A person can be an onholder or not an onholder. A person is usually not an onholder.

A person is either a legholder or not a legholder. A person is usually not a legholder.

A person has a number called the hold chance. The hold chance of a person is usually 4.
A person has a number called the hold damage. The hold damage of a person is usually 1.
A person has a number called the hold leg melee penalty. The hold leg melee penalty of a person is usually 0.
A person has a number called the hold leg defence penalty. The hold leg defence penalty of a person is usually 1.
A person has a number called the hold arm melee penalty. The hold arm melee penalty of a person is usually 1.
A person has a number called the hold arm defence penalty. The hold arm defence penalty of a person is usually 0.
A person has a number called the hold release. The hold release of a person is usually 3.
A person has a number called the hold self defence penalty. The hold self defence penalty of a person is usually 1.

A person has a number called the hold location. The hold location of a person is usually 0. [0 is none. 1 is leg. 2 is arm.] 

[How does this work? When an onholder hits, he has a chance equal to the hold chance / 6 to hold on to the player; either onto his leg or onto his arm. Now, he will hold on until dealt at least hold release damage in a single turn, or killed. Every turn, he will deal hold damage damage. He will also give a melee and defence penalty to the player, depending on whether he holds on to the leg or the arm. The onholder has a defence penalty of hold self defence penalty as long as he holds on. A legholder always holds on to your leg.]

Every turn when a killed onholder monster is enclosed by the location:
	repeat with opponent running through the killed onholder monsters enclosed by the location begin;
		now the hold location of the opponent is 0;
	end repeat.  


To have (the attacker - a person) hold on to (the defender - a person):
	if the player is alive begin;
		now the first dummy is a random number between 1 and 6;
		say " ([The attacker] rolls ", first dummy, " against a hold chance of ", hold chance of the attacker;	
		if the first dummy is less than the hold chance of the attacker begin;
			say ", failing to hold on to you!)[run paragraph on]";
			continue the activity;
		end if;
		now the hold location of the attacker is a random number between 1 and 2;
		if the attacker is a legholder, now the hold location of the attacker is 1;
		if the hold location of the attacker is 1, say ", grabbing your leg and not intending to let go!)[run paragraph on]";
		if the hold location of the attacker is 2, say ", grabbing your arm and not intending to let go!)[run paragraph on]";
	end if.

To have (the attacker - a person) deal hold damage to (the defender - a person):
	now the first dummy is the hold damage of the attacker;
	say "While firmly holding on to your ";
	if the hold location of the attacker is 1, say "leg";
	if the hold location of the attacker is 2, say "arm";
	say ", [the attacker] deals ", first dummy, " damage![run paragraph on]";
	deal first dummy damage to the defender;
	if the attacker is on fire begin;
		if the defender is not on fire begin;
			if a random chance of 1 in 2 succeeds begin;
				now the printing state is printing-fiery;
				say " In addition, you are set ablaze![run paragraph on]";
				now the printing state is printing-normal;
				set fire to the defender;
			end if;
		end if;
	otherwise if the defender is on fire;
		if a random chance of 1 in 2 succeeds begin;
			now the printing state is printing-fiery;
			say " [The attacker] is enveloped by the flames that surround you![run paragraph on]";
			now the printing state is printing-normal;
			set fire to the attacker;
		end if;
	end if;
	say "[paragraph break]".


To calculate the onholder melee bonus for (the attacker - a person) against (the defender - a person):
	if the attacker is the player begin;
		repeat with the opponent running through hostile alive onholder monsters enclosed by the location begin;
			if the hold location of the opponent is 1 begin;
				decrease the to-hit modifier by the hold leg melee penalty of the opponent;
				if the hold leg melee penalty of the opponent is not 0, say " - ", hold leg melee penalty of the opponent, " ([the opponent] holding on to your leg)";
			end if;
			if the hold location of the opponent is 2 begin;
				decrease the to-hit modifier by the hold arm melee penalty of the opponent;
				if the hold arm melee penalty of the opponent is not 0, say " - ", hold arm melee penalty of the opponent, " ([the opponent] holding on to your arm)";
			end if;
		end repeat;
	end if;
	if the defender is the player begin;
		repeat with the opponent running through hostile alive onholder monsters enclosed by the location begin;
			if the hold location of the opponent is 1 begin;
				increase the to-hit modifier by the hold leg defence penalty of the opponent;
				if the hold leg defence penalty of the opponent is not 0, say " + ", hold leg defence penalty of the opponent, " ([the opponent] holding on to your leg)";
			end if;
			if the hold location of the opponent is 2 begin;
				increase the to-hit modifier by the hold arm defence penalty of the opponent;
				if the hold arm defence penalty of the opponent is not 0, say " + ", hold arm defence penalty of the opponent, " ([the opponent] holding on to your arm)";
			end if;
		end repeat;
	end if;


Chapter 2.1.0.5 - Damage reduction

A person has a number called damage reduction. The damage reduction of a person is usually 0.


Chapter 2.1.0.6 - Erratic attacker

A person is either an erratic attacker or not an erratic attacker. A person is usually not an erratic attacker.

[An erratic attacker only attacks sometimes.]

A person has a number called the erratic attack odds. The erratic attack odds of a person are usually 6. [6 in 6, that is.]
A person has a text called the erratic attack failure text. The erratic attack failure text of a person is usually "".


Chapter 2.1.0.7 - Fireproof

A person is either fireproof or not fireproof. A person is usually not fireproof.


Chapter 2.1.0.8 - Summoned

A monster is either summoned or not summoned. A monster is usually not summoned.


Chapter 2.1.0.9 - Vampiric

A monster is either vampiric or not vampiric. A monster is usually not vampiric.

A monster has a number called the vampire ratio. The vampire ratio of a monster is usually 5. [Read this as 5 in 10. Whenever the vampiric monster deals X damage, it gets X * vampire ratio / 10 blood, up to its maximum.]

To do sucking blood with (the attacker - a person) and (the defender - a person):
	now the second dummy is the permanent blood of the attacker minus the blood of the attacker;
	if the second dummy is not 0 begin;
		now the first dummy is the final damage;
		now the first dummy is the first dummy times the vampire ratio of the attacker;
		now the first dummy is the first dummy divided by 10;
		if the first dummy is greater than the second dummy, now the first dummy is the second dummy;
		if the first dummy is not 0 begin;
			increase the blood of the attacker by the first dummy;
	 		say " [italic type]Drinking deeply from [possessive of the defender] blood, [the attacker] regains ", first dummy, " blood![roman type]";
		end if;
	end if.


Chapter 2.1.0.10 - Boss

A monster is either boss or not boss. A monster is usually not boss. [We don't print fatal flavour text for boss creatures. The writer must implement something himself. I use this for fatalities and for people who need to give a dramatic farewell speech.]


Chapter 2.1.0.11 - Non-exciting

A monster can be non-exciting. A monster is usually not non-exciting.



Book 2.2 - Monster Definitions


Part 2.2.1 - Animals


Chapter 2.2.1.1 - Wild Boar

A wild boar is a kind of monster.
Understand "pig" and "tusk" and "tusks" as a wild boar.

[The senses]

Instead of examining a wild boar: say "Essentially a very large pig, but much more ferocious and equipped with two large tusks."

Instead of smelling a wild boar: say "A strong smell of musk emanates from the animal.".

Instead of listening to an alive wild boar: say "It sounds quite angry."

Instead of touching a killed wild boar: say "Its rough hair is surprisingly soft to the touch.".

Instead of tasting a killed wild boar: say "When roasted, wild boar makes an excellent dish. But you are not here to cook the Deathlord a meal.".


[The numbers]

The blood of a wild boar is usually 10.
The zeal of a wild boar is usually 0.
The melee of a wild boar is usually 1.
The mind of a wild boar is usually 0.
The defense of a wild boar is usually 2. 

The level of a wild boar is usually 10.


[The tables]

The player flavour texts of a wild boar is usually the Table of Wild Boar Player Flavour Texts.
The monster flavour texts of a wild boar is usually the Table of Wild Boar Monster Flavour Texts.


Table of Wild Boar Player Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text				
"With a masterful stroke, you bury your blade in [possessive of the global defender] brain, killing him instantly."	"Evading the large tusks, you manage to land a solid blow on [possessive of the global defender] [one of]left[or]right[at random] flank."	"You move in to plant your blade in [possessive of the global defender] head, but a violent counterattack with his tusks leaves you on the defence."	"With a deft maneuver you manage to hit [the global defender], but your sword doesn't so much as draw blood."
"Swinging your sword, you aim for the head of [the global defender]. You put the sword in through the [one of]left[or]right[purely at random] eye, all the way down into the brain!"		"Swinging your sword, you aim for the head of [the global defender]. The sharp edge makes a bloody gash right across [possessive of the global defender] face."	"Swinging your sword, you aim for the head of [the global defender]. Your target backs away at the right moment, and your swing goes wide."		"Swinging your sword, you aim for the head of [the global defender]. You hit, but inflict only a scratch."
"You scream a foul oath as you attack, and with a mighty blow you open your opponent's arteries. Blood spurts everywhere around you!"		"You scream a foul oath as you attack, and manage to land a solid blow."		"You scream a foul oath as you attack, and miss. [The global defender] is not impressed."	"You scream a foul oath as you attack, and manage to hit [the global defender]. However, the force of the blow is too little to do any damage."


Table of Wild Boar Monster Flavour Texts
Fatal Text					Hit Text			Miss Text					Absorbed Text				
"[The global attacker] rips open your groin with his huge tusks. Your innards fall out, and after several minutes of intense agony, you die."		"[The global attacker] aims for your groin, hitting you with one of his sharp tusks. You stumble back under the force of the blow."	"[The global attacker] aims for your groin, but you step aside easily."	"[The global attacker] aims for your groin, hitting you with one of his sharp tusks. Fortunately, your hard muscles absorb the weak blow."
"With a sudden rush, [the global attacker] attacks you. You fall backwards under the force of the onslaught, and within seconds, [the global attacker] is upon you. You are trampled and ripped apart, and die in a pool of your own blood."		"With a sudden rush, [the global attacker] attacks you. Your ineffectual defence cannot stop the attack, and you receive a big gash along your [one of]left[or]right[purely at random] leg."		"With a sudden rush, [the global attacker] attacks you.  You sidestep easily, avoiding the blow."	"With a sudden rush, [the global attacker] attacks you--but his tusks, fearsome as they look, leave you unharmed."
"[The global attacker] charges you and hits your legs with his full weight! You fall down, and are killed within seconds."		"[The global attacker] charges you, hitting your [one of]left[or]right[purely at random] leg. Luckily, you manage to remain upright."	"[The global attacker] charges you, but you jump aside with a laugh."	"[The global attacker] charges and even hits you, but inflicts no worse than a bruise."




Chapter 2.2.1.2 - Dog

A dog is a kind of monster.

[The senses]

Instead of examining a dog: say "Dogs come in many sizes and colours. This particular one is of no recognisable breed. It comes almost to your waist, is the colour of ashes, and seems quite ferocious."

Instead of smelling a dog: say "The slightly unpleasant smell of dog.".

Instead of listening to an alive dog: say "It barks at you."

Instead of touching a killed dog: say "Soft and cooling rapidly.".

Instead of tasting a killed dog: say "Although there reputedly are parts of the world where people eat dogs, your village is not one of them.".


[The numbers]

The blood of a dog is usually 8.
The zeal of a dog is usually 0.
The melee of a dog is usually 1.
The mind of a dog is usually 0.
The defense of a dog is usually 3. 

The level of a dog is usually 7.

[The special]

The damage die of a dog is usually 4.

A dog is usually an onholder.

The hold chance of a dog is usually 5.
The hold damage of a dog is usually 1.
The hold leg melee penalty of a dog is usually 1.
The hold leg defence penalty of a dog is usually 1.
The hold arm melee penalty of a dog is usually 1.
The hold arm defence penalty of a dog is usually 1.
The hold release of a dog is usually 3.
The hold self defence penalty of a dog is usually 2.



[The tables]

The player flavour texts of a dog is usually the Table of Dog Player Flavour Texts.
The monster flavour texts of a dog is usually the Table of Dog Monster Flavour Texts.

Table of Dog Player Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text
"A quick stroke, and you sever [possessive of the global defender] head from its neck. Blood sprays all over your chest."	"A big 'yelp', and fur is flying all around you!"	"The damned [global defender] is too quick, and your swing goes wide."	"Your blade collides with the chest of [the global defender], but does no obvious harm."
"With a masterful stroke, you bury your blade in [possessive of the global defender] brain, killing him instantly."	"Evading the slavering fangs, you manage to land a solid blow on [possessive of the global defender] [one of]left[or]right[at random] flank."	"You move in to plant your blade in [possessive of the global defender] head, but a violent counterattack leaves you on the defence."	"With a deft maneuver you manage to hit [the global defender], but your sword doesn't so much as draw blood."
"Swinging your sword, you aim for the legs of [the global defender]. You chop right through the bone! [The global defender] falls down, and you finish it off with a couple of quick thrusts."		"Swinging your sword, you aim for the legs of [the global defender]. The sharp edge bites deep into the flesh."		"Swinging your sword, you aim for the legs of [the global defender]. Your target jumps at the right moment, evading your swing."	"Swinging your sword, you aim for the legs of [the global defender]. You manage to scratch the skin, but no more than that."

Table of Dog Monster Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text
"'All is lost!', you realise as [possessive of the global attacker] fangs close in on your throat."	"You try to duck away as [the global attacker] attacks you, but it is too late. Big teeth and powerful jaws painfully tear at your flesh."	"[The global attacker] goes for your throat, but a backhanded blow with the hilt of your sword persuades it of its mistake."	"Teeth close in on your flesh, but it turns out that you are not an easy prey."
"[The global attacker] goes for your throat, and manages to rip open your jugular vein! With your lifeblood pumping out of you in big gushes, your fate is sealed."	"[The global attacker] evades your swings and sinks its teeth into your body."	"You give a good kick to [the global attacker] as it attempts to hurt you."	"A puzzled expression appears on [possessive of the global attacker] snout when it fails to do any damage to you."
"With a sudden rush, [the global attacker] attacks you. You fall backwards under the force of the onslaught, and within seconds, [the global attacker] is upon you and opens your jugular vein. You die in a pool of your own blood."		"With a sudden rush, [the global attacker] attacks you. Your ineffectual defence cannot stop the attack."		"With a sudden rush, [the global attacker] attacks you.  You sidestep easily, avoiding the blow."	"With a sudden rush, [the global attacker] attacks you. It is more show than substance, and he fails to do any real damage."


Section 2.2.1.2.1 - Doberman

A doberman is a kind of dog.

Instead of examining a doberman: say "A very large dog, black on the upper and brown of the lower side of its body. Its cropped ears are raised menacingly, and its bite is worse than its bark.".

[Numerical differences with other dogs]



Section 2.2.1.2.2 - Pit-bull

A pit-bull is a kind of dog.

Instead of examining a pit-bull: say "Big jaws on legs, the pit-bull is a ferocious fighting dog. Once it grabs hold of someone, it does not let go.".

[Numerical differences with other dogs]

The hold chance of a pit-bull is usually 3. The hold damage of a pit-bull is usually 2. The hold release of a pit-bull is usually 6. The level of a pit-bull is usually 8.



Section 2.2.1.2.3 - Terrier

A terrier is a kind of dog.

Instead of examining a terrier: say "The Jack Russell terrier is a small dog, but much faster than its short legs may suggest. It is white with brown spots.".

[Numerical differences with other dogs]

A terrier is usually a legholder.
A terrier is usually fast.
The damage die of a terrier is usually 3.
The hold leg defence penalty of a terrier is usually 0.
The defense of a terrier is usually 4.
The blood of a terrier is usually 7.



Section 2.2.1.2.4 - Bouvier

A bouvier is a kind of dog.

Instead of examining a bouvier: say "The bouvier is a large black dog, with curious guarding behaviour. It will always allow you to enter its domain without attacking you; but it will not allow you to leave.".

[Numerical differences with other dogs]

A bouvier is usually indifferent.
A bouvier is usually fast.

Instead of going or retreating when an alive indifferent bouvier is enclosed by the location:
	if exactly one alive indifferent bouvier is enclosed by the location begin;
		say "The bouvier suddenly growls menacingly and moves to block your way.";
	otherwise;
		say "The bouviers growl menacingly and move to block your way.";
	end if.



Section 2.2.1.2.5 - German shepherd

A German shepherd is a kind of dog.

Instead of examining a German shepherd: say "The German shepherd is a large black-and-brown dog, originally used for herding sheep but also very effective as a guard dog. It looks very tough.".

[Numerical differences with other dogs]

The blood of a German shepherd is usually 9.
The hold chance of a German shepherd is usually 6.


Section 2.2.1.2.6 - Rhodesian Ridgeback

A Rhodesian Ridgeback is a kind of dog.

Instead of examining a Rhodesian Ridgeback: say "The Rhodesian Ridgeback is a huge brown dog. It gets its name from the characteristic ridge of hair on its back, which gives it an appropriately aggressive look.".

[Numerical differences with other dogs]

The blood of a Rhodesian Ridgeback is usually 10.
The damage die of a Rhodesian Ridgeback is usually 5.
The hold arm melee penalty of a Rhodesian Ridgeback is usually 2.
The hold arm defence penalty of a Rhodesian Ridgeback is usually 2.
The level of a Rhodesian Ridgeback is usually 9.



Chapter 2.2.1.3 - Snake


A snake is a kind of monster.

[The senses]

Instead of examining a snake: say "As long as your forearm, this reptile is well-known for being poisonous. Two sharp teeth protrude from its upper jaw, and a forked tongue flicks and out of its mouth, scenting you."

Instead of smelling a snake: say "The snake has no discernible smell.".

Instead of listening to an alive snake: say "It hisses softly."

Instead of touching a killed snake: say "Scaly, and cold to the touch.".

Instead of tasting a killed snake: say "The meat might be poisonous.".


[The numbers]

The blood of a snake is usually 5.
The zeal of a snake is usually 0.
The melee of a snake is usually 0.
The mind of a snake is usually 0.
The defense of a snake is usually 2.

The level of a snake is usually 4.


[The special]

The damage die of a snake is usually 4.

A snake is usually poisonous.

The poison chance of a snake is usually 1.
The minimum poison damage of a snake is usually 0.
The maximum poison damage of a snake is usually 1.
The poison time of a snake is usually 3.



Chapter 2.2.1.4 - Mud Crab

A mud crab is a kind of monster.


[The senses]

Instead of examining a mud crab: say "A medium-sized crab, not much bigger than hand."

Instead of smelling a mud crab: say "It smells of the swamp.".

Instead of listening to an alive mud crab: say "It shears clack together with a soft clicking sound."

Instead of touching a killed mud crab: say "Hard, cold, slick.".

Instead of tasting a killed mud crab: say "This might not be the time for sea fruit, or for swamp fruit either.".


[The numbers]

The blood of a mud crab is usually 4.
The zeal of a mud crab is usually 0.
The melee of a mud crab is usually 1.
The mind of a mud crab is usually 0.
The defense of a mud crab is usually 1. 

The level of a mud crab is usually 4.

The damage die of a mud crab is usually 3.

[The special]

A mud crab is usually fireproof.

The damage reduction of a mud crab is usually 1.

A mud crab is usually lowlightvisioned.


Chapter 2.2.1.5 - Bat

A bat is a kind of monster.


[The numbers]

The blood of a bat is usually 4.
The zeal of a bat is usually 0.
The melee of a bat is usually 1.
The mind of a bat is usually 0.
The defense of a bat is usually 3.

The level of a bat is usually 3.

The damage die of a bat is usually 2.


[The special]

A bat is usually darkvisioned.


[The tables]

The player flavour texts of a bat is usually the Table of Bat Player Flavour Texts.
The monster flavour texts of a bat is usually the Table of Bat Monster Flavour Texts.

Table of Bat Player Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text
"You wait until [the global defender] flies towards you, then suddenly raise your sword. The bat doesn't see it coming and impales itself upon your blade!"	"You manage to cut off part of [possessive of the global defender] [one of]left[or]right[purely at random] wing, but it's not enough to bring it down."	"The point of your blade almost hits [the global defender], but it flits out of the way just in time."	"You hit [the global defender] but do no real damage."
"Two fast cuts and [the global defender] loses both its wing, falling helplessly on the ground. You take great pleasure in crushing its head under the heel of your boot."	"You give [the global defender] a serious whack on its little head."	"[The global defender] flutters all about you, and however hard you try, you can't seem to hit it."	"Your blow hits, but merely knocks [the global defender] back."
"You wonder if bats have an ultrasonic death shriek--it's a pity you wouldn't be able to hear it if they did. Anyway, this sucker is down, and it's not getting up again."	"The flat of your blade knocks [the global defender] to the other side of the room."	"Damn those fast wings! Your swing goes wide again."	"With a deft maneuver you manage to hit [the global defender], but your sword doesn't so much as draw blood."

Table of Bat Monster Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text
"You shriek and shriek as [the global attacker] sets its sharp little teeth in your eyes, and beats its wings against your ears--but you were already weakened, and your life flows away with the screams."	"[The global attacker] dives for your head. You try to duck away, but it is faster than you."	"You manage to keep [the global attacker] at bay with your sword."	"[Possessive of the global attacker] teeth are small and can't hurt you."
"You shriek and shriek as [the global attacker] sets its sharp little teeth in your eyes, and beats its wings against your ears--but you were already weakened, and your life flows away with the screams."	"You feel the sharp teeth of [the global attacker] sinking into your neck."	"You punch [the global attacker] away before it can bite you."	"You laugh at [the global attacker] as it attempts to bite through your armour."
"What could a bat do to you? Yet--suddenly you stumble, and you realise that you've lost much blood. Too much blood. You stumble again; you fall; everything blacks out."	"Furiously beating its wings and displaying its sharp teeth, the bat penetrates your defences and your skin!"	"You duck away, and [the global defender] flies by."	"You laugh at [the global attacker] as it attempts to bite through your armour."



Chapter 2.2.1.6 - Scorpion

A scorpion is a kind of monster.

[The numbers]

The blood of a scorpion is usually 5.
The zeal of a scorpion is usually 0.
The melee of a scorpion is usually 0.
The mind of a scorpion is usually 0.
The defense of a scorpion is usually 2.

The level of a scorpion is usually 5.


[The special]

The damage die of a scorpion is usually 2.

A scorpion is usually poisonous.

The poison chance of a scorpion is usually 3.
The minimum poison damage of a scorpion is usually 0.
The maximum poison damage of a scorpion is usually 2.
The poison time of a scorpion is usually 3.

A scorpion is usually fireproof.

The damage reduction of a scorpion is usually 1.

A scorpion is usually darkvisioned.


Part 2.2.2 - Animal-like monstrous creatures




Chapter 2.2.2.1 - Water Serpent

A water serpent is a kind of monster.


[The senses]

Instead of examining a water serpent: say "A monstrous beast, as thick as your waist and easily thrice your length. Two sharp teeth protrude from its upper jaw, and a forked tongue flicks and out of its mouth, scenting you."

Instead of smelling a water serpent: say "The serpent smells slightly of fish.".

Instead of listening to an alive water serpent: say "Its hissing is hardly to be heard above the sounds of splashing water."

Instead of touching a killed water serpent: say "Scaly and wet, like a fish.".

Instead of tasting a killed water serpent: say "The meat might be poisonous.".


[The numbers]

The blood of a water serpent is usually 10.
The zeal of a water serpent is usually 0.
The melee of a water serpent is usually 1.
The mind of a water serpent is usually 0.
The defense of a water serpent is usually 3. 

The level of a water serpent is usually 15.


[The special]

A water serpent is usually poisonous.

The poison chance of a water serpent is usually 2.
The minimum poison damage of a water serpent is usually 0.
The maximum poison damage of a water serpent is usually 1.
The poison time of a water serpent is usually 4.



Chapter 2.2.2.2 - Giant Mud Crab

A giant mud crab is a kind of monster.


[The senses]

Instead of examining a giant mud crab: say "A crab-like creature the size of a cow, with big shears that look as it they could easily crack a woman's skull. Its thick carapace seems nigh impenetrable."

Instead of smelling a giant mud crab: say "It smells of the swamp.".

Instead of listening to an alive giant mud crab: say "It shears clack together with the sound of brick on brick."

Instead of touching a killed giant mud crab: say "Hard, cold, slick.".

Instead of tasting a killed giant mud crab: say "This might not be the time for sea fruit, or for swamp fruit either.".


[The numbers]

The blood of a giant mud crab is usually 13.
The zeal of a giant mud crab is usually 0.
The melee of a giant mud crab is usually -1.
The mind of a giant mud crab is usually 0.
The defense of a giant mud crab is usually 1. 

The level of a giant mud crab is usually 14.

The damage die of a giant mud crab is usually 10.

[The special]

A giant mud crab is usually slow.

A giant mud crab is usually fireproof.

The damage reduction of a giant mud crab is usually 5.

A giant mud crab is usually an erratic attacker.
The erratic attack odds of a giant mud crab is usually 2.
The erratic attack failure text of a giant mud crab is usually "The giant mud crab [one of]lumbers forward[or]attempts to turn its huge body in your direction[or]raises its giant shears for its attack[at random][one of], while its stick-supported eyes flawlessly track your position[or], accompanied by the harsh clicking of its six hind legs[or][at random].[paragraph break]".

A giant mud crab is usually lowlightvisioned.



Chapter 2.2.2.3 - Vampire bat

A vampire bat is a kind of monster.


[The numbers]

The blood of a vampire bat is usually 5.
The zeal of a vampire bat is usually 0.
The melee of a vampire bat is usually 2.
The mind of a vampire bat is usually 0.
The defense of a vampire bat is usually 2.

The level of a vampire bat is usually 8.

The damage die of a vampire bat is usually 3.


[The special]

A vampire bat is usually vampiric.

The vampire ratio of a vampire bat is usually 8.

A vampire bat is usually darkvisioned.

[The tables]

The player flavour texts of a vampire bat is usually the Table of Bat Player Flavour Texts.
The monster flavour texts of a vampire bat is usually the Table of Bat Monster Flavour Texts.


Chapter 2.2.2.4 - Monstrous scorpion


A monstrous scorpion is a kind of monster.

[The numbers]

The blood of a monstrous scorpion is usually 12.
The zeal of a monstrous scorpion is usually 0.
The melee of a monstrous scorpion is usually 1.
The mind of a monstrous scorpion is usually 0.
The defense of a monstrous scorpion is usually 2.

The level of a monstrous scorpion is usually 16.


[The special]

The damage die of a monstrous scorpion is usually 4.

A monstrous scorpion is usually poisonous.

The poison chance of a monstrous scorpion is usually 4.
The minimum poison damage of a monstrous scorpion is usually 1.
The maximum poison damage of a monstrous scorpion is usually 4.
The poison time of a monstrous scorpion is usually 4.

A monstrous scorpion is usually fireproof.

The damage reduction of a monstrous scorpion is usually 3.

A monstrous scorpion is usually darkvisioned.




Part 2.2.3 - Humans

Chapter 2.2.3.1 - Guards

Section 2.2.3.1.1 - Normal guards

A guarder is a kind of monster.

The blood of a guarder is usually 8.
The zeal of a guarder is usually 0.
The melee of a guarder is usually 1.
The mind of a guarder is usually 0.
The defense of a guarder is usually 2. 

The level of a guarder is usually 10.

[The specials]

The damage reduction of a guarder is usually 1.




Part 2.2.4 - Human-like monstrous creatures


Chapter 2.2.4.1 - Trolls


Section 2.2.4.1.1 - Troll

A troll is a kind of monster.


[The senses]

Instead of examining a troll: say "This massive and foul-smelling creature, vaguely humanoid but completely covered in greasy black hair, might well outweigh a large bull. It is a troll, a creature of legendary cruelty, obscenely naked and quite as filthy as the legends describe.".

Instead of smelling a troll: say "The rank smells of old piss and rotting eggs waft from its body.".

Instead of listening to an alive troll: say "It grunts incessantly, except when it noisily blows its nose in the hair on its simian arms.".

Instead of touching a killed troll: say "Its hairy skin is covered with substances that appear to be snot, blood and shit. Nothing will make you touch that.".

Instead of tasting a killed troll: say "Its hairy skin is covered with substances that appear to be snot, blood and shit. Nothing will make you taste that.".


[The numbers]

The blood of a troll is usually 15.
The zeal of a troll is usually 0.
The melee of a troll is usually 1.
The mind of a troll is usually 0.
The defense of a troll is usually 3. 

The level of a troll is usually 20.

[The specials]

A troll is usually slow.


A troll is usually regenerating. The regeneration rate of a troll is 2.


Section 2.2.4.1.2 - Young Troll

A young troll is a kind of monster.


[The senses]

Instead of examining a young troll: say "This man-sized foul-smelling creature, vaguely humanoid but largely covered in greasy brown hair, is a young troll. Its cruel leer shows nothing of the innocence of childhood.".

Instead of smelling a young troll: say "The rank smells of piss and rotting eggs waft from its body.".

Instead of listening to an alive young troll: say "The young troll noisily smacks his mouth."

Instead of touching a killed young troll: say "Its hairy skin is covered with substances that appear to be snot, blood and shit. Nothing will make you touch that.".

Instead of tasting a killed young troll: say "Its hairy skin is covered with substances that appear to be snot, blood and shit. Nothing will make you taste that.".


[The numbers]

The blood of a young troll is usually 10.
The zeal of a young troll is usually 0.
The melee of a young troll is usually 1.
The mind of a young troll is usually 0.
The defense of a young troll is usually 3. 

The level of a young troll is usually 11.

[The specials]

A young troll is usually slow.

A young troll is usually regenerating. The regeneration rate of a young troll is 1.


Chapter 2.2.4.2 - Straw people

A straw being is a kind of monster.


[The senses]

Instead of examining a straw being: say "[The noun] is made completely of straw.".

Instead of smelling a straw being: say "The characteristic odour of slightly wet straw.". 

Instead of listening to an alive straw being: say "It is silent.".

Instead of touching a killed straw being: say "Smooth, yet prickly--straw."

Instead of tasting a killed straw being: say "That is not the edible part of grain.".

[The numbers]

The blood of a straw being is usually 10.
The zeal of a straw being is usually 0.
The melee of a straw being is usually 1.
The mind of a straw being is usually 99.
The defense of a straw being is usually 5. 

The level of a straw being is usually 1.

[The specials]

A straw being is usually slow.

A straw being is usually non-exciting.

A straw being is usually an erratic attacker.
The erratic attack odds of a straw being are usually 0.
The erratic attack failure text of a straw being is usually "[The global attacker] [one of]would have attacked you, had he been able to[or]just stands there[or]awaits your fury[at random].[paragraph break]".

The player flavour texts of a straw being is usually the Table of Straw Player Flavour Texts.
The monster flavour texts of a straw being is usually the Table of Straw Monster Flavour Texts.

Table of Straw Player Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text
"You hit [the global defender] with a satisfying blow, and straw flies all around the room. That's one less thing in the world to bother you!"	"You land a solid blow against [the global defender]. Several pieces of straw come loose and fall to the ground."	"You manage to miss [the global defender]."	"The soft straw absorbs the impact of your blow."
"With a load laugh you decapitate [the global defender], its straw-filled head rolling across the floor."	"You stick your sword into [the global defender]. It would have done more damage had there been any vital organs inside."	"With a loud *thunk* your sword hits the floor."	"The soft straw absorbs the impact of your blow."
"You hit [the global defender] with a satisfying blow, and straw flies all around the room. That's one less thing in the world to bother you!"	"[The global defender] appears to beg for mercy as your blade mercilessly hacks into the straw."	"Somehow, your blow misses [the global defender]."	"The soft straw absorbs the impact of your blow."

Table of Straw Monster Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text
"Congratulations. You were killed by a being made of straw. Please do not expect me to write a serious message about how it smothered you with its evil straw-filled hands."	"[The global attacker] thumps you in the gut."	"It does its best, but [the global attacker] doesn't really pose a threat to you."	"[The global attacker] hits you, but its straw hands don't do any real damage."
"Congratulations. You were killed by a being made of straw. Please do not expect me to write a serious message about how it smothered you with its evil straw-filled hands."	"[The global attacker] jumps at you, almost knocking you to the ground by its sheer weight."	"Slow and clumsy, the blows of [the global attacker] go wide."	"[The global attacker] hits you, but its straw hands don't do any real damage."
"Congratulations. You were killed by a being made of straw. Please do not expect me to write a serious message about how it smothered you with its evil straw-filled hands."	"With a masterful kick, [the global attacker] does some real damage to your [one of]left[or]right[purely at random] knee."	"[The global attacker] kicks in your general direction, but you jump aside easily."	"[The global attacker] hits you, but its straw hands don't do any real damage."



Part 2.2.5 - Plant monsters




Part 2.2.6 - Pure monsters


Chapter 2.2.6.1 - Tarrasque

A tarrasque is a kind of monster.

[The senses]

Instead of examining a tarrasque: say "A hundred meters high, covered in armour thicker than most walls, with claws as large as men and as sharp as hatred, this is undoubtedly the worst monster ever imagined."

Instead of examining a killed tarrasque: say "You KILLED the tarrasque? You are god!"; end the game in victory.

Instead of smelling a tarrasque: say "You smell your own blood.".

Instead of listening to an alive tarrasque: say "You only hear your own blood pounding in your ears."

Instead of touching a killed tarrasque: say "You KILLED the tarrasque? You are god!"; end the game in victory.

Instead of tasting a killed tarrasque: say "You KILLED the tarrasque? You are god!"; end the game in victory.


[The numbers]

The blood of a tarrasque is usually 1000.
The zeal of a tarrasque is usually 0.
The melee of a tarrasque is usually 25.
The mind of a tarrasque is usually 0.
The defense of a tarrasque is usually 30. 

The level of a tarrasque is usually 1000.


[The special]

A tarrasque is usually fast.

The damage die of a tarrasque is usually 100. The damage bonus of a tarrasque is usually 10.

[The tarrasque appears as a result of saying "xyzzy".]

The xyzzied tarrasque is a tarrasque. Rule for printing the name of the xyzzied tarrasque: say "tarrasque".



Chapter 2.2.6.2 - Imps


[Defining the imps which you can summon with Summon Imp]

An imp is a kind of monster.

The blood of an imp is usually 3.
The zeal of an imp is usually 0.
The melee of an imp is usually 0.
The mind of an imp is usually 0.
The defense of an imp is usually 1. 

The level of an imp is usually 4.

An imp is usually fireproof.
An imp is usually summoned.
The damage die of an imp is usually 2.

An imp is usually fast.

An imp is usually lowlightvisioned.

[The specific imps]

The green imp is an imp. The defense of the green imp is 2.

The red imp is an imp. The damage die of the red imp is 3.

The blue imp is an imp. The blood of the blue imp is 4.




Book 2.3 - Combat Items

Chapter 2.3.0.1 - Stick of Guarding

A stick of guarding is a kind of thing. The plural of stick of guarding is sticks of guarding. The printed plural name of stick of guarding is "sticks of guarding". Understand "stick" as stick of guarding. [Bug in Inform. TODO!]

The global guarding stick number is a number that varies. The global guarding stick number is 0.

Instead of examining a stick of guarding:
	say "This tough stick contains magical powers. Once you break it, you get a +1 defence bonus for 6 turns.".

Unprotecting is an activity.

Rule for unprotecting:
	say "The effect of the stick of guarding wears off.";
	decrease the global guarding stick number by 1.

Instead of attacking a stick of guarding:
	say "With a sharp CLICK, you snap the stick of guarding in two. You now feel protected.";	
	schedule unprotecting in 6 turns;
	increase the global guarding stick number by 1; 
	remove the noun from play.




Chapter 2.3.0.2 - Healing Herbs

A healing herbs are a kind of thing. The indefinite article of healing herbs is "some". The plural of healing herbs is packets of healing herbs. The printed plural name of healing herbs is "packets of healing herbs". Understand "packet" as healing herbs.

Instead of examining healing herbs:
	say "Eating these fresh herbs will instantly heal you for 2 Blood. It is only a small boon, but it can be the difference between life and death.".

Instead of eating healing herbs:
	say "You carefully munch the herbs, receiving ";
	heal the player for 2 blood;
	say " blood.";
	remove the noun from play.


Chapter 2.3.0.3 - Fire Grenade

A fire grenade is a kind of thing. The player carries a fire grenade.

Instead of examining a fire grenade:
	say "Just [italic type]throw[roman type] these grenades for a fiery surprise. Be warned: these things are not safe to use, and may harm you as much as they harm your enemies.".

Instead of throwing a fire grenade at something:
	try throwing the noun.


Instead of throwing a fire grenade:
	say "You throw the fire grenade, and it explodes with a loud BANG! (";
	now the printing state is printing-fiery;
	repeat with the sucker running through alive monsters enclosed by the location begin;
		now the first dummy is a random number between 1 and 6;
		say "Rolling ", first dummy, " against a target number of 4, ";
		if the first dummy is less than 4 begin;
			if the sucker is not fireproof begin;
				say "[the sucker] catches fire. ";
				silently set fire to the sucker;
			otherwise;
				say "[the sucker] would have caught fire if it had not been resistant. ";
			end if;
		otherwise;
			say "[the sucker] does not catch fire. ";
		end if;
	end repeat;
	now the first dummy is a random number between 1 and 6;
	say "Anticipating the explosion and rolling ", first dummy, " against a target number of 3, ";
	if the first dummy is less than 3 begin;
		set fire to the player;
		say "you, alas, catch fire!)";
	otherwise;
		say "you duck away at right moment!)";
	end if;
	now the printing state is printing-normal;
	remove the noun from play.


Chapter 2.3.0.4 - Stick of Illumination

A stick of illumination is a kind of thing. The plural of stick of illumination is sticks of illumination. The printed plural name of stick of illumination is "sticks of illumination". Understand "stick" as stick of illumination. [Bug in Inform. TODO!] 

A stick of illumination is either broken or unbroken. Understand the unbroken property as describing a stick of illumination. A stick of illumination is usually unbroken. A stick of illumination is either mild or fierce. Understand the mild property as describing a stick of illumination.

A stick of illumination has a number called the illumination time. The illumination time of a stick of illumination is usually 0.

Instead of examining a stick of illumination:
	say "This tough stick contains magical powers. After you break it, it shines with a bright light for 8 turns and with low light for another 12 turns.".

Every turn:
	repeat with the potential stick running through broken sticks of illumination begin;
		decrease the illumination time of the potential stick by 1;
		if the illumination time of the potential stick is 12 begin;
			if the potential stick is visible, say "The stick of illumination glows less fiercely.";
			now the potential stick is mild;
			now the printed name of the potential stick is "broken stick of illumination, glowing mildly";
			now the printed plural name of the potential stick is "broken sticks of illumination, glowing mildly";
			now the illumination of the potential stick is 1;
		end if;
		if the illumination time of the potential stick is 0 begin;
			if the potential stick is visible, say "The stick of illumination goes dark, so you throw it away.";
			remove the potential stick from play;
		end if;
	end repeat.

Does the player mean attacking a broken stick of illumination: it is unlikely.

Instead of attacking a stick of illumination:
	if the noun is broken, say "You can only do that to an unbroken stick." instead;
	say "With a sharp CLICK, you snap the stick of illumination in two. It now shines with a bright light.";
	now the illumination of the noun is 2;
	now the illumination time of the noun is 20;
	now the noun is fierce; now the noun is broken;
	now the printed name of the noun is "broken stick of illumination, glowing fiercely";
	now the printed plural name of the noun is "broken sticks of illumination, glowing fiercely".






Volume 3 - The World


Part - Tutorial and Demonstration

Tutorial is a scene. Demonstration is a scene.

Tutorial begins when the player is in Lesson One - Introduction. Tutorial ends when demonstration begins. Tutorial ends when the player is in Beneath the Pine Tree.

[Demonstration begins when the player is in Demonstration Area 1. Demonstration ends when the player is in Beneath the Pine Tree.]

The tutorial deadly combat boolean is a truth state that varies. The tutorial deadly combat boolean is false.

To do the tutorial deadly combat check:
	 if the tutorial deadly combat boolean is false, now the deadly combat bonus is 0.


Chapter - Tutorial Lesson 1

Lesson One - Introduction is a room. "In this tutorial, you will learn the basics of the tactical combat system used in the game. That's right, [italic type]tactical[roman type] combat--you won't overcome your enemies by just typing 'attack' over and over again. If you're ready to start learning, please proceed to the [bold type]west[roman type]."

The player is in Lesson One - Introduction.


Chapter - Tutorial Lesson 2


Lesson Two - The Interface is west of Lesson One - Introduction. "Let us talk about the interface first. At the top left of your screen, you will see the name of the room you are currently in, 'Lesson Two - The Interface'. To the right of the room name is essential combat information: your Blood, your Zeal, your state of excitement, and the Circle you're in. Please make sure that the window of your interpreter is broad enough to show them all. Once you've done so, read the posters in this room, then proceed to the [bold type]west[roman type] or go back to the [bold type]east[roman type]."

In Lesson Two - The Interface are the Blood Poster, the Zeal Poster, the Excitement Poster and the Circle Poster.

The Blood Poster is fixed in place. Instead of examining the Blood Poster: say "Blood designates your health. If your Blood ever drops to 0, you will die--which is something you should avoid. The status bar shows two values: the first is your current Blood, the second is your maximum Blood. In general your current Blood cannot be higher than your maximum Blood.[paragraph break]You lose Blood by getting hit by your enemies, and you regain Blood by killing enemies. (There are other ways to lose and regain Blood, but you'll have to find out about those during the game.)".

The Zeal Poster is fixed in place. Instead of examining the Zeal Poster: say "Zeal designates how much the Gods of War favour you. You will need Zeal to use special skills taught by the Gods. The Status Bar shows two values: the first is your current Zeal, the second is your maximum Zeal. In general your current Zeal cannot be higher than your maximum Zeal.[paragraph break]Your Zeal decreases when you use special skills more than once during a single combat. Your Zeal increases when you win particularly hard fights, and also when you complete quests that make the Gods favour you.".

The Excitement Poster is fixed in place. Instead of examining the Excitement Poster: say "Excitement is a measure of your passion, anger, hatred, frustration--everything that drives you to prevail in combat. You start out as Calm, but you can become Animated, Excited, Agitated, Frantic and Frenzied during the game. Higher states of excitement give you bigger combat bonuses.[paragraph break]You may gain Excitement by killing, by hitting and by being hit--this is randomly determined. There are also some skills that allow you to raise your excitement. You gradually lose Excitement when you are not in combat, and you can lower it yourself by either concentrating or calming down. You'll learn more about that later.".

The Circle Poster is fixed in place. Instead of examining the Circle Poster: say "The main game is divided into several circles, or regions. This is important for the game mechanics in several ways. First, saving in combat costs more Zeal in higher circles; second, powerful skills granted by the Gods can only be learned and used in higher circles. You'll find out more about circles as you play the game; there is no need to worry about it now.".


Chapter - Tutorial Lesson 3

Lesson Three - Attacking is west of Lesson Two - The Interface. "Enough talk--let's have some action. In this lesson, we will learn the most basic combat action: attacking. Just attack the straw man by typing 'attack straw man'. Don't worry, he won't be able to attack you. Once the straw man is dead, you can proceed to the [bold type]west[roman type] or go back to the [bold type]east[roman type]."



The straw man is a straw being in Lesson Three - Attacking. 

The defense of the straw man is 0. 


After attacking in Lesson Three - Attacking for the first time:
	say "[bold type]You'll be seeing something like this: 'Rolling 5 + 1 = 6, you beat the straw man's defence rating of 0. You deal 2 - 1 (calm) = 1 damage, wounding the straw man to 9 blood.' What does that mean?[paragraph break]The first number is the result of a random roll between 1 and 10. To this is added your attack bonus, which is currently 1. There are no other modifiers, so the result is the sum of these two numbers.[paragraph break]If this result is higher than 0--the defence rating of the straw man--you hit. Of course, most of your enemies will have a higher defence rating than this straw man. If you hit your enemy, you deal damage. The amount of damage you deal is a random number between 1 and 6, plus any modifiers. In this case, you got a - 1 damage penalty for being calm; this penalty will go away and then turn into a bonus as your excitement increases.[paragraph break]Now attack the straw man some more.[roman type][paragraph break]". 


After attacking in Lesson Three - Attacking for the second time:
	say "[bold type]It may be good to know that you can abbreviate 'attack' to 'a'. If there is only one enemy around, you can even leave out the name of the enemy: just 'a' will work fine.[roman type][paragraph break]"


Chapter - Tutorial Lesson 4

Lesson Four - Concentrating is west of Lesson Three - Attacking. "Things would get boring quickly if all you could do was type 'attack', so in most of this tutorial we will be concerned with adding new options. The first option we will add is 'concentrate'. Concentrating is a great way to increase both your attack bonus and your damage bonus. Just type 'concentrate' or 'c' to try it out. Once you are ready, proceed to the [bold type]west[roman type] or go back to the [bold type]east[roman type]."

The tutorial lesson four number is a number that varies. The tutorial lesson four number is 0.

The straw woman is a straw being in Lesson Four - Concentrating. 

The blood of the straw woman is 16.

The erratic attack failure text of the straw woman is "The straw woman [one of]would have attacked you, had she been able to[or]just stands there[or]awaits your fury[at random].[paragraph break]".


After concentrating in Lesson Four - Concentrating for the first time:
	say "[bold type]Great! Now attack the straw woman to see your bonus in action.[roman type][paragraph break]"; now the tutorial lesson four number is 1.

After concentrating in Lesson Four - Concentrating for the second time:
	if the tutorial lesson four number is 1, now the tutorial lesson four number is 3. [Don't tell about multiple concentrations if the player has already found this out herself.]

After concentrating in Lesson Four - Concentrating for the third time:
	say "[bold type]An important tip: if you are damaged while concentrating, you may lose your concentration! That's not relevant here, since the straw woman never hits you--but it will be important in real fights.[roman type][paragraph break]"

After attacking in Lesson Four - Concentrating:
	if the tutorial lesson four number is 1 begin;
		say "[bold type]Very good. But that wasn't a very significant bonus, was it? Luckily, you can boost your concentration bonus by concentrating up to three times in a row before attacking--try it now! You can proceed to the next room after you've killed the straw woman.[roman type][paragraph break]";
		now the tutorial lesson four number is 2;
	end if.

Before going west in Lesson Four - Concentrating for the first time:
	now the blood of the player is 1000;
	now the permanent blood of the player is 1000.


Chapter - Tutorial Lesson 5

Lesson Five - Defending is west of Lesson Four - Concentrating. "In this lesson, you will learn two additional standard combat commands: [italic type]parry[roman type] and [italic type]dodge[roman type]. The monster here can actually attack you, and these two commands will help you resist his attacks. Try them out, then defeat the monster using what you learned in the previous lessons. Don't worry about dying; we've temporarily given you 1000 Blood. Once you are ready, either go [bold type]south[roman type] to Lesson Six, [bold type]west[roman type] to Lesson Seven, or back [bold type]east[roman type]."

The straw golem is a straw being in Lesson Five - Defending.

The straw golem is not an erratic attacker.
The blood of the straw golem is 12.
The melee of the straw golem is 0.
The damage die of the straw golem is 5.


After parrying in Lesson Five - Defending for the first time:
	say "[bold type]Very good! When you are parrying your opponents[apostrophe] attacks, you will receive less damage from them. (A random amount between 0 and 4 damage is subtracted from the damage you would otherwise have received.) Parrying lasts until you attack, use an offensive skill or dodge; but you can concentrate or use a defensive skill without breaking your parry. (You will learn about offensive and defensive skills and the difference between them in later lesson.)[roman type][paragraph break]".

After parrying in Lesson Five - Defending for the second time:
	say "[bold type]By the way, you can abbreviate 'parry' to 'p'.[roman type]".

After dodging in Lesson Five - Defending for the first time:
	say "[bold type]Very good! When you are dodging your opponents[apostrophe] attacks, your defence increases by 2, making it harder for your opponents to hit you. Dodging lasts until you attack, use an offensive skill or parry; but you can concentrate or use a defensive skill without breaking your dodge. (You will learn about offensive and defensive skills and the difference between them in later lesson.)[roman type][paragraph break]".

After dodging in Lesson Five - Defending for the second time:
	say "[bold type]By the way, you can abbreviate 'dodge' to 'do'.[roman type]".

Before going west in Lesson Five - Defending for the first time:
	now the tutorial deadly combat boolean is true.


Chapter - Tutorial Lesson 6

Lesson Six - Retreating is south of Lesson Five - Defending. "You now face an opponent whom you will not be able to defeat. (You can try if you wish!) The only action left to you in such circumstances is to [italic type]retreat[roman type]--try it now. You can then proceed directly from Lesson Five to Lesson Six."

The straw dragon is a straw being in Lesson Six - Retreating. "A really tough-looking straw dragon dominates this room."

The blood of the straw dragon is 1000.
The defense of the straw dragon is 25.
The damage reduction of the straw dragon is 40.

Before retreating in Lesson Six - Retreating for the first time:
	say "[bold type]A word of advice: retreating does not always work. Your chance of success depends on the number of opponents you face, their speed, and your health relative to theirs. So be careful, and don't get into fights you can neither win nor run away from.[roman type][paragraph break]".


Chapter - Tutorial Lesson 7

Lesson Seven - Deadly Combat is west of Lesson Five - Defending. "I have to admit that we've cheated a bit in the previous lessons. A very important dimension of fighting is what we call 'deadly combat', but in order not to confuse you, we turned it off for the first six lessons. It's back on now--so please read the poster, fight the monster, and see deadly combat in action. Once you're ready, you can proceed to the [bold type]west[roman type]."

The Deadly Combat Poster is here. Instead of examining the Deadly Combat Poster: say "Sometimes in a fight, there is a temporary stand-off: everybody misses, people are concentrating or defending, or they are using non-offensive skills. During those moments, the tension is building--the next blow is going to be important![paragraph break]That is where 'deadly combat' comes in. If nobody gets hit in an entire round of combat, then the next turn, all combatants will have a +1 bonus to their attack roll and will deal +1 damage if they hit. If this doesn't lead to someone getting hit, then in the succeeding turn, all combatants will have a +2 bonus to their attack roll and will deal +2 damage if they hit. And so on--until the maximum deadly combat bonuses of +5 / +5 have been reached. Once a hit has been scored, the bonus is not reset immediately. In the next turn, it will be 2 lower than it was in the turn before.[paragraph break]It really pays to keep an eye on deadly combat. You don't want to miss your opportunity to hit your opponent with some great bonuses![paragraph break]You can easily try out deadly combat in this room: just concentrate or defend for a few round, then attack your opponent. You will see the bonuses in action.[paragraph break](Please note that several actions, such as examining and looking, do not take any time in this game. Hence, using them will not constitute a combat round and will not increase the deadly combat modifiers.)".

The straw chicken is a straw being in Lesson Seven - Deadly combat.

The defense of the straw chicken is 9. The blood of the straw chicken is 22.

The erratic attack failure text of the straw chicken is "The straw chicken [one of]would have attacked you, had she been able to[or]just stands there[or]awaits your fury[at random].[paragraph break]".





Book 3.0 - Scenes

Chapter 3.0.0.1 - The Introduction

[TODO!] [When play begins: start the intro.]


To start the intro: say "[bold type]Just look at you! Sleeveless shirt, four feet of bared steel shining in the cold morning sun. Quite the hero. It's clear to everybody and their grandmother that your masculine physique will be covered with blood in less than five minutes. How much of it will be yours? Little, if you're half the man you used to be.";
run a conversation from c_intro.

c_intro, c_intro_2, c_intro_3, c_intro_4, c_intro_5, c_intro_6, c_intro_7, c_intro_8, c_intro_9 and c_intro_10 are chat nodes.


Instead of giving text for c_intro: say "Just one question, before the killing starts.[paragraph break]This is all about you and Michael, isn't it?".
Instead of finding responses to c_intro: forbid exiting on zero; link to c_intro_2; link to c_intro_3; link to c_intro_4.

Instead of giving link to c_intro_2: say "'Michael? I don't give a damn about Michael.'".
Instead of giving text for c_intro_2: say "Sure. You spent twelve years in the dungeon because of him, and yet you don't give a damn. How wonderfully stoical.".
Instead of finding responses to c_intro_2: forbid exiting on zero; link to c_intro_5; link to c_intro_6; link to c_intro_7.

Instead of giving link to c_intro_3: say "'If I meet the bastard, he's dead.'".
Instead of giving text for c_intro_3: say "I don't doubt it. After all, it was his fault that you got to spend twelve years in the dungeon.".
Instead of finding responses to c_intro_3: forbid exiting on zero; link to c_intro_5; link to c_intro_6; link to c_intro_8.

Instead of giving link to c_intro_4: say "'[italic type]Everything[bold type] has always been about me and Michael.'".
Instead of giving text for c_intro_4: say "True. But something is about to change forever between the two of you. I'm very curious to see that.".
Instead of finding responses to c_intro_4: forbid exiting on zero; link to c_intro_9; link to c_intro_10.

Instead of giving link to c_intro_5: say "'It wasn't his fault!'".
Instead of giving text for c_intro_5: say "Fine. If that's what you want to believe, who am I to disabuse you?".
Instead of finding responses to c_intro_5: forbid exiting on zero; link to c_intro_9; link to c_intro_10.

Instead of giving link to c_intro_6: say "'[italic type]Don't[bold type] remind me of the dungeon.'".
Instead of giving text for c_intro_6: say "No? Have you become scared? What would have scared you down there, I wonder. The darkness? The mice? I don't think so. But the confinement... the helplessness of iron chains around your limbs and unbreakable walls of stone around your body... that must have been terrible for a man of action. That might have driven you mad.".
Instead of finding responses to c_intro_6: forbid exiting on zero; link to c_intro_9; link to c_intro_10.

Instead of giving link to c_intro_7: say "'Surprised? Maybe I learned something down there. Maybe I've learnt to contain my rage and stay calm. How would you like that?'".
Instead of giving text for c_intro_7: say "Oh, you know I would love it--but its a little too hard to believe. I think your anger is ready to break out at the slightest provocation.".
Instead of finding responses to c_intro_7: forbid exiting on zero; link to c_intro_9; link to c_intro_10.

Instead of giving link to c_intro_8: say "'It was, and he'll pay for it. By having his spine smashed through his brain.'".
Instead of giving text for c_intro_8: say "Why, how subtle of you. I'm eagerly anticipating the conclusion of your adventure.".
Instead of finding responses to c_intro_8: forbid exiting on zero; link to c_intro_9; link to c_intro_10.

Instead of giving link to c_intro_9: say "'Who are you anyway?'".
Instead of giving text for c_intro_9: say "Never mind. You're probably just talking to yourself, without even realising it. Solitary confinement does that to people.[paragraph break]But I've got to go now. There are other presences around, and I don't want to be detected--yet.[roman type]";
wait for any key; clear the screen;
say "FIRST CIRCLE: THE BRUTES[paragraph break][paragraph break][paragraph break][paragraph break][paragraph break][paragraph break]";
wait for any key; clear the screen.

Instead of giving link to c_intro_10: say "'Just shut up, and let me go my own way.'".
Instead of giving text for c_intro_10: say "Of course, your time is valuable. I was about to go anyway: there are other presences around, and I don't want to be detected.[roman type]";
wait for any key; clear the screen;
say "FIRST CIRCLE: THE BRUTES[paragraph break][paragraph break][paragraph break][paragraph break][paragraph break][paragraph break]";
wait for any key; clear the screen.



Part 3.0.1 - Break-out

Break-out is a scene.

When Break-out begins:
	change player to the prisoner;
	run a conversation from c_prison_1.


c_prison_1, c_prison_2, c_prison_3, c_prison_4, c_prison_5, c_prison_6 are chat nodes.

Instead of giving text for c_prison_1: say "[bold type]So the Gods talk to you. Bet you think that's impressive, huh? Like you're the 'Chosen One' or something.[roman type][line break]".
Instead of finding responses to c_prison_1: forbid exiting on zero; link to c_prison_2; link to c_prison_3; link to c_prison_4.

Instead of giving link to c_prison_2: say "'I don't know about impressive, but it's useful. It's the only reason I'm free.'".
Instead of giving text for c_prison_2: say "[bold type]Yeah? Then tell me--how did you manage to escape?[roman type][line break]".
Instead of finding responses to c_prison_2: forbid exiting on zero; link to c_prison_5.

Instead of giving link to c_prison_3: say "'Chosen? Maybe. But the attention of the Gods is a curse.'".
Instead of giving text for c_prison_3: say "[bold type]So you didn't forget everything that Wilfrid taught you. That's good. I didn't know in what mental shape you would be now, after all those years in the dungeon. Which reminds me--how did you manage to escape?[roman type][line break]".
Instead of finding responses to c_prison_3: forbid exiting on zero; link to c_prison_5.

Instead of giving link to c_prison_4: say "'Chosen One, right. You see, I am the only living male descendant of the God-King Bwaldor, who died two thousand years ago. Before his death he spoke a prophecy that one day, when things looked most dire for the Kingdoms of Men, his heir would rise against the ancient evil. That heir is me. I am fated to save the entire world from certain destruction at the hands of demonic hordes from the Abyss, or Oblivion, or whatever club it is those guys usually hang out in. And that's why I'm here fighting forest animals.'".
Instead of giving text for c_prison_4: say "[bold type]You haven't lost your wits, then, or at least not all of them. That's good. I didn't know in what mental shape you would be now, after all those years in the dungeon. Which reminds me--how did you manage to escape?[roman type][line break]".
Instead of finding responses to c_prison_4: forbid exiting on zero; link to c_prison_5.

Instead of giving link to c_prison_5: say "'Escape? Now [italic type]that's[roman type] a story. I had been locked in the same dark cell for twelve years. The guards were well-armed and they were never careless. The door, two inches of steel. Ever beat you knuckles against steel? For hours? Just to kill the time?'".
Instead of giving text for c_prison_5: say "[bold type]Can't say that I did. So you finally beat down the door with your bare hands and then killed the guards with a dagger made of your own thigh bone?[roman type][line break]".
Instead of finding responses to c_prison_5: forbid exiting on zero; link to c_prison_6.

Instead of giving link to c_prison_6: say "'Sort of. Let me tell you about it.'"
Instead of giving text for c_prison_6: try looking.



Chapter 3.0.1.1 - The cell


[Transition to stage 2]
[Maybe getting into and out of your bed is also described?]


Section 3.0.1.1.1 - Stuff in the Cell

The Prison Cell is a room. "[if the filthy straw is in the prison cell and the prison_next_boolean is false]'I was imprisoned in the worst dungeon cell you can imagine. The only entertainment I had was banging my fist against the door and my head against the walls; and since I'd been doing that for more than [italic type]twelve years[roman type], it had gotten a bit old. The only companions in my misery were some filthy straw and a jug.'[end if][if the soft bed is in the prison cell and the prison_next_boolean is false]'Anyway, I was in a relatively spacious and clean cell, but it was still down in the deepest dungeon and--believe me--there [italic type]was[roman type] quite a bit of banging head against the door. The only companions in my misery were a jug of white wine, a bed and a copy of [italic type]Orlando Furioso[roman type].'[end if][if the prison_next_boolean is true]Objectively, your dungeon cell remains the same: small, oppressive, with a single exit to the [bold type]north[roman type]. But now there is the chance of [bold type]escape[roman type], and that makes all the subjective difference in the world. Let's go![end if]" 

A person called the prisoner is here. The damage die of the prisoner is 2. The blood of the prisoner is 20. Instead of examining the prisoner: say "[if the prison_next_boolean is false]'I really looked like shit back there in that hellhole. Gaunt, clothed in filthy rags, Your standard prisoner stuff.'[otherwise]You still look like shit, but all who see the rage in your eyes will cower in fear.[end if]".

The prison walls are here. They are scenery. Instead of examining the prison walls: say "[if the prison_next_boolean is false]'I had contemplated scratching away the three feet thick walls with my fingernails. Contemplated? I'd [italic type]tried[roman type] it.'[otherwise]The walls are really very thick and even your smash attack won't do much damage to them.[end if]". Instead of attacking the prison walls: say "[if the prison_next_boolean is false]'You know what I did then? Just to entertain myself? I banged my head against the walls! THUD!'[otherwise]The door, yes. The guards, yes. The walls... no.[end if]"

The thick iron door is a closed locked door. Instead of examining the thick iron door: say "[if the prison_next_boolean is false]'I want you to understand that this door was hard. Real hard. Hit it with your full weight ten thousand times and it still doesn't give hard.'[end if][if the prison_next_boolean is true and the iron_door_smashed_boolean is true]Shredded steel sticks out in razor sharp spikes.[end if][if the prison_next_boolean is true and the iron_door_smashed_boolean is false]This thing is your enemy.[end if]". Instead of attacking the thick iron door: say "[if the prison_next_boolean is false]'You know what I did then? I banged my fists against the iron door until they started bleeding!'[otherwise]The magic word is 'smash'.[end if]"


Some filthy straw is here. It is a supporter. Instead of examining the filthy straw: say "[if the prison_next_boolean is false]'Now the straw that I had to lie down in, it was [italic type]really[roman type] filthy. It was rotting, it was full of excrement (not even all of it mine), there were lice... you name it, it was there. But I still slept on it. You know why? Because it was softer than the stones!'[otherwise]You have definitely seen enough of that.[end if]". Understand "excrement" and "lice" as the filthy straw.

Instead of attacking or smashing or opening or banging when the player is enclosed by the filthy straw: say "You'd better get up first.".

The soft bed is a container and enterable. The description of the soft bed is "[if the prison_next_boolean is false]'Okay, so that bed wasn't bad. It was soft, comfortable, and they even send in some nice lady to clean it up now and then.'[otherwise]How you will miss the many hours spent in this luxurious bed... NOT![end if]"

Instead of attacking or smashing or opening or banging when the player is enclosed by the soft bed: say "You'd better get up first.".

Instead of entering the filthy straw: say "[if the prison_next_boolean is false]'So I lay down on the straw.'[otherwise]You get down on the straw.[end if]"; move the player to the filthy straw.
Instead of getting off the filthy straw: say "[if the prison_next_boolean is false]'Then I got up again.'[otherwise]You get up again.[end if]"; move the player to the prison cell.
Instead of entering the soft bed: say "[if the prison_next_boolean is false]'So I lay down in bed.'[otherwise]You lie down in bed.[end if]"; move the player to the soft bed.
Instead of getting off the soft bed: say "[if the prison_next_boolean is false]'Then I got up again.'[otherwise]You get up again.[end if]"; move the player to the prison cell.

Instead of sleeping in the prison cell:
	if the prison_next_boolean is true, say "You want to waste your time [italic type]now[roman type]? Come on!" instead;
	if the soft bed is in the prison cell begin;
		if the prisoner is not in the soft bed, say "'Of course, I wasn't quite mad enough to go to sleep [italic type]before[roman type] getting into that warm soft bed.'";
		if the prisoner is in the soft bed begin;
			say "'With nothing else to do, I just went to sleep.'";
			run a conversation from c_prison_next_1;
		end if;
	otherwise;
		if the prisoner is not on the filthy straw, say "'Of course, I wasn't quite mad enough to go to sleep without getting on the filthy straw first. I mean, it [italic type]was[roman type] soft.'";
		if the prisoner is on the filthy straw begin;
			say "'With nothing else to do, I just went to sleep.'";
			run a conversation from c_prison_next_1;
		end if;
	end if.

Orlando Furioso is a thing. "The hefty Italian classic, [italic type]Orlando Furioso[roman type], is lying here." Instead of examining Orlando Furioso: say "[if the prison_next_boolean is false]'Giving me that book must have been someone's idea of a sick joke, because I didn't read Italian. Still don't.'[end if][if the prison_next_boolean is true and the Orlando destroyed boolean is false]Since you don't read Italian, the contents remain a mystery to you.[end if][if the prison_next_boolean is true and the Orlando destroyed boolean is true]It's even harder to read than before, but at least it saved your life.[end if]". The inventory listing of Orlando Furioso is "Ludovico Ariosto's [italic type]Orlando Furioso[roman type]". Understand "book" as Orlando Furioso. The printed name of Orlando Furioso is "[italic type]Orlando Furioso[roman type]". Understand "Ludovico", "Ariosto" and "Ariosto's" as Orlando Furioso.

The Orlando destroyed boolean is a truth state that varies. The Orlando destroyed boolean is usually false. 


The brown jug is here. It is a container. Instead of examining the brown jug for the first time, run a conversation from c_prison_jug_1. Instead of inserting something into the brown jug: say "Maybe not.".

The stale water is in the brown jug. The indefinite article is "some". Instead of taking the stale water: say "Let's go over this slowly. Water is a [italic type]liquid[roman type]. You cannot pick up a liquid.". Instead of drinking the stale water: say "[if the prison_next_boolean is false]'So I drank all of the disgusting water.'[otherwise]You drink all of the disgusting water.[end if]"; remove the stale water from play. Instead of tasting the stale water: try examining the stale water. Instead of examining the stale water: say "[if the prison_next_boolean is false]'I don't know how they made the water taste so bad, but it was positively [italic type]foul[roman type]. On second thoughts, I [italic type]do[roman type] know how they made the water taste so bad.'[otherwise]The same really bad water you've always drunk.[end if]".

The good white wine is a thing. The indefinite article is "some". Instead of taking the good white wine: say "Let's go over this slowly. Wine is a [italic type]liquid[roman type]. You cannot pick up a liquid.". Instead of drinking the good white wine: say "[if the prison_next_boolean is false]'So I quickly quaffed the entire jug of wine. It all became a bit more bearable then.'[otherwise]You quickly quaff the entire jug of wine.[end if]"; remove the good white wine from play. Instead of examining the good white wine: say "[if the prison_next_boolean is false]'This time, it was a Pinot Blanc. Maybe a little too sweet, but I couldn't really complain.'[otherwise]A fine Pinot Blanc. Maybe a little too sweet.[end if]". Instead of tasting the good white wine: try examining the good white wine.

c_prison_jug_1, c_prison_jug_2, c_prison_jug_3, c_prison_jug_4, c_prison_jug_5 are chat nodes.

Instead of giving text for c_prison_jug_1: say "'Apart from banging my head against the walls, my main entertainment was picking up the jug and taking a big gulp of the...".
Instead of finding responses to c_prison_jug_1: forbid exiting on zero; link to c_prison_jug_2; link to c_prison_jug_3.

Instead of giving link to c_prison_jug_2: say "...stale water that was the only drink those sons of bitches would bring me.'".
Instead of giving text for c_prison_jug_2: say "[bold type]You must have been dying for a beer, down there.[paragraph break][roman type]'You can bet I was.'".
Instead of finding responses to c_prison_jug_2: stop.

Instead of giving link to c_prison_jug_3: say "...well, it wasn't stale water, but a rather good white wine they served me in unlimited quantities. I still had friends in the palace upstairs, though God knows who they were.'".
Instead of giving text for c_prison_jug_3: say "[bold type]And these friends couldn't get you out of that dank cell?[line break][roman type]".
Instead of finding responses to c_prison_jug_3: remove the stale water from play; move the good white wine to the brown jug; forbid exiting on zero; link to c_prison_jug_4; link to c_prison_jug_5.

Instead of giving link to c_prison_jug_4: say "'No. It's one thing to get me some extra privileges like wine instead of water, but it's something else entirely to go against the direct commands of the King. I still had friends, but nobody who'd risk his life for me. The only two who would have done that were in no position to help me.'".
Instead of giving text for c_prison_jug_4: say "[bold type]True.[line break][roman type]".
Instead of finding responses to c_prison_jug_4: stop.

Instead of giving link to c_prison_jug_5: say "'Not really, but I [italic type]may[roman type] have overemphasised the darkness of the cell. And maybe there wasn't any filthy straw [italic type]as such[roman type]. But it sure was no picnic down there!'".
Instead of giving text for c_prison_jug_5: say "[bold type]Details, I am convinced. Please continue.[line break][roman type]".
Instead of finding responses to c_prison_jug_5: remove the filthy straw from play; move the soft bed to the prison cell; move Orlando Furioso to the prison cell; try looking.


Section  3.0.1.1.2 - Banging Action

Banging is an action applying to two things. Understand "bang [thing] against [thing]" as banging.

The head is in the prison cell. Instead of examining the head, say "[if the prison_next_boolean is false]'I looked like an animal: unshaven, dirty, with a mad glint in my eyes.'[otherwise]Unshaven, dirty, but purpose shines from your eyes.[end if]". It is scenery. The fists are in the prison cell. Instead of examining the fists, say "[if the prison_next_boolean is false]'They were bloody and almost always clenched.'[otherwise]Bloody, but no longer clenched. You flex your muscles. You are ready to fight![end if]". They are scenery. Understand "fist" and "hands" and "hand" as the fists.

Check banging:
	if the player is not in the prison cell, say "You don't need to do that here." instead;
	if the noun is not the head and the noun is not the fists, say "That's not something you used to bang." instead;
	if the second noun is not the prison walls and the second noun is not the thick iron door, say "You didn't bang your [noun] against [the second noun], back then in the prison cell." instead.

Carry out banging:
	say "'You know what I did then? Just to entertain myself? I banged my [noun] against [the second noun]! BANG!'".


Section  3.0.1.1.3 - The Next Stage

The prison_next_boolean is a truth state that varies. The prison_next_boolean is usually false.

Every turn when the player is in the prison cell:
	if the player has been in the prison cell for exactly 15 turns and the prison_next_boolean is false, run a conversation from c_prison_next_2.


c_prison_next_1, c_prison_next_2, c_prison_next_3, c_prison_next_4, c_prison_next_5, c_prison_next_6, c_prison_next_7, c_prison_next_8, c_prison_next_9 are chat nodes.

Instead of giving text for c_prison_next_1: now the prison_next_boolean is true; say "[bold type]So you went to sleep. How interesting. How did you find out that when I asked you to tell me about your escape, what I [italic type]really[bold type] wanted to hear was how you went to sleep? I'm just a sucker for that kind of story; always fills me with excitement and glee.[roman type][paragraph break]".
Instead of finding responses to c_prison_next_1: forbid exiting on zero; link to c_prison_next_3; link to c_prison_next_4.

Instead of giving text for c_prison_next_2: now the prison_next_boolean is true; say "[bold type]Fascinating. How much fun you must have had, and how incredibly entertaining it is to hear you recount it in so much vivid detail. Compared to this kind of stuff, the story of your escape must be [italic type]boring[bold type].[roman type][paragraph break]".
Instead of finding responses to c_prison_next_2: forbid exiting on zero; link to c_prison_next_3; link to c_prison_next_4.

Instead of giving link to c_prison_next_3: say "'Yeah, though I'm sure nothing entertains you as much as your own sarcasm. Anyway, [italic type]as I was just about to say when you interrupted me[roman type], at that moment Groth started to talk to me.'";
Instead of giving text for c_prison_next_3: say "[bold type]No less than Groth, the mother-loving God of War. I'm not surprised he took a special interest in you. So what did he say?[roman type][paragraph break]".
Instead of finding responses to c_prison_next_3: forbid exiting on zero; link to c_prison_next_5.

Instead of giving link to c_prison_next_4: say "'Yeah, though I'm sure nothing entertains you as much as your own sarcasm. Anyway, [italic type]as I was just about to say when you interrupted me[roman type], at that moment the guards entered my cell.'";
Instead of giving text for c_prison_next_4: say "[bold type]How exciting! They'd only done that about a hundred thousand times before.[roman type][paragraph break]".
Instead of finding responses to c_prison_next_4: forbid exiting on zero; link to c_prison_next_6.

Instead of giving link to c_prison_next_5: say "'He spoke to me in that, shall we say, efficient way of his: [italic type]Fighter in cage? No good. You escape! Groth teach you how.[roman type]'[paragraph break]";
Instead of giving text for c_prison_next_5: say "[bold type]So what kind of infernal knowledge did he give you?[roman type][paragraph break]".
Instead of finding responses to c_prison_next_5: forbid exiting on zero; link to c_prison_next_7.

Instead of giving link to c_prison_next_6: say "'Right, but [italic type]this[roman type] time I suddenly heard the voice of Groth in my mind telling me how I could kill them. He said: [italic type]You no weapon? They swords? No good! Groth show you Smashing Blow.[roman type]'[paragraph break]";
Instead of giving text for c_prison_next_6: say "[bold type]He taught you the Smashing Blow skill? That explains a lot.[roman type][paragraph break]".
Instead of finding responses to c_prison_next_6: forbid exiting on zero; link to c_prison_next_8.

Instead of giving link to c_prison_next_7: say "'He told me how to focus all my anger and rage into a blow so incredibly violent that it could even smash through solid steel. Not HIT!, his booming voice said in my mind, but SMASH!'";
Instead of giving text for c_prison_next_7: say "[bold type]And so you SMASHed the door?[roman type][paragraph break]".
Instead of finding responses to c_prison_next_7:
	choose row with a Skill of Smashing Blow in the Table of Player Skills;
	now the have entry is 1;
	now the permanent zeal of the prisoner is 6;
	now the zeal of the prisoner is 12;
	forbid exiting on zero; link to c_prison_next_9.

Instead of giving link to c_prison_next_8: say "'Yes. He told me how to focus all my anger and rage into a blow so incredibly violent that it could even smash through solid steel. Not HIT!, his booming voice said in my mind, but SMASH!";
Instead of giving text for c_prison_next_8: say "[bold type]And so you SMASHed the guards?[roman type][paragraph break]".
Instead of finding responses to c_prison_next_8:
	move the old guard to the prison cell;
	move the fat guard to the prison cell;
	now the thick iron door is open;
	now the thick iron door is unlocked;
	now the thick iron door is scenery;
	choose row with a Skill of Smashing Blow in the Table of Player Skills;
	now the have entry is 1;
	now the permanent zeal of the prisoner is 6;
	now the zeal of the prisoner is 12;
	forbid exiting on zero; link to c_prison_next_9.

Instead of giving link to c_prison_next_9: say "'I did. But if you want me to continue, you'd better stop interrupting me.'";
Instead of giving text for c_prison_next_9: say "[bold type]Sure, carry on. How could I possibly want to interfere with a master storyteller like you?[roman type][paragraph break]".
Instead of finding responses to c_prison_next_9: try looking; if the old guard is in the prison cell, say "The door swings open and the guards enter your cell for their hourly inspection.".


The iron_door_smashed_boolean is a truth state that varies. The  iron_door_smashed_boolean is usually false.

Instead of smashing the thick iron door when the thick iron door is unlocked:
	say "It is unlocked. You can just, like, OPEN it.".

Instead of smashing the thick iron door when the thick iron door is locked:
	if the player is not in the prison cell, say "You should get up first." instead; [in, not enclosed by!]
	choose row with a Skill of Smashing Blow in the Table of Player Skills;
	if the have entry is 0, say "You try--fruitlessly, since you do not possess that skill." instead;
	if the zeal of the actor is less than the zealcost entry, say "You have no zeal left!" instead.
	decrease the zeal of the actor by the zealcost entry;
	say "You focus all the rage and hate that burns deep within you into a single violent blow. With a SMASH that resounds throughout the dungeon, the steel rips apart and the door flies open! Freedom lies to the [bold type]north[roman type].";
	now the thick iron door is open; now the iron_door_smashed_boolean is true; now the thick iron door is unlocked; now the old prison guard is hostile; now the fat prison guard is hostile; now the thick iron door is scenery.


Before going north in the prison cell:
	if an alive monster is in the prison cell, say "As you attempt to walk away, [the random alive monster in the prison cell] pushes you back into the cell." instead.



Chapter 3.0.1.2 - The Corridor Outside your Cell

The Corridor Outside your Cell is a room. "Who cares about the corridor? As far as you are concerned it leads [italic type]from[roman type] your imprisonment [italic type]to[roman type] your freedom, that is, from the [bold type]south[roman type] to the [bold type]east[roman type]."

The thick iron door is north of the Prison Cell and south of the Corridor Outside your Cell.

A guarder called the old prison guard is here. The old prison guard is indifferent.
The blood of the old prison guard is 7. The melee of the old prison guard is 0. The damage die of the old prison guard is 5.

The old prison guard carries the guard's sword. Instead of examining the guard's sword, say "Old and a bit dented, but sharp enough to effectively kill and maim.". Instead of dropping the guard's sword: say "Nay--you would be naked without it.". Instead putting the guard's sword on something: say "Nay--you would be naked without it.". Instead of inserting the guard's sword into something: say "Nay--you would be naked without it.".

A guarder called the fat prison guard is here. The fat prison guard is indifferent.
The damage die of the fat prison guard is 4.

The player flavour texts of the fat prison guard is the Table of Unarmed Dungeon Player Flavour Texts. The player flavour texts of the old prison guard is the Table of Unarmed Dungeon Player Flavour Texts.

Table 3.0.1.2.1 - Unarmed Dungeon Player Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text				
"You grab the head of [the global defender] and pull it towards you. With a loud SNAP his neck breaks, and he slumps lifelessly to the ground."		"You give [the global defender] a forceful punch in his stomach. He almost doubles over under the blow."	"You aim for the head of [the global defender], but he manages to duck away in time."		"Your punches are absorbed by [the global defender]'s armour."
"With bone-cracking force, you punch through [the global defender]'s chest and pull out his beating heart. 'Eat THAT, sucker!', you scream in ecstasy."		"After a couple of dodges, you manage to land a kick on [the global defender]'s knee. You think you heard the sound of a meniscus breaking."	"You throw yourself at [the global defender], but he steps aside and you crash into the wall."		"You kick [the global defender] in the balls, but unfortunately he is wearing a metal cod piece."
"A lightning-quick movement of your left arm, and the windpipe of [the global defender] is crushed. He clutches at his throat, choking, until you finish him off by bashing his head against the hard stones of the wall. Brains drip down."		"'The likes of you can't stop me!', you growl as you plant your knee in [the global defender]'s groin."	"Years in the dungeon apparently diminished your skills, as your feared high kick goes wide."		"Your blows seem to have no effect on [the global defender]!"
"Two fingers smashed into [the global defender]'s eyes blind him, after which it just takes a hard blow to the neck to finish him off."		"You grab [the global defender] by the arms, and throw him against the wall. Blood comes from his mouth, but he is still alive!"	"Enraged, you let your fists fly wherever they wish--but [the global defender] deftly moves aside."		"Damn the armour! You make no impact on the steel."


Every turn when the fat prison guard is in the location:
	if the player is in the Corridor Outside your Cell and the player was not in the Corridor Outside your Cell, say "The guards look at you in amazement, but have enough presence of mind to immediately draw their swords!";
	if the fat prison guard is killed and the fat prison guard was not killed and the old prison guard is killed begin;
		say "You grab the sword of one of the guards. It feels great to swing real steel again!";
		move the guard's sword to the prisoner;
		now the damage die of the prisoner is 6;
	end if; 
	if the fat prison guard is killed and the old prison guard was not killed and the old prison guard is killed begin;
		say "You grab the sword of one of the guards. It feels great to swing real steel again!";
		move the guard's sword to the prisoner;
		now the damage die of the prisoner is 6;
	end if.

Before going east in the Corridor Outside Your Cell for the first time: say "You scream in joy and anger: 'I am FREE! Come on suckers, [apostrophe]cause I am ready to FIGHT!'".




Chapter 3.0.1.3 - The Trapped Staircase


Section 3.0.1.3.1 - The Stuff

The Trapped Staircase is east of the Corridor Outside Your Cell. "[if the dungeon blade boolean is true]What you see [italic type]appears to be[roman type] nothing more than a spiral staircase leading from the dungeons [bold type]up[roman type] to the surface. In fact, however, it is also a deadly trap--if you don't look out, a razor sharp blade will fall down and split your head into two parts, both of which will be leaking brains at an alarming and presumably fatal rate[otherwise]A spiral staircase leads from the dungeons [bold type]up[roman type] to the surface. Halfway up, the huge blade you triggered is now resting harmlessly on the steps. It should be safe to ascend now[end if]."

The dungeon dial is a number that varies. The dungeon dial is 24.

The dungeon trap disarmed number is a number that varies. The dungeon trap disarmed number is usually 81.

A strange contraption is here. Instead of examining the strange contraption: say "This contraption allows the guards to bypass the trap. If large dial is to the right number between 1 and 100, the huge blade won't come crashing down. Currently, the dial is at [dungeon dial].". Understand "dial" and "machine" as the contraption.


Section 3.0.1.3.2 - The Spinning

Spinning it to is an action applying to one thing and one number. Understand "spin [something] to [a number]" as spinning it to. Understand "turn [something] to [a number]" as spinning it to. Understand "dial [something] to [a number]" as spinning it to. Understand "set [something] to [a number]" as spinning it to.

Check spinning it to:
	if the noun is not the strange contraption, say "You cannot spin that to a value." instead;
	if the number understood is greater than 100, say "It only goes to 100." instead;
	if the number understood is less than 1, say "It only goes to 1." instead.

Carry out spinning it to:
	say "You turn [the noun] to [the number understood].";
	if the noun is the strange contraption, now the dungeon dial is the number understood.

After spinning the strange contraption to for the first time:
	if the dungeon blade boolean is true, run a conversation from c_prison_trap_1.


Section 3.0.1.3.3 - Disarming the trap

c_prison_trap_1, c_prison_trap_2, c_prison_trap_3, c_prison_trap_4, c_prison_trap_5, c_prison_trap_6, c_prison_trap_7, c_prison_trap_8, c_prison_trap_9 are chat nodes.

Instead of giving text for c_prison_trap_1: say "[bold type]Did you remember the right number from when you were the captain of the guard?[roman type][paragraph break]".
Instead of finding responses to c_prison_trap_1: forbid exiting on zero; link to c_prison_trap_2; link to c_prison_trap_3.

Instead of giving link to c_prison_trap_2: say "'Of course I did. It was still [dungeon dial], which goes to show what an [italic type]idiot[roman type] they'd appointed as my successor.'".
Instead of giving text for c_prison_trap_2: say "[bold type]It's not really a position that calls for brains, is it?[roman type][paragraph break]".
Instead of finding responses to c_prison_trap_2: now the dungeon trap disarmed number is the dungeon dial.

Instead of giving link to c_prison_trap_3: say "'I could have sworn it was [dungeon dial], but they must have changed the mechanism while I was locked away.'";
Instead of giving text for c_prison_trap_3: say "[bold type]A painful discovery, I'm sure. Still, you didn't end up with your brains all over the staircase; tell me more.[roman type][paragraph break]".
Instead of finding responses to c_prison_trap_3: if the dungeon dial is greater than 50, now the dungeon trap disarmed number is a random number between 1 and 50; if the dungeon dial is less than 51, now the dungeon trap disarmed number is a random number between 51 and 100.

Instead of giving text for c_prison_trap_4: say "You hear a loud CLICK, and then the SWOOSH of a huge blade falling downwards. So you...".
Instead of finding responses to c_prison_trap_4: forbid exiting on zero; link to c_prison_trap_5; if the player carries Orlando Furioso, link to c_prison_trap_6; link to c_prison_trap_7; link to c_prison_trap_8.

Instead of giving link to c_prison_trap_5: say "...desperately throw yourself downstairs.".
Instead of giving text for c_prison_trap_5: say "You manage to jump out of the way of the falling blade, but receive 1 damage when you hit the stone floor below."; deal 1 damage to the player.
Instead of finding responses to c_prison_trap_5: now the dungeon blade boolean is false; try looking; move the huge blade to the Trapped Staircase.

Instead of giving link to c_prison_trap_6: say "...hold [italic type]Orlando Furioso[roman type] above your head.".
Instead of giving text for c_prison_trap_6: say "The huge blade buries itself in the thick book, nearly but not quite slicing it in half. You bless Ludovico Ariosto for the epic scope of his plot.".
Instead of finding responses to c_prison_trap_6: now the dungeon blade boolean is false; now the Orlando destroyed boolean is true; try looking; move the huge blade to the Trapped Staircase.

Instead of giving link to c_prison_trap_7: say "...stand still and look upwards with a relaxed smile.".
Instead of giving text for c_prison_trap_7: say "The blade SWOOSHes down and hit the steps with a loud CLANG, some two meters ahead of you. You calibrated the trap yourself so that it would hit escapees happily [italic type]running[roman type] up the stairs to their freedom. That's psychology for you.".
Instead of finding responses to c_prison_trap_7: now the dungeon blade boolean is false; try looking; move the huge blade to the Trapped Staircase.

Instead of giving link to c_prison_trap_8: say "...continue to force the fat guard upwards with the point of your sword.".
Instead of giving text for c_prison_trap_8: say "[bold type]WHAT? But you just told me you killed him![roman type][paragraph break]".
Instead of finding responses to c_prison_trap_8: forbid exiting on zero; link to c_prison_trap_9.

Instead of giving link to c_prison_trap_9: say "'So? I lied. I was going for the shock effect, and judging from your reaction I have succeeded.'".
Instead of giving text for c_prison_trap_9: say "The fat guard is screaming for mercy as you force him to walk the stairs in front of you, the point of your sword pricking between his shoulder blades. As soon as he hears the CLICK, he tries to make a run for it--but it is too late. The huge blade buries itself in his skulls with a sickening THUD, killing him instantly. His corpse topples over and falls ungracefully down the stairs.".
Instead of finding responses to c_prison_trap_9: now the dungeon blade boolean is false; move the fat guard to the Trapped Staircase; move the huge blade to the Trapped Staircase; try looking.


Section 3.0.1.3.4 - The trap

The dungeon blade boolean is a truth state that varies. The dungeon blade boolean is usually true.

The huge blade is a thing. It is scenery. Instead of examining the huge blade: say "This blade is to a razor what a trebuchet is to a slingshot.". Instead of taking the blade: say "Though being cool has always been about wielding BIG weapons, there are some limits. Being able to lift the weapon without a rope-and-pulley system is one of them.".

Instead of going up in the Trapped Staircase when the dungeon blade boolean is true:
	if the dungeon dial is the dungeon trap disarmed number begin;
		say "You carefully ascend the staircase. Nothing comes SWOOSHing through the air to devitalise you.";
		move the player to the Guard Room;
	end if;
	if the dungeon dial is not the dungeon trap disarmed number begin;
		run a conversation from c_prison_trap_4;
	end if.




Chapter 3.0.1.4 - The Guard Room

The Guard Room is up from the trapped staircase. "Everything is the same: a table, a dog on a chain[if the guard dog is alive]. Well--maybe not [italic type]everything[roman type] has remained the same. The dog is no longer Susy (remember old Susy?), and it doesn't appear to like you[otherwise]. Although you didn't use to have a [italic type]dead[roman type] dog[end if]. The big door to the [bold type]north[roman type] leads outside, while a short corridor to the [bold type]west[roman type] will bring you to the Captain's Office."

A doberman called the guard dog is here. "The doberman leaps towards you! Its chain is, unfortunately, quite long enough for it to reach you." The guard dog is slow. Understand "doberman" as the guard dog.

Every turn when the player is enclosed by the Guard Room: if the guard dog is killed, now the guard dog is handled.

The guards' table is in the Guard Room. It is a scenery enterable supporter. Instead of examining the guards' table: say "What can you say? It serves its function.".

Check entering the guards' table:
	if the hold location of the guard dog is not 0, say "You can't climb the table while the doberman is hanging on to your leg!" instead. 

After entering the guards' table:
	say "[if the guard dog is alive]You get on the table, where you are safe from the fangs of the doberman[otherwise]Although it serves little purpose now that the guard dog is dead, you climb the table[end if].";
	now the player is separated; now the player is separation-privileged.

After getting off the guards' table:
	now the player is not separated; now the player is not separation-privileged;
	continue the action.
	

Remembering old susy is an action applying to nothing. Remembering old Susy is acting fast. Understand "remember old susy" and "remember susy" as remembering old susy.

Carry out remembering old susy:
	say "She was a magnificent big doberman; quite the fighter in her days. You kept her around long after she'd grown too old to be an effective guard dog. Call it weakness, call it sentimentality, but you just loved that bitch.".



Chapter 3.0.1.5 - The Captain's Office

The Captain's Office is west of the Guard Room. "This used to be [bold type]your[roman type] office. [if Alex is alive and Alex is indifferent and the Alex number is not 3]Now it appears to be your old buddy Alex's office, as he is sitting in [bold type]your[roman type] chair with his feet up on [bold type]your[roman type] desk. Before he can so much as blink, [bold type]your[roman type] sword is at his throat[otherwise if Alex is alive and Alex is indifferent and the Alex number is 3]Now it is that twerp Alex's office. He slumps in your chair, unconscious[otherwise if Alex is alive and hostile]Now it appears to be that twerp Alex's office. Time to kill him[otherwise if Alex is killed]It also used to be Alex's office. Nothing to do here now, so let's get going; the exit is [bold type]east[roman type][end if]."



[Special narrative numbers.]

The Alex number is a number that varies. The Alex number is 0.

[Legend: 0 = unresolved; 1 = dead without a fair fight; 2 = dead after fair fight; 3 = unconscious.]

The Alex forgiveness number is a number that varies. The Alex forgiveness number is 0.

[Legend: 0 = unresolved; 1 = you didn't listen; 2 = you begged for forgiveness and didn't hear him; 3 = you didn't accept forgiveness; 4 = you cried after he forgave you.]

Instead of smelling a room in The Captain's Office:
	if the Alex number is 1, say "Fresh blood.";
	if the Alex number is 2, say "Blood and piss.";
	if the Alex number is 0 or the Alex number is 3, say "Sweat.".




[Alex]

Alex is an indifferent monster. Alex is here. "[if Alex is alive and Alex is indifferent and the Alex number is not 3][one of]Alex casts furtive glances at the sword at his belt[or]Sweat is standing in large beads on Alex's forehead[or]'Don't kill me, please!', Alex begs[at random][otherwise if Alex is alive and Alex is indifferent and the Alex number is 3]Judging from how hard you hit him, Alex is not going to wake up anytime soon[otherwise if Alex is alive and hostile]Alex is looking for an opening in your defence[otherwise if Alex is killed]Alex lies on the ground in a big pool of his own blood[end if]."

Understand "pool" and "blood" as Alex.


[Stats]

Alex is boss.

The blood of Alex is 12.
The zeal of Alex is 0.
The melee of Alex is 1.
The mind of Alex is 2.
The defense of Alex is 3. 

The level of Alex is 12.

The damage die of Alex is 5


[Special actions concerning Alex]

Instead of examining Alex:
	if the Alex number is 0, say "Alex. So [italic type]he[roman type] was your gaoler.[paragraph break]You used to be friends, you and Alex. Chums. Not like you and Michael, not friends like that, but still, friends, good friends. How often did you play together, as kids? How often have you protected him from Michael's ire, when Alex had told some angry cook whose pies you had stolen about the mischief the three of you had been up to? Alex was always the most fearful of you three, and always the one who got caught. Heh. Those were the days.[paragraph break]And later, when you grew up, did your relation cool? No, it did not. You remained the best of friends. Who was the one that convinced Marianne's parents that Alex would be a good party for their daughter? It was you. Who got him that big promotion in the Holy Legion? You. And who was the godfather of his first child? Well? You again. Yes. You always did everything for him.[paragraph break]And he has betrayed your trust.[paragraph break]He has kept you locked in a cell while he could have released you with a single command. Boy, does that hurt. It hurts like hell. And let's face it: Alex is going to [bold type]pay[roman type] for that. Oh yes, he's gonna pay...[paragraph break]'You're gonna pay for this, Alex!'";
	if the Alex number is 1 or the Alex number is 2 begin;
		if the Alex forgiveness number is 0 or the Alex forgiveness number is 1, say "He's dead. Better get out of here before somebody misses him.";
		if the Alex forgiveness number is 2 or the Alex forgiveness number is 3, say "Alex is dead. His face is locked into an unreadable expression.";
		if the Alex forgiveness number is 4, say "Your friend Alex lies dead on the ground. A faint smile lingers on his white face.";
	end if;
	if the Alex number is 3, say "Alex lies slumped in his--your--chair, like a big sack of wheat. Did you ever see such a lame excuse for a human being?".

Before doing something in The Captain's Office:
	if the Alex number is 3 and the noun is Alex, say "Alex is unconscious. Let's just leave him be." instead;
	if the Alex number is 3 and the second noun is Alex, say "Alex is unconscious. Let's just leave him be." instead.

Check retreating in The Captain's Office:
	if Alex is alive and Alex is hostile, say "You will be damned if you retreat from that ass. Anyway, he'd just follow you to the next room." instead;
	if Alex is alive and Alex is indifferent and the Alex number is not 3, say "He's in your power! You're not going to retreat." instead.

Check going in The Captain's Office:
	if Alex is alive and Alex is indifferent and the Alex number is not 3, say "He's in your power now! You shouldn't waste your chance." instead.

Instead of attacking or smashing Alex when Alex is indifferent:
	if the Alex is killed, say "You kick the lifeless body." instead;
	if the Alex number is 3, say "You spared his life." instead;
	run a conversation from c_Alex_1.

Check tasting Alex:
	if Alex is killed, say "How sweet is the taste of blood." instead.

Check drinking Alex:
	if Alex is killed, say "How sweet is the taste of blood." instead.


[Conversation table]

Alex is talkative. The standard topic of Alex is "dungeon".

The responses of Alex is the Table of Alex Responses.


Table of Alex Responses
topic					response				link				done		repeating		summary
"Michael"		"'What do you know about Michael? Is he still alive?'[paragraph break]'All we've heard are rumours. People used to claim he was raising an army in order to free you; others said that he sold his soul to the Devil and ruled a magical kingdom far to the south. But the truth is, nobody has heard from him in years. Please, believe me--we haven't killed him.'"		--		0	0	"that Michael hasn't been heard of in years. He's probably either dead or mad or (who knows) the demoniac ruler of a magical kingdom"
"Lord Death"		"'Has Lord Death appeared in your dreams as well as in mine?'[paragraph break]'No!' A slight pause. 'I mean, Lord Death, who's that supposed to be?'"		--		0	0	--
"Lord Death"		"'I see right through your feeble attempts at deception, little Alex. You have seen Lord Death, have you not? Tell me about it if you wish to keep that ugly head of yours attached to your unappealing neck.'[paragraph break]'Yes, but be silent! [italic type]Everybody[roman type] has seen Lord Death in his dreams, promising us violent war and eternal damnation... his voice... no, we cannot talk about him. The King has forbidden any mention of him!'"	--		0	0
"Lord Death"	"You laugh. 'Ha! [italic type]I[roman type] know who Lord Death is, and your fear is well justified! But, before you ask, there is no way I'm going to tell you.'"		--		1	0	"they have all seen Lord Death in their dreams. The knowledge fill you with glee--let these pathetic cowards feel some fear before they meet their doom"
"dungeon/him/himself/Alex/cell/captivity/prison"		--		c_Alex_1		0	0	"everything you wish to know about your captivity and his role in it."
"dungeon/him/himself/Alex/cell/captivity/prison"		--		c_Alex_100		4	1	"everything you wish to know about your captivity and his role in it."
"me"	--		c_Alex_me			0		1		--
"Wilfrid"		"'What has happened to Wilfrid, while I was locked up?' you query.[paragraph break]Alex looks at you aghast. 'What? I mean... you don't remember?'"		--	0		0		--
"Wilfrid"		"'Remember [italic type]what[roman type]?'[paragraph break]'That you, that...' Pearls of sweat form on Alex's brow while he works up the courage to whisper the message that he dreads giving you. 'That you killed him?'"	c_Alex_Wilfrid	1	0	"more than enough about Wilfrid."
"Susy/dog"	"'Susy. Did she die?'[paragraph break]'Yes, she did. Many years ago. I'm sorry--I remember you were fond of her.'"	--		0	0	"that Susy, the old dog you used to be so fond of, has been dead for many years."



[First conversation]

c_Alex_1, c_Alex_2, c_Alex_3, c_Alex_4, c_Alex_5, c_Alex_6, c_Alex_7, c_Alex_8, c_Alex_9, c_Alex_99, c_Alex_100 are chat nodes.

Instead of giving text for c_Alex_1: say "'Please, don't kill me,' Alex whimpers. 'I was only following orders.'".
Instead of finding responses to c_Alex_1: forbid exiting on zero; link to c_Alex_2; link to c_Alex_3.

Instead of giving link to c_Alex_2: say "'Don't try to escape your responsibility, Alex. For twelve years you have had the power to release me, and for twelve years you have decided to let me rot. I think it's time for payback.'".
Instead of giving text for c_Alex_2: say "'But what was I to do? [italic type]You[roman type] know what would have happened to me if I had let you go. It's not that I didn't [italic type]want[roman type] to, I just [italic type]couldn't[roman type][if the soft bed is in the prison cell]. I did all I could, man, with the bed and the wine and the food..[end if].'".
Instead of finding responses to c_Alex_2: forbid exiting on zero; link to c_Alex_99; link to c_Alex_4; link to c_Alex_5; link to c_Alex_6.

Instead of giving link to c_Alex_3: say "'Don't worry, Alex. We're old chums, aren't we? You think I want to kill you? Kill [italic type]you[roman type], kill my old pal Alex? Course not! Oh no, I might be satisfied with, I don't know, just cutting off your balls or something. Not that you ever had any, you stinking coward.'".
Instead of giving text for c_Alex_3: say "His hands move to his crotch involuntarily. 'Come on,' he says, 'be reasonable! What was I to do? [italic type]You[roman type] know what would have happened to me if I had let you go. It's not that I didn't [italic type]want[roman type] to, I just [italic type]couldn't[roman type][if the soft bed is in the prison cell]. I did all I could, man, with the bed and the wine and the food..[end if].'".
Instead of finding responses to c_Alex_3: forbid exiting on zero; link to c_Alex_99; link to c_Alex_4; link to c_Alex_5; link to c_Alex_6.

Instead of giving link to c_Alex_4: say "'Enough talk. You die. Now.'".
Instead of giving text for c_Alex_4: say "'No, please, I beg you!' Tears are streaming down Alex's face, and you smell piss. 'I have a wife! I have three children! Don't kill me, please!'".
Instead of finding responses to c_Alex_4: now the Alex number is 1; now the blood of Alex is 0; move the Captain's key to the Captain's Office; forbid exiting on zero; link to c_Alex_fatality_2; link to c_Alex_fatality_3; link to c_Alex_fatality_4.

Instead of giving link to c_Alex_5: say "'Enough talk. We will fight--like men, and to the death. Stand up and take you sword, Alex. Nobody will say I cut you down while you couldn't defend yourself.'".
Instead of giving text for c_Alex_5: say "'But...' Alex hesitates. You take two steps back, allowing him room to stand and draw his sword. Finally, he sighs. 'All right, we will fight. But I never wanted it to be like this.'".
Instead of finding responses to c_Alex_5: start fighting Alex.

Instead of giving link to c_Alex_6: say "'I won't kill you. Not because I love you; not because I forgive you; but strictly for old times[apostrophe] sake. We had some good times together, Alex, and I've not forgotten them. So give me the key to the courtyard, and do it now.'".
Instead of giving text for c_Alex_6: say "'Yes, yes, certainly!' Alex very slowly moves his hand to his belt. You watch it carefully. The hand moves past the sword hilt, and down to the key. It picks up the key. Then, with the same slow pace, it carries the key upwards and offers it to you. 'The key. Please, take it,' Alex whimpers.".
Instead of finding responses to c_Alex_6: forbid exiting on zero; link to c_Alex_7; link to c_Alex_8.

Instead of giving link to c_Alex_7: say "'Good. By the way, I was lying--I will kill you anyway.'".
Instead of giving text for c_Alex_7: say "'No, please, I beg you!' Tears are streaming down Alex's face, and you smell piss. 'I have a wife! I have three children! Don't kill me, please!'".
Instead of finding responses to c_Alex_7: now the Alex number is 1; now the blood of Alex is 0; move the Captain's key to the player; forbid exiting on zero; link to c_Alex_fatality_2; link to c_Alex_fatality_3; link to c_Alex_fatality_4.

Instead of giving link to c_Alex_8: say "'Thanks. Goodbye Alex; and don't think I will be so lenient next time.' (Knock him unconscious.)".
Instead of giving text for c_Alex_8: say "You hit Alex on the head with the flat of your blade. He slumps down, unconscious.".
Instead of finding responses to c_Alex_8: now the Alex number is 3; move the captain's key to the player.

Instead of giving link to c_Alex_99: say "'We'll return to this topic later. For now, I've got some other questions.'".
Instead of giving text for c_Alex_99: say "'Yeah, yeah, sure, ask away!', Alex stammers."
Instead of finding responses to c_Alex_99: choose a row with a link of c_Alex_100 in the Table of Alex Responses; change the done entry to 0.

Instead of giving text for c_Alex_100: say "What are you going to do with Alex?"
Instead of finding responses to c_Alex_100: allow exiting on zero; link to c_Alex_4; link to c_Alex_5; link to c_Alex_6.




[The starting node of Alex is c_Alex_1.]

[Choice of fatalities]

c_Alex_fatality_2, c_Alex_fatality_3, c_Alex_fatality_4 are chat nodes.

Instead of giving link to c_Alex_fatality_2: say "Push the sword through his throat, through his spine, out through the back of his neck. That should kill him quickly.".
Instead of giving text for c_Alex_fatality_2: say "Done. Before he knows what is happening, he is dead.".
Instead of finding responses to c_Alex_fatality_2: do nothing.

Instead of giving link to c_Alex_fatality_3: say "Raise the sword and, as Alex ducks away, bring it back down in a sweeping arc that splits him in half from the top of his head down to his waist. Let brains and blood and organs splatter all through the room!".
Instead of giving text for c_Alex_fatality_3: say "Done. He is deader than dead.".
Instead of finding responses to c_Alex_fatality_3: do nothing.

Instead of giving link to c_Alex_fatality_4: say "Cut open his guts and use the sword to pull out his internal organs. Watch him die an incredibly painful death over the next, oh, twenty or thirty minutes. And don't forget to cut out his tongue, since we don't want him begging for mercy or calling for help.".
Instead of giving text for c_Alex_fatality_4: say "Done. It takes thirty minutes, but its thirty minutes you enjoy. Just before he finally dies, Alex tries to say something to you--but you can't make out his words.".
Instead of finding responses to c_Alex_fatality_4: forbid exiting on zero; link to c_Alex_defeated_10; link to c_Alex_defeated_6.


[Alex defeated conversation]

c_Alex_defeated_1, c_Alex_defeated_2, c_Alex_defeated_3, c_Alex_defeated_4, c_Alex_defeated_5, c_Alex_defeated_6, c_Alex_defeated_7, c_Alex_defeated_8, c_Alex_defeated_9, c_Alex_defeated_10 is a chat node.

Instead of giving text for c_Alex_defeated_1: say "Several quick thrusts, a mighty blow, and Alex lies on the ground. His arteries are open in two places, and blood comes gushing out with every beat of his heart.".
Instead of finding responses to c_Alex_defeated_1: forbid exiting on zero; link to c_Alex_defeated_2; link to c_Alex_defeated_3; link to c_Alex_defeated_4.

Instead of giving link to c_Alex_defeated_2: say "'How disappointing, Alex. That was hardly a fight. If I had known you were such a loser, I would have killed you outright; a weakling like you doesn't deserve a fair fight! The weak only deserve to [italic type]die[roman type].'".
Instead of giving text for c_Alex_defeated_2: say "You notice that the gushes of blood come less frequently--he must be dying fast. It also seems as if Alex is trying to say something.".
instead of finding responses to c_Alex_defeated_2:  forbid exiting on zero; link to c_Alex_defeated_5; link to c_Alex_defeated_6.

Instead of giving link to c_Alex_defeated_3: say "'I win and I live; you lose and you die. Consider the debt paid, Alex. I hope the Gods will treat you well in Paradise.'".
Instead of giving text for c_Alex_defeated_3: say "You notice that the gushes of blood come less frequently--he must be dying fast. It also seems as if Alex is trying to say something.".
instead of finding responses to c_Alex_defeated_3:  forbid exiting on zero; link to c_Alex_defeated_5; link to c_Alex_defeated_6.

Instead of giving link to c_Alex_defeated_4: say "You look at the dying Alex in horror and confusion. 'Alex? Don't die! I mean, I didn't want to [italic type]kill[roman type] you... I don't know what came over me!'".
Instead of giving text for c_Alex_defeated_4: say "You notice that the gushes of blood come less frequently--he must be dying fast. It also seems as if Alex is trying to say something.".
instead of finding responses to c_Alex_defeated_4:  forbid exiting on zero; link to c_Alex_defeated_5; link to c_Alex_defeated_7.

Instead of giving link to c_Alex_defeated_5: say "Bend toward him, so you can hear what he is trying to tell you.".
Instead of giving text for c_Alex_defeated_5: say "You have to let his lips almost touch your ear before you can make out his soft whispers. 'Friend...', Alex says as his life is slipping away from him. 'I forgive you. I really do forgive you, my friend.'".
instead of finding responses to c_Alex_defeated_5: forbid exiting on zero; link to c_Alex_defeated_8; link to c_Alex_defeated_9.

Instead of giving link to c_Alex_defeated_6: say "Stand tall and watch him die.".
Instead of giving text for c_Alex_defeated_6: say "Alex desperately tries to speak up, but the only sound he makes is a gurgle. You just stand there, unsmiling, and look him in the eyes until he finally expires.".
instead of finding responses to c_Alex_defeated_6: now the Alex forgiveness number is 1.

Instead of giving link to c_Alex_defeated_7: say "Fall to your knees begging for forgiveness.".
Instead of giving text for c_Alex_defeated_7: say "'Forgive me, Alex, forgive me!', you cry over and over. When you finally calm down, you notice that Alex is dead.".
instead of finding responses to c_Alex_defeated_7: now the Alex forgiveness number is 2.

Instead of giving link to c_Alex_defeated_8: say "'Forgive me? You can do nothing to forgive me. I have DONE nothing that has to be forgiven! Do you hear that? Do you understand what I'm saying? I don't need your forgiveness!'".
Instead of giving text for c_Alex_defeated_8: say "But Alex hears and understands nothing, for he is dead.".
instead of finding responses to c_Alex_defeated_8: now the Alex forgiveness number is 3.

Instead of giving link to c_Alex_defeated_9: say "Close your eyes and cry.".
Instead of giving text for c_Alex_defeated_9: say "Bitter tears stream across your cheeks.".
instead of finding responses to c_Alex_defeated_9: now the Alex forgiveness number is 4.

Instead of giving link to c_Alex_defeated_10: say "Bend toward him, so you can hear what he is trying to tell you.".
Instead of giving text for c_Alex_defeated_10: say "All you hear are indistinct gurgles. It's hard to talk without a tongue, of course. So you rise again, and stand there, unsmiling, looking him in the eyes until he finally expires.".
instead of finding responses to c_Alex_defeated_10: now the Alex forgiveness number is 1.


[More conversation]

c_Alex_me is a chat node.


c_Alex_Wilfrid is a chat node.


[Fighting Alex rules]

To start fighting Alex:
	now the Alex number is 2;
	say "'Shut up and strike the first blow,' you tell him. 'Only death can cure the pain of your betrayal.'[paragraph break]";
	now Alex is hostile.

Every turn:
	if Alex is killed and Alex was not killed and Alex is hostile begin;
		run a conversation from c_Alex_defeated_1;
		if the player does not carry the Captain's key, move the Captain's key to the Captain's Office;
	end if.



[Other stuff]

Captain's key is a thing. "Alex has dropped the Captain's key on the floor." Instead of examining the Captain's key: say "You know this key well. It unlocks the door of the guardhouse.".

The Captain's chair is in the Captain's Office. It is scenery. It is an enterable supporter.

Instead of entering the Captain's chair:
	say "This is not the time to relax.".

Carry out examining the Captain's chair:
	say "How many hours did you spend sitting on your butt in that chair? Very few, if the truth be told. You always preferred action, and you were away from the castle more often than not. Maybe you weren't the best Captain of the Guard ever--but at least you killed the count of Otranto!" instead. 

The Captain's desk is in the Captain's Office. It is scenery. It is an enterable supporter. Understand "table" and "message" and "carving" as the Captain's desk.

Carry out examining the Captain's desk:
	say "A message has been carved in the top of the desk, still readable after all this time: 'Find me. Michael.'[paragraph break]You found him, of course, and demanded angrily why he had ruined your good desk. He raised his hands in mock innocence and exclaimed: 'I'm sorry, but I couldn't find a piece of paper!' So you punched him in the nose, and he punched you in the gut, and a couple of minutes later the two of you were sitting on the floor, exhausted and laughing.[paragraph break]You smile at the recollection." instead. 





Chapter 3.0.1.6 - The Castle's Courtyard 

The Castle's Courtyard is a room. "Walls enclose the vast area on all sides. The guardhouse lies on the [bold type]southern[roman type] side of the courtyard; the gates of the castle, wide open, beckon you [bold type]north[roman type]. Archers patrol the walls; [if the archers are indifferent]they have not yet seen you[otherwise]they have seen you and are determined to shoot you down[end if]. You are [if the Courtyard position is 0]just outside the guardhouse[otherwise if the Courtyard position is 1]near the guardhouse[otherwise if the Courtyard position is 2]almost halfway towards the gates[otherwise if the Courtyard position is 3]past the middle of the yard[otherwise if the Courtyard position is 4]nearing the gates[otherwise if the Courtyard position is 5]running through the gates[end if]."

The Courtyard position is a number that varies. The Courtyard Position is 0.



A door called the guardhouse's door is north of the Guard Room and south of the Castle's Courtyard. It is closed and locked and scenery. The matching key of the guardhouse's door is the Captain's key.


The archers are a monster. They are scenery. The archers are separated and separation-privileged. They are in the Castle's Courtyard. They are indifferent.

The melee of the archers is 2. The damage die of the archers is 7.

The monster flavour texts of the archers is the Table of Archer Monster Flavour Texts.

Table of Archer Monster Flavour Texts
Fatal Text					Hit Text			Miss Text					Absorbed Text				
"A well-aimed arrow hits you in the throat, immediately killing you."	"Arrows rain down all around you, some of them finding their mark."	"Arrows rains down all around you, but none hit you."	"Several arrows hit you, but they make no more than scratches."
"You are hit in the upper right arm, in the left leg, then, as you stumble, twice in the chest. You fall down and don't come up again."	"An arrow plants itself in your [one of]left[or]right[at random] [one of]leg[or]arm[at random]."	"You run, duck and jump, evading all the arrows which are shot at you."	"An arrow almost hits you in the heart, but with am incredible move you manage to snatch it out of the air."
"A well-aimed arrow hits you in the throat, immediately killing you."	"Try as you may, you cannot dodge all the arrows--one of them stick painfully in your butt."	"Arrows rains down all around you, but none hit you."	"Several arrows hit you, but they deal no real damage."


Instead of going north in The Castle's Courtyard:
	choose row with a Skill of Bronze Armour in the Table of Player Skills;
	if the have entry is 0 begin;
		now the have entry is 1;
		increase the zeal of the player by 4;
		increase the permanent zeal of the player by 4;
		say "'Wait!', a voice in your head demands. It is Elda, one of the four Gods of War, the colleague of Groth and Duncan and Shliss. 'Wait, unless you wish to die. Do you see those archers all over the walls? They will kill you if you go out there unprotected; and whatever their merits may be, my brother Groth's skills will not be able to help you in [italic type]this[roman type] situation.[paragraph break]'The time for mindless violence has passed, and the time for wise decisions has come. Witness, therefore, the skill of [bold type]bronze armour[roman type]! Use it now if you want to reach those gates alive.[paragraph break]'And even so, this might not be a bad time to use that other ability we have given you--the ability to [bold type]save[roman type]. Have faith, my brave warrior, and good luck!'" instead;
	end if;
	if the Courtyard Position is less than 5 begin;
		increase the Courtyard Position by 1;
		say "You run as fast as you can towards the gates.";
		try looking;
		if the Courtyard Position is 1 and the archers are indifferent begin;
			say "One of the archers sees you and starts shouting.";
			now the archers are hostile;
		end if;
	otherwise;
		say "You run through the gates, towards your freedom.[paragraph break][bold type]So that is the story of your escape, is it?[paragraph break][roman type]'Yes, it is. And if you don't mind, I have matters to attend to.'[paragraph break]";
		change player to yourself;
		try looking;
	end if.

Instead of going south in The Castle's Courtyard:
	if the Courtyard Position is greater than 0 begin;
		decrease the Courtyard Position by 1;
		say "You run towards the temporary safety of the guardhouse.";
		try looking;
	otherwise;
		move the player to the Guard Room;
	end if.

Instead of going in The Castle's Courtyard:
	say "That would only expose you for longer.".





Book 3.1 - Level 1 - The Autumnal Forest


Part 3.1.1 - Normal locations


Chapter 3.1.1.1 - Regions


Section 3.1.1.1.1 - The Forest

The Forest is a region. Beneath the Pine Tree, the Muddy Path, the Ruined Chapel, On Top of the Ruined Chapel, By the Waterfall are in the Forest.

Instead of smelling a room in the forest: say "Fallen leaves and decaying wood, the faint but ever-present odour of rotting plants--the common smells of death in a forest in autumn.".

Instead of listening to a room in the forest: say "A bird sings somewhere [one of]to your left[or]to your right[or]behind you[or]in front of you[purely at random]; and [one of]under the leaves[or]in a tree[or]between the bushes[purely at random] a small animal scurries away.".

The leaves are a backdrop. The leaves are in the forest. Instead of examining the leaves: say "Brown, yellow, red--a multi-coloured carpet of leaves covers the forest floor.". Instead of searching the leaves: say "You poke among the leaves with your sword. Sticks and stones: what a surprise.". Instead of taking the leaves: say "Much better to have a bunch of dead leaves in your hands than a sword, isn't it, when some bloodthirsty enemies come running towards you?".

The forest trees are a backdrop. The forest trees are in the forest. Understand "trees" and "tree" as the forest trees. Instead of examining the forest trees: say "Mostly oaks, beeches and birches, all engaged in the struggle for life.". Instead of climbing the forest trees when a hostile alive monster is enclosed by the location: say "Perhaps you mean to [italic type]retreat[roman type]?". Instead of climbing the forest trees: say "You climb a tree; you don't see anything because all the other trees are just as high; you climb down again."

The ravenous vampire bat is a vampire bat.

First every turn when the player is in the forest:
	if the determinate number of the shadowy movement is 2 begin;
		if a random chance of 1 in 15 succeeds and no hostile alive monster is enclosed by the location and the player carries more than one thing begin;
			now the thing dummy is a random thing carried by the player;
			while the thing dummy is the sword repeatedly now the thing dummy is a random thing carried by the player; 
			say "A twittering sound, a quick movement--and before you realise what is happening, one of those damned squirrel monkeys is running away with [the thing dummy]! It disappears in the trees before you can even finish cursing it.";
			move the thing dummy to a random room in the forest;
		end if;
	end if;
	if the determinate number of the shadowy movement is 3 begin;
		if a random chance of 1 in 20 succeeds and no hostile alive monster is enclosed by the location begin;
			now the gained blood of the ravenous vampire bat is 0;
			now the blood of the ravenous vampire bat is 5;
			move the ravenous vampire bat to the location;
			calculate the initial combat significance;
			now the combat boolean is 1;
			say "A dark form comes sweeping from the branches above you--it is one of the vampire bats, thirsty for your blood!";
		end if;
	end if.




Section 3.1.1.1.2 - The Swamp

The Swamp is a region.

Instead of smelling a room in the swamp: say "The incredibly foul stench would be enough to make other men gag. But not you; you've smelled worse. The innards of the Kraag slime monster, for instance.".

Instead of listening to a room in the swamp: say "The buzzing of small insects is the most noticeable sound in the swamp[if an alive dog is in the courtyard]. You can also hear a dog barking in the fort[end if].".

The rotting plants are a backdrop. The rotting plants are in the swamp. Instead of examining the rotting plants: say "Everywhere around you are plants in different states of decay.". Instead of taking the rotting plants: say "They would only make your hands slick, which could be dangerous in a fight.". Instead of eating the rotting plants: say "Yuck!". Instead of smelling the rotting plants: say "They smell of decay.". Instead of tasting the rotting plants: say "Yuck!".

The small insects are a backdrop. The small insects are in the swamp. Instead of examining the small insects: say "At a glance you see mosquitoes, flies, grasshoppers, and dragonflies, all intent on their diverse doings.". Instead of listening to the small insects: say "Thousands of different sounds blend together in a monotonous buzzing.".  Instead of taking the small insects: say "You might catch a few, but to what purpose?".

The stagnant water is an enterable backdrop. The stagnant water is in the swamp. Instead of examining the stagnant water: say "Small and large patches of water are everywhere around you, often hidden under a layer of vegetation.". Instead of drinking the stagnant water: say "The water is foul and would certainly make you ill.". Instead of tasting the stagnant water: say "The water is foul and would certainly make you ill.". Instead of entering the stagnant water: say "That would be dangerous, disgusting and dumb.".

The swamp vegetation is a backdrop. The swamp vegetation is in the swamp. Understand "weeds" and "rushes" and "plants" as the swamp vegetation. Instead of examining the swamp vegetation: say "Many different species of plants grow in the swamps around you, though none of them grow much higher than your waist.". Instead of taking the swamp vegetation: say "You see neither medicinal herbs nor potent poisons.". Instead of eating the swamp vegetation: say "You glance around for medicinal herbs, but see nothing that might help you.".

The fort is a backdrop. The fort is in the swamp. Instead of examining the fort: say "A very large but exceedingly crude building. From the tales the wandering bards used to tell, you expect this to be the stronghold of trolls.". Understand "stronghold" and "building" as the fort.


Section 3.1.1.1.3 - The Troll Fort

The Troll Fort is a region. The Troll Courtyard and the Large Troll Hall are in the Troll Fort.




Chapter 3.1.1.2 - Beneath the Pine Tree

Beneath the Pine Tree is a room.  "[if the time of day is 9:00 AM]Until now there has been no opposition, but you feel that this is soon going to change. What minions will the self-styled Lord Death throw at you? In which direction lies his subterranean domain?[paragraph break][end if]You lean against a towering tree, and take a good look at your surroundings. [the current room description text of the shadowy movement]The trail[if the time of day is 9:00 AM] you have been following south[end if] forks into three distinct paths: a large, muddy one to the [bold type]west[roman type]; a straight and apparently well-traveled one to the [bold type]south[roman type]; and a very narrow trail, almost hidden beneath leaves and broken branches, leading to the [bold type]east[roman type]. From here, you cannot judge where they are going--the autumnal forest stretches in all directions." [The player is in Beneath the Pine Tree.]

A thing called the pine tree is in Beneath the Pine Tree. The pine tree is scenery. Understand "towering" and "massive" as the pine tree. Instead of examining the pine tree: say "A massive pine dominates this part of the forest. Smaller trees, mostly beeches, cower in its shadow, their stunted frames bearing witness to their oppressor's thirst for light and water.". The pine tree has a number called the pine tree number. The pine tree number is 3.

The shadowy movement is here. It is a determinable. Understand "vampire" and "bats" and "squirrel" and "monkeys" and "monkey" and "birds" and "thrush" and "blackbird" and "robin" and "wren" and "magpie" and "woodpecker" and "blackbirds" and "movements" as the shadowy movement.

The options number of the shadowy movement is 3.
The current room description text of the shadowy movement is "[if no hostile alive monster is enclosed by the location]There seems to be no danger, unless the shadowy movements in the trees above turn out to be something sinister. [end if]".
The first option text of the shadowy movement is "'A thrush, several blackbirds and a robin. Nothing to worry about.'".
The first room description text of the shadowy movement is "[if a random chance of 1 in 2 succeeds]Harmless forest birds fly about in the foliage. [end if]".
The first description text of the shadowy movement is "You spot a [one of]blackbird[or]magpie[or]woodpecker[or]wren[at random].".
The first printed text of the shadowy movement is "forest birds".
The second option text of the shadowy movement is "'Damn, a bunch of squirrel monkeys. On that trip I made to the Andine Forest, they turned out to be filthy thieves.'".
The second room description text of the shadowy movement is "Squirrel monkeys can be glimpsed leaping from branch to branch high above you. ".
The second description text of the shadowy movement is "Often, the monkeys stop to look down at you with curiosity. If they're anything like their Andine cousins, the braver ones will try to steal your possessions. Unfortunately, they're incredibly quick and agile and will probably succeed.".
The second printed text of the shadowy movement is "squirrel monkeys".
The second spirit of the shadowy movement is 1.
The third option text of the shadowy movement is "'Bloody vampire bats! Better keep my sword ready.'".
The third room description text of the shadowy movement is "Vampire bats are awaiting their chance in the branches above. ".
The third description text of the shadowy movement is "Malevolent creatures, active night and day. It's fortunate for humanity that they are solitary hunters, but still, even a single vampire bat can be a pain in the ass.".
The third printed text of the shadowy movement is "vampire bats".
The third spirit of the shadowy movement is 1.

Instead of attacking the shadowy movement: say "No way. They're thirty feet above you.".

Instead of climbing the pine tree:
	make a climb check of difficulty the pine tree number;
	if the climb boolean is 0 begin;
		say "It's hard to get a good grip on the thick trunk, but you manage to make some headway by pulling yourself up on the dead and dying branches that stick out from these lower regions. When you are about halfway up and in a particularly difficult spot, one of them suddenly snaps under your weight! You come crashing down, breaking other branches as you fall and making the climb that much more difficult in the future.[paragraph break][italic type]You receive 1 damage.[roman type][paragraph break]";
		increase the pine tree number by 1;
		deal 1 damage to the player;
	otherwise;
		say "It's not easy and you get covered in the pine's sticky juices, but you manage to climb to a point where you can survey the land around you. [if the determinate number of the shadowy movement is not 0](By that time, the [printed name of the shadowy movement] have had ample time to get out of your way.) [end if]Let's see. A crude fort, half hidden by patches of fog, has been erected to the [bold type]west[roman type]. Trolls, if you're not mistaken. On the [bold type]opposite side[roman type], a small column of smoke rises from the nearby forest. More disconcerting is the huge cliff that, to the [bold type]south[roman type], rises everywhere above the trees. How are you ever going to climb that?[paragraph break]Well, you never thought that getting to the Death Lord would be easy. With a grim expression, you get down again. No rest for the wicked.";
		if the pine tree is not handled, now the pine tree is handled;
	end if.
	
Instead of attacking the pine tree: say "You punch the pine tree where it hurts. You, that is. The pain is refreshing.".

Instead of going up in Beneath the Pine Tree: try climbing the pine.

Instead of going north in Beneath the pine tree: say "There's nothing for you among the gentiles. Push forward. Listen to the gods. Find the Death Lord. Experience, learn, choose. Never, ever, give up. That kind of claptrap.".

Instead of going south in Beneath the Pine Tree: say "It would lead you to an impassable gate, but that location hasn't been implemented in this Demo version.".

Instead of going east in Beneath the Pine Tree: say "It would lead you to the witch's house, but that location hasn't been implemented in this Demo version.".




Chapter 3.1.1.3 - The Muddy Path

The Muddy Path is west of Beneath the Pine Tree. "A pool of water has formed in the middle of the path leading [bold type]east[roman type] and [bold type]west[roman type][the current room description text of the pool of water][if the mad boar is killed]. [current room description text of the ruined building between the trees] is visible through the trees to the [bold type]north[roman type], while the sound of falling water drifts in from the [bold type]south[roman type][end if]."

Instead of listening to a room in The Muddy Path: say "Softly but persistently, the sound of a waterfall invades your ear.".

The pool of water is in The Muddy Path. The pool of water is a detailer. Instead of examining the pool of water: say "A shallow pool of muddy water. Judging from the many tracks left in the mud, the forest animals come here to drink.". Instead of drinking the pool of water: say "Yeah, perhaps. When you get [italic type]really[roman type] thirsty." The current room description text of the pool of water is "". The detailed room description text of the pool of water is ". Many forest animals have left tracks in the mud surrounding it[the current room description text of the tracks]". 

Instead of jumping in The Muddy Path: say "You can just walk around the pool.".

The mud is in The Muddy Path. It is scenery. Instead of examining the mud: say "The mud is covered with tracks and footprints, of which only those of the boars and the trolls seem to indicate danger. That is as far as your interest in mud goes.". Instead of taking the mud: say "You contemplate the tactical possibilities of thrown mud, and then think better of it.". Instead of searching the mud: say "What do you think you're going to find, the enchanted magic ring of sorcery or something?".

The tracks are in The Muddy Path. The tracks is a detailer. Understand "footprints" and "prints" as the tracks. Instead of examining the tracks: say "All the smaller tracks are those of common forest animals, but there is also a large spoor leading to the west. Footprints twice as big as those of a man, four toes--there is no doubt about it. A troll.". The current room description text of the tracks is "". The detailed room description text of the tracks is ": deer, wild pigs, wolves, and--monsters rather than animals, perhaps--trolls"

The ruined building between the trees is in The Muddy Path. The ruined building between the trees is a detailer. Instead of examining the ruined building between the trees: say "[if the ruined chapel is not visited]Some kind of temple or something. You'd better go north if you wish to know more[otherwise]It is the old shrine of Groth which you have already explored[end if].". Instead of climbing, taking, searching, entering, looking under, opening, closing, attacking, kissing, smelling, tasting, eating or drinking the ruined building between the trees: say "Look, you're not there yet.". The current room description text of the ruined building between the trees is "A ruined building". The detailed room description text of the ruined building between the trees is "[if the ruined chapel is not visited]Some kind of ruined temple[otherwise]The ruined chapel of Groth[end if]". Understand "temple" and "shrine" and "chapel" as the ruined building between the trees.

[Enemies]

A wild boar called the mad boar is in The Muddy Path.  "Your attention is fully focused on a wild boar that is standing next to the pool. It has a bloody gash on its left side, and its red eyes are full of pain and madness. This one is not going to run away from you[if the player was not enclosed by The Muddy Path], so you grab your sword and prepare for the fight[end if]." 

Every turn when the player is in The Muddy Path:
	if the mad boar was not killed begin;
		if the mad boar is killed begin;
			say "The deep voice of Groth booms across the land: [italic type]'Good! Pig dead, you alive: good fighter. You go north, see my temple. Bring idol, Groth reward you.'[roman type][paragraph break]";
		end if;
	end if; 
	if the mad boar is killed, now the mad boar is handled.




Chapter 3.1.1.4 - The Ruined Chapel

The Ruined Chapel is north of the Muddy Path. The Ruined Chapel is down from On Top of the Ruined Chapel. "Shafts of sunlight play intricate games, clothing the ruin--once a small temple--in a shimmering gown of light and shadow. It [italic type]is[roman type] a ruin: the wall nearest to you has completely succumbed to rain, wind and gravity (or whatever other, more sinister forces have laboured towards its destruction); and yet it remains defiant--the other three walls[the current room description text of the walls_temple] still stand upright and firm, faithfully supporting what remains of the roof. [the current room description text of the mosaic][paragraph break]The forest path beckons to the [bold type]south[roman type]."


The ruined temple is in the Ruined Chapel. It is an enterable transparent scenery container. Instead of examining the ruined temple: try looking. Understand "chapel" and "ruined" and "temple" as the ruined temple. Instead of climbing the ruined temple: try climbing the temple_roof. The printed name of the ruined temple is "ruined chapel".

Does the player mean entering the ruined temple: it is very likely.




After entering the ruined temple for the first time:
	say "You enter the temple, and it feels sacred and unspoiled. In some ways it [italic type]is[roman type] unspoiled: not a leaf or branch covers the mosaic floor. Only a massive chest which huddles slightly to your right has fallen prey to the moss that so profusely covers the outside of the ruin.";
	move the moss-covered chest to the ruined temple;
	now the current room description text of the mosaic is the detailed room description text of the mosaic.

The temple_roof is in the Ruined Chapel. It is scenery. Understand "roof" as the temple_roof. Instead of examining the temple_roof: say "Half of it appears to remain intact. You could climb up on it, you suppose.".

Instead of climbing the temple_roof:
	make a climb check of difficulty 3;
	if the climb boolean is 0 begin;
		say "You lose your grip on the slippery moss and fall down on your ass. Ungracious. Humiliating.";
	otherwise;
		say "Sure. You are able to find a few good handholds between the slippery patches of moss and within seconds, you are on the roof.";
		move the player to On Top of the Ruined Chapel;
	end if.

Instead of going up in The Ruined Chapel: try climbing the temple_roof.



The moss-covered chest is an openable, closed, fixed in place container. "A moss-covered chest, which is currently [if the moss-covered chest is open]open[otherwise]closed[end if], is the only sacred artefact left." Instead of examining the moss-covered chest: say "It is a big thing, and made of stone--you won't be carrying it anywhere. Moss covers most of the chest, but you can still make out the sun symbol of Groth.".  Instead of taking or pushing or pulling the chest: say "Think you can do that? Not without a couple of horses, you can't.". Instead of attacking the moss-covered chest: say "You kick the chest. The soft moss absorbs most of your foot's impetus, so you don't hurt yourself.". Instead of unlocking the moss-covered chest with: say "There is no keyhole." Understand "artefact" and "artifact" as the moss-covered chest.


Break-out begins when the player is in Ruined Chapel for the first time.


The moss is in the Ruined Chapel. The moss is scenery. Instead of examining the moss: say "The outer sides of the walls[if the moss-covered chest is in the ruined temple] as well as the big chest[end if] are covered in light green star moss. Drops of dew have gathered in the moss and shine with a pearly brilliance whenever the shafts of sunlight move across them.". Instead of eating the moss: say "Yeah, well. You ate moss back when you were locked up in the secret corridors of Otranto Castle, and it was a culinary experience you are not eager to repeat. ". Instead of taking or attacking the moss: say "The moss clings tenaciously to the stones. (And sticking your sword in non-sentient plant life is not your idea of a good fight.)". Instead of searching the moss: say "Guess what you find beneath the moss? Stones.".




The mosaic is in The Ruined Chapel. The mosaic is a detailer. Understand "floor" and "sun" as the mosaic. The current room description text of the mosaic is "". The detailed room description text of the mosaic is " The floor inside--which, exposed as it is, is curiously free of leaves--is inlaid with a beautiful if faded mosaic of a yellow and red sun."

Instead of examining the mosaic: 
	say "A stylised sun with six rays emanating from it has been carefully constructed from red and yellow stones. It is the symbol of Groth, and marks this building as his temple.";
	now the printed name of the Ruined Chapel is "Ruined Chapel of Groth". 

The far-off path is a backdrop. It is in The Ruined Chapel and in By the Waterfall. The far-off path is scenery. Instead of examining the far-off path in The Ruined Chapel: say "The muddy path where you defeated the wounded boar lies just south of the temple.".

The walls_temple are in The Ruined Chapel. They are a detailer. Understand "wall" and "walls" as the walls_temple. The printed name of the walls_temple is "walls". Instead of examining the walls_temple: say "Thick layers of moss cover the three walls that still defy time.". The current room description text of the walls_temple is "". The detailed room description text of the walls_temple is ", though covered by thick layers of moss,".

The stones_temple are in The Ruined Chapel. They are scenery. Understand "stone" and "stones" as the stones_temple. Rule for printing the name of the stones_temple: say "stones". Instead of examining the stones_temple: say "Big stones, small stones, round stones, square stones--but at the end of the day and when all is said and done, still stones.". Instead of taking the stones_temple: say "Bashing someone's brain in with a big stone undeniable [italic type]looks[roman type] good; but you know from experience that such a feat is only practical when you are the guy standing on top of the castle wall and your opponent is the guy attempting to scale that wall while dodging the boiling oil. Which means, of course, that [italic type]right now[roman type], these stones are about as useful to you as a small bunch of asparagus.". Instead of searching the stones_temple: say "You absentmindedly kick around a few of the smaller stones, and reveal nothing interesting.".

The shafts of sunlight are in The Ruined Chapel. They are scenery. Instead of examining the shafts of sunlight: say "As the branches above sway in the wind, patterns of light and shadow change on the ground below.".

The drops of water are in The Ruined Chapel. Understand "dew" as the drops of water. They are scenery. Instead of examining the drops of water: say "Small drops of water cling to the moss.". Instead of taking or drinking the drops of water: say "You gather a few of the drops in your hands and drink the clear water. It tastes slightly of moss, reminding you of Otranto Castle (but that is a tale for another time).".



Chapter 3.1.1.5 - On Top of the Ruined Chapel

The description of On Top of the Ruined Chapel is "You stand erect, the sunlight streaming along your blade. Motionless. Silent. No sculptor ever wrought a warrior approaching your simple perfection.".

Instead of jumping in On Top of the Ruined Chapel: try going down.

Every turn when the player is in On Top of the Ruined Chapel:
	if the temple_roof is not handled begin;
		say "[italic type]'Good! Groth like you. Like you a lot. You good fighter. Groth reward you, you become even better.' [bold type](Groth rewards you with 5 zeal!)[roman type][paragraph break]";
		increase the zeal of the player by 5;
		now the temple_roof is handled;
	end if.

The streaming sunlight is in On Top of the Ruined Chapel. It is scenery. Understand "sunlight" as the streaming sunlight. Instead of examining the streaming sunlight: say "Like fire. To purify and destroy. To conquer. To enlighten.".




Chapter 3.1.1.6 - By the Waterfall

By the Waterfall is south of the Muddy Path. "With roaring violence a stream of water comes thundering down, drowning out all other sounds. What it thunders down from is not a natural cliff but a huge stone wall that blocks all movement south[the current room description text of the waterfal_wall]. Once down, the water gathers itself together in a pool and continues its way quietly to the [bold type]west[roman type][if the Cave Behind the Waterfall is visited]; through the pool, you can reach the cave behind the waterfall[end if][if the Muddy Path is visited].[paragraph break]The muddy path lies some distance to the [bold type]north[roman type][end if].[if By the Waterfall is not visited][paragraph break]You hear the voice of Groth in your head. [italic type]'You look out. Scaly coward hides here.'[roman type][end if]"

Instead of listening to a room in By the Waterfall: say "You hear only the massive roar of falling water.".


c_Waterfall, c_Waterfall_yes and c_Waterfall_no are chat nodes.

Instead of going south in By the Waterfall: run a conversation from c_Waterfall.
Instead of going up in By the Waterfall: run a conversation from c_Waterfall.

Instead of giving text for c_Waterfall: say "Climbing that wall would be exceedingly difficult even without the spray making it all wet and slippery; and falling down from halfway up is probably going to kill you. Are you sure you wish to attempt it?".
Instead of finding responses to c_Waterfall: forbid exiting on zero; link to c_Waterfall_yes; link to c_Waterfall_no.

Instead of giving link to c_Waterfall_yes: say "Yes. Do you think I'm a coward or what?".
Instead of giving text for c_Waterfall_yes:
	make a climb check of difficulty 11;
	if the climb boolean is 0 begin;
		now the first dummy is a random number between 2 and 12;
		say "You attempt to make your way up the nigh unclimbable wall. Your foolish attempt ends in failure when [one of]your fingers slip away from one of the wet building blocks you were trying to hold on to[or]a stone that somebody upstairs must have thrown at the half-seen shape that was you hits you on the shoulder and throws you off balance[or]the roots of a plant you were holding on to suddenly give way[purely at random]. You fall down, receiving ", first dummy, " damage.";
		deal first dummy damage to the player;
	otherwise;
		say "You attempt to make your way up the nigh unclimbable wall. And, through luck and skill, you make it! (But, guess what--[italic type]that location hasn't been implemented yet, and on top of that you are a cheater!)[roman type][paragraph break]"; [TODO]
		if the waterfal_wall is not handled, now the waterfal_wall is handled;
	end if.

Instead of giving link to c_Waterfall_no: say "No. Discretion [italic type]is[roman type] the better of valour, after all.".
Instead of giving text for c_Waterfall_no: say "Smart.". 


The waterfal_wall is a detailer in By the Waterfall. The printed name of the waterfal_wall is "huge wall". Understand "stone" and "sheer" and "huge" and "wall" as the waterfal_wall. It is scenery. Instead of climbing the waterfal_wall: try going south. Instead of examining the waterfal_wall: say "The spray makes it difficult to see its top or judge its height, but it is certainly quite a bit higher than even the biggest trees around.".  The current room description text of the waterfal_wall is "". The detailed room description text of the waterfal_wall is "; the spray makes it difficult to see its top or judge its height, but on the positive side, it makes it equally difficult for anyone above to see [italic type]you[roman type]".

The spray is in By the Waterfall. It is scenery. Understand "rainbows" and "sun" as the spray. Instead of examining the spray: say "The sun paints rainbows in the spray. Breathtakingly beautiful.".

Instead of examining the far-off path in By the Waterfall: say "A couple of minutes walking to the north will bring you to the muddy path where [if the mad boar is alive]you fled the boar[otherwise]you killed the mad boar[end if].".



The waterfal_water is in By the Waterfall. It is scenery. It is an enterable container. Understand "water" and "pool" and "stream" and "movement" and "surface" and "shape" and "bottom" as the waterfal_water. The printed name of the waterfal_water is "pool". Instead of drinking the waterfal_water: say "You drink a few handfuls of the refreshingly cool water.".

Instead of examining the waterfal_water:
	if the blue serpent is killed, say "It seems clear and safe now." instead;
	say "[one of]You gaze into the water, mesmerised by the patterns of wave and sunlight. Suddenly, you startle from your reverie--did you see movement beneath the surface?[or]You peer into the water, but you don't see any movement now. Perhaps you were mistaken.[or]No, wait--there [italic type]is[roman type] a dark shape moving along the bottom of the stream, isn't there? Or was that just a trick of the light?[or]No, you don't see anything now. You must have been mistaken.[stopping]".

Instead of swimming in By the Waterfall: try entering the waterfal_water.


The blue serpent is a water serpent.

After entering the waterfal_water:
	say "After you've taken a few steps in the water, a great beast suddenly leaps up from the depths and attacks you![paragraph break]";
	now the blue serpent is in By the Waterfall;
	calculate the initial combat significance;
	now the combat boolean is 1;
	now the noattack boolean is false.



A thing called the waterfall is in By the Waterfall. The waterfall is scenery. Understand "hollow" and "stream" and "water" as the waterfall. Instead of examining the waterfall: say "A sheet of clear water, cascading down the enormous wall. It is hard to be certain, but there might be a hollow in the cliff behind it.".
	
Instead of entering the waterfall:
	if the player is not in the waterfal_water, say "You cannot reach behind the waterfall without entering the pool first." instead;
	say "You walk through the sheet of water and emerge on the other side, dripping.";
	move the player to the Cave Behind the Waterfall.



Every turn when the player is enclosed by By the Waterfall:
	if the blue serpent was not killed and the blue serpent is killed, say "As you watch the blue serpent's carcass drifting on the water, you hear Elda's confident voice well up in your mind: [italic type]'Very good, my brave warrior! Now you should enter my temple and claim your reward.'[roman type][paragraph break]".

	

Chapter 3.1.1.7 - Cave Behind the Waterfall

The Cave Behind the Waterfall is a room. "Water drips from your hair and your clothes onto the ground of this shallow cave. A large but almost faded painting[if the faded painting is handled] of Elda[end if] covers the south wall of the cave, while the waterfall rushes down [bold type]north[roman type]." Instead of going north in the Cave Behind the Waterfall: move the player to By the Waterfall.

Instead of listening to a room in Cave Behind the Waterfall: say "The sounds of falling water drowns out all other sound. You can hardly hear yourself think.".

The faded painting is in the Cave Behind the Waterfall. It is scenery. It is an openable closed container. Understand "shield" and "moon" and "waning" and "waxing" and "woman" and "hinges" and "door" as the faded painting.   

Instead of examining the faded painting: 
	say "Long exposure to the humid atmosphere has erased most detail, but you can still recognise a tall woman with regal features. She bears a large shield with a waning moon on it, and behind her you can make out the outlines of a waxing moon. It is Elda, the only female God of War.[paragraph break][if the faded painting has not been open]The painting has hinges attached to it on one side, so it might be some kind of door[otherwise if the faded painting is open]The painting is currently open[otherwise]The painting is currently closed[end if].";
	now the faded painting is handled.

Instead of attacking the faded painting: say "That would anger Elda, which is [italic type]not[roman type] a smart move.". Instead of taking the painting: say "Tough luck: it has been painted directly on the rock.".

The behind_the_waterfall is in the Cave behind the Waterfall. It is scenery. Understand "waterfall" and "water" as the behind_the_waterfall. Rule for printing the name of the behind_the_waterfall: say "waterfall". Instead of examining the behind_the_waterfall: say "You see a blurred version of the stream and banks outside.".

Instead of entering the behind_the_waterfall:
	say "You walk back through the waterfall, getting even wetter.";
	move the player to the waterfal_water.
	
Instead of going north in Cave behind the Waterfall: try entering the behind_the_waterfall.


The faded painting contains two sticks of guarding.


Chapter 3.1.1.8 - Edge of the Swamp

Edge of the Swamp is west of the Muddy Path. "You stand at the edge of a foul swamp where decent plants die horrible deaths and slimy creepers malevolently feast on their rotting corpses. A fort rises from the marshes straight to the [bold type]west[roman type], with a broad path leading towards it from the forest [bold type]east[roman type] of you. Another path, much smaller, disappears into the [bold type]northwest[roman type] vegetation." Edge of the Swamp is in the Swamp.

A young troll called the small troll is in the Edge of the Swamp. "[if the small troll is alive]A small troll rushes at you with a primitive battle cry![end if][if the small troll is killed]The small troll lies dead where you cut it down.[end if][if Edge of the Swamp is not visited][paragraph break][italic type]'Don't underestimate the trolls,' the voice of Elda warns you. 'Finish them off quickly, for they have the power of regeneration.'[roman type][end if]"

The leaves and the forest trees are here.

The smaller path is here. It is scenery. Instead of entering the smaller path, try going northwest. Instead of examining the smaller path: say "Nearly overgrown, twisting its unpredictable way between hidden pools of water, this path is not going to be easy to follow. But why attempt easy things?".

The larger path is here. It is scenery. Instead of entering the larger path, try going west. Instead of examining the larger path: say "Three observations prove that trolls go up and down this path regularly. One: their footprints are all over it. Two: gnawed bones lie discarded along its edges. Three: heaps of troll shit profane the honest dirt.".


Before going northwest in Edge of the Swamp: say "[paragraph break]The path is hardly visible and dangerously unsafe ground lies on both sides, so you move along slowly.".


Chapter 3.1.1.9 - Path through the Swamp

A room called Path through the Swamp is west of Edge of the Swamp. Path through the Swamp is in the Swamp. "A broad path continues to lead straight from the forest in the east to the large wooden fort in the west; right now, both locations seem desirable places to be, since they will probably be free of the insistent buzzing of insects and the smell of rotting that pervade this swamp."

A snake called a small green snake is here. In Path through the Swamp is a mud crab.

Every turn when the small green snake is killed:
	if the player is not in Path through the Swamp, now the blood of the small green snake is 4;
	if the player is not in Path through the Swamp, now the gained blood of the small green snake is 0.



Chapter 3.1.1.10 - By the Rotting Tree

By the Rotting Tree is a room. "Once this was the place where a lonely oak tree courageously fought against the hostile swamp; but today only a rotting[if the lonely oak tree is handled], fallen[end if] carcass remains to testify to its efforts. [if the wasps' nest is part of the lonely oak tree]Wasps buzz everywhere around it[end if] The narrow path, which leads here from the south, is lost in the lush undergrowth--you do not see where it continues.[if the lonely oak tree is handled] However, since you toppled it the oak tree forms a a kind of bridge to the northwest.[end if]". By the Rotting Tree is in the Swamp. Northwest of Edge of the Swamp is south of By the Rotting Tree.


Instead of going nowhere from By the Rotting Tree for the first time : say "You attempt a few steps in that direction, but almost fall into a pool of black water that lies hidden under the plants.".

Instead of going nowhere from By the Rotting Tree for the second time: say "You spy a stone lying between the rushes, and reasoning that it must be solid footing, make a large step towards it. It promptly sinks into the marsh, and you have to struggle through cold mud to get back to the path again.".

Instead of going nowhere from By the Rotting Tree for the third time: say "Once more you brave the treacherous ground of the swamp, only to stumble into a very deep pool. Your feet become entangled in the plants and roots at the bottom, and, struggle as you may, you do not manage to reach the surface again."; end the game in death.


The lonely oak tree is here. It is scenery and a supporter. Instead of examining the lonely oak tree: say "Perhaps it was never majestic, but it its day it must have been quite large. Now its leaves and branches are gone and only a rotting trunk perhaps four times your height remains.[if the wasps' nest is part of the lonely oak tree] Wasps have apparently made a nest near the top of the tree, since dozens of them are flying in and out of it.[end if]". Understand "rotting" and "stump" and "carcass" as the lonely oak tree.

The wasps' nest is part of the lonely oak tree. Instead of examining the wasps' nest: say "[if the wasps' nest is part of the lonely oak tree]You cannot really see the nest as such, which consists of little tunnels the wasps have bitten out of the rotting wood, but the constant entrance and departure of wasps gives you a very good idea of where it is located.[otherwise]A piece of rotting wood in which a colony of wasps have made their home. Wasps continually fly in and out of it.[end if]" 

The ending path is here. It is scenery. Instead of examining the ending path: say "Until here the path was reasonably clear, but you have no idea where it continues.".

The pool of black water is here. It is scenery. Instead of examining the pool of black water: say "One of the nasty pools that lie hidden between the lush vegetation of the swamp.". Instead of drinking the pool of black water: say "You would probably die.". Instead of entering the pool of black water: say "You are not suicidal.". 

The undergrowth by the rotting tree is here. It is scenery. 


Chapter 3.1.1.11 - In Front of the Fort

A room called In Front of the Fort is west of the Path through the Swamp. It is in the Swamp. "You stand before the huge wooden doors of the fort. Like the rest of the palisade surrounding the fort, they consist of entire tree trunks held together by thick iron bands and are four or five times your height. Although there is no path, you think you might be able to walk around the palisade to the northwest or the southwest. A broad path leads back to the east.[if at least two alive dogs are in the courtyard] From the other side of the doors, you hear the aggressive barking of dogs.[end if][if the location is not visited][paragraph break][italic type]'This fort is full of trolls,' Shliss whispers. 'I suggest using a certain amount of stealth.'[paragraph break]'No, no! No stealth. Climb wall and fight!', Groth objects.[roman type][end if]"

The wooden palisade is a backdrop. The wooden palisade is here. Instead of examining the wooden palisade: say "The trunks of large trees have been dug into the ground and reinforced with iron bands. The workmanship is rough but adequate--there are no places where you can squeeze or even see through.". Understand "wall" and "walls" and "trunk" and "trunks" as the wooden palisade. Instead of burning the wooden palisade: say "Although made of wood, the palisade wouldn't catch fire if you held a flame to it.".

The wooden doors are a backdrop. The wooden doors are here. Instead of examining the wooden doors: say "The trunks of large trees have been attached to each other with iron bands so that they form two doors. They are so big that there is no way you will be able to open them. The workmanship is rough but adequate--there are no places where you can squeeze or even see through.".  Instead of climbing the wooden doors: try climbing the wooden palisade. Understand "door" and "gate" and "gates" as the wooden doors. Instead of burning the wooden doors: say "Although made of wood, the doors wouldn't catch fire if you held a flame to it.".

Instead of climbing the wooden palisade:
	make a climb check of difficulty 7;
	if the climb boolean is 0 begin;
		say "You can't get a good grip on the trunks.";
	otherwise;
		say "Using the climbing skills granted to you by Groth, you manage to scale the palisade.";
		move the player to the palisade;
		now the player is separated;
	end if.



Chapter 3.1.1.12 - The Courtyard

The Troll Courtyard is west of In Front of the Fort. "[if the player is enclosed by the palisade]You are standing on top of the wooden palisade, surveying the courtyard from above.[otherwise]You are standing in the middle of a large courtyard.[end if] It is a filthy mess: the excrement of dogs lies everywhere, even on the wrecked furniture and the primitive tools that are scattered about, and a large heap of refuse partly blocks the entrance that lead west into the fort proper. The wooden palisade encloses the other four sides of the courtyard, with the gate lying to the east."

The wooden doors are here.

Instead of smelling the location when the player is contained by the courtyard: say "The filthy stink of dog excrement is overwhelmingly present.".

A thing called the palisade is here. It is a supporter.  Understand "wall" and "walls" and "trunk" and "trunks" and "wooden" as the palisade. Instead of examining the palisade: say "The trunks of large trees have been dug into the ground and reinforced with iron bands. The workmanship is rough but adequate--there are no places where you can squeeze or even see through.". Instead of burning the palisade: say "Although made of wood, the palisade wouldn't catch fire if you held a flame to it.".

The excrement is here. It is scenery. Understand "shit" and "turd" and "turds" as the excrement. Instead of eating the excrement: say "Yuck!". Instead of taking the excrement: say "What are you going to do, throw turds at your enemies?". Instead of smelling the excrement: say "The filthy stink of dog excrement.". Instead of examining the excrement: say "Dog turds, old and new, lie everywhere.".

The wrecked furniture is here. It is scenery. Understand "table" and "tables" and "chair" and "chairs" as the wrecked furniture. Instead of examining the wrecked furniture: say "Crudely made chairs and tables, too large for human use[if the wrecked furniture is handled]. Scorch marks can be seen here and there[end if].". Instead of taking the wrecked furniture: say "The furniture is very big and very useless.". 

Instead of burning the wrecked furniture:
	if the player is separated, say "You cannot reach it from here." instead;
	say "You attempt to set fire to the chairs and tables, but after a few seconds the flames die out.";
	now the wrecked furniture is handled.

The primitive tools are here. They are scenery. Understand "hammer" and "hammers" and "spade" and "spades" and "club" and "clubs" as the primitive tools. Instead of examining the primitive tools: say "Big hammers and spades, here and there a battered club. Most of them are very filthy, and all appear as if they have known better days--and decades.". Instead of taking the primitive tools: say "There a three sufficient reasons not to. First, the tools are filthy. Second, they are in very bad shape. Third, being made for trolls, they are too big for you to use.".



The heap of refuse is here. It is scenery. Instead of smelling the heap of refuse: say "It smells of rotting food, death, and the shit of trolls.". Instead of examining the heap of refuse: say "A foul heap of bones, rotting plants, excrement, and many other unidentifiable objects.". Instead of examining the heap of refuse for the first time: say "A foul heap of bones, rotting plants, excrement, and many other unidentifiable objects.[paragraph break][italic type]'You will find something useful within, if you are brave enough to search this heap,' Duncan confides to you.[roman type][paragraph break]"

Instead of searching the heap of refuse for the first time:
	say "You start digging in the heap of refuse. After spending a few minutes with your hands submerged in vile and unnameable substances, you have to take a few steps back in order to overcome a rising feeling of nausea.".

Instead of searching the heap of refuse for the second time:
	say "Once again, you start digging through the trash of the trolls. When you are elbow-deep within the heap, where you can't see what you are doing you accidentally grab something very sharp, which deals you 2 damage!";
	deal 2 damage to the player;
	if the player is alive, say "[line break][italic type]Elda exclaims: 'Oh, come on! Tell her to stop with this revolting nonsense!'[paragraph break]'But there really [roman type]is[italic type] something useful inside!' Duncan responds, defensively. 'It's just a little deeper.'[roman type][paragraph break]".
	
Instead of searching the heap of refuse for the third time:
	say "Well, here goes. You almost [italic type]dive[roman type] into the heap, as you redouble your efforts to find the item. The stink is incredible, and your nausea returns in full force. Then, just as you are about to give up, you grasp a large metal flask.[paragraph break][italic type]'See, I told you! That's going to be fun!'[roman type][paragraph break]";
	move the flask of acid to the player.
	
Instead of searching the heap of refuse:
	say "You're not putting your hands in that again.".


The flask of acid is a thing. Instead of examining the flask of acid: say "This large metal flask contains a powerful acid. When thrown at an enemy, it will deal 1d6 damage and remove all regeneration abilities from the enemy.". Understand "large" and "metal" as the flask of acid.

Instead of throwing the flask of acid at an alive monster:
	remove the flask of acid from play;
	now the first dummy is a random number between 1 and 6;
	say "You throw the flask at the [second noun], dealing ", first dummy, " damage!";
	deal first dummy damage to the second noun;
	now the second noun is not regenerating;
	say "[line break][italic type]'YEAH!'[roman type][paragraph break]".


[Enemies]

In the Courtyard are a doberman, a terrier and a pit-bull.


[Stuff for the palisade.]

Instead of going up when the player is enclosed by the palisade: try climbing the palisade.

Instead of climbing the palisade:
	make a climb check of difficulty 6;
	if the climb boolean is 0 begin;
		say "Although they are a little bit rougher on this side, you can't get a good grip on the trunks.";
	otherwise;
		say "You manage to scale the palisade.";
		move the player to the palisade;
		now the player is separated;
	end if.

Instead of going down, jumping or exiting when the player is enclosed by the palisade:
	try getting off the palisade.

Instead of getting off the palisade:
	run a conversation from c_Palisade.

c_Palisade, c_Palisade_in and c_Palisade_out are chat nodes.


Instead of giving text for c_Palisade: say "Do you wish to get down on the inside or the outside of the fort?".
Instead of finding responses to c_Palisade: forbid exiting on zero; link to c_Palisade_in; link to c_Palisade_out.

Instead of giving link to c_Palisade_in: say "On the inside of the fort, in the courtyard. ".
Instead of giving text for c_Palisade_in:
	make a climb check of difficulty 5;
	if the climb boolean is 0 begin;
		say "You attempt to get down without falling, but fail. You receive 1 damage.";
		deal 1 damage to the player;
	otherwise;
		say "You manage to get down without falling.";
	end if;
	now the player is not separated;
	now the player is in the Courtyard.

Instead of giving link to c_Palisade_out: say "On the outside of the fort, in the swamp. ".
Instead of giving text for c_Palisade_out:
	make a climb check of difficulty 5;
	if the climb boolean is 0 begin;
		say "You attempt to get down without falling, but fail. You receive 1 damage.";
		deal 1 damage to the player;
	otherwise;
		say "You manage to get down without falling.";
	end if;
	now the player is not separated;
	now the player is in In Front of the Fort.



Chapter 3.1.1.13 - The Large Troll Hall

The Large Troll Hall is a room. "TODO."

In the Large Troll Hall is a troll.


The entrance to the fort is west of the Courtyard and east of the Large Troll Hall. The entrance to the fort is an open door. It is not openable. It is scenery. Instead of examining the entrance: say "The Troll Fort itself rises up before you, higher than most trees. A gap left in the wooden structure serves as an entrance.".



Part 3.1.2 - Dungeon 1--The Bat Cave



The Bat Cave is a dungeon. Entrance to the Bat Cave, Forking Passage, Hall of Guano, Dark Junction, Darkest Cave, Low Passage, Leaking Tunnel, The Troll Cellar, Muddy Tunnel and Northern Cave Entrance are in the Bat Cave.

The bat cave cache is a treasure chest. The cache of the bat cave is the bat cave cache. In the bat cave cache are a Duncan Idol, three sticks of guarding, two fire grenades, six sticks of illumination and seven packets of healing herbs.



Entrance to the Bat Cave is west of By the Waterfall. "You are near the mouth of a large natural cave. Dim light from the [bold type]east[roman type] serves only to discover a passage leading further [bold type]west[roman type]." The room visibility of Entrance to the Bat Cave is -1.

In the Entrance to the Bat Cave are two bats.


Forking Passage is west of Entrance to the Bat Cave. "Here, the Bat Cave forks in three directions: a dimly lit passage going [bold type]east[roman type], and two darker passages going [bold type]northwest[roman type] and [bold type]northeast[roman type]." The room visibility of Forking Passage is -2.

In the Forking Passage is a giant mud crab.


Hall of Guano is northwest of Forking Passage. "A thick layer of bat guano covers the groundYou can go [bold type]north[roman type], [bold type]northeast[roman type] and [bold type]southeast[roman type]." The room visibility of Hall of Guano is -3.

In the Hall of Guano are three bats and a vampire bat. 


Dark Junction is north of Hall of Guano. "You can go [bold type]north[roman type], [bold type]northeast[roman type] and [bold type]south[roman type]." The room visibility of Dark Junction is -3.

In the Dark Junction are a mud crab and a scorpion.


Darkest Cave is north of Dark Junction. "You can go [bold type]south[roman type]." The room visibility of Darkest Cave is -4.

In the Darkest Cave is a monstrous scorpion.

In the Darkest Cave is a treasure chest. It contains a Shliss Idol.


The Low Passage is northeast of Forking Passage. "You can go [bold type]southwest[roman type] and [bold type]north[roman type]." The room visibility of Low Passage is -3.




Leaking Tunnel is north of The Low Passage. "You can go [bold type]south[roman type] and [bold type]west[roman type]." The room visibility of Leaking Tunnel is -3.

In the Leaking Tunnel are two bats and a giant mud crab.

In the Leaking Tunnel is a treasure chest. It contains healing herbs, a stick of illumination and two stick of guardings.



The Troll Cellar is west of Leaking Tunnel and northeast of Hall of Guano. "You can go [bold type]east[roman type], [bold type]southwest[roman type] and [bold type]north[roman type]." The room visibility of Troll Cellar is -3.

In the Troll Cellar are a bat and a vampire bat.



Muddy Tunnel is north of The Troll Cellar and northeast of Dark Junction. "You can go [bold type]north[roman type], [bold type]southwest[roman type] and [bold type]south[roman type]." The room visibility of Muddy Tunnel is -2.

In the Muddy Tunnel are two mud crabs.



Northern Cave Entrance is north of Muddy Tunnel. "You can go [bold type]south[roman type]." The room visibility of Northern Cave Entrance is -1.

In the Northern Cave Entrance is a snake.







Chapter 99.1 - The Test Areas


The First Test Area is northeast of Beneath the Pine Tree. "West, north and east lie other test areas." The Second Test Area is north of the First Test Area. The Third Test Area is west of the First Test Area. The Fourth Test Area is east of the First Test Area.

Agrimante is a monster.

The blood of Agrimante is 40.
The zeal of Agrimante is 0.
The melee of Agrimante is 4.
The mind of Agrimante is 0.
The defense of Agrimante is 7. 

The level of Agrimante is 25.



In the First Test Area is Agrimante.




Chapter 100 - Cheat Codes

Snuffing is an action applying to one thing. Understand "snuff [a person]" as snuffing.

Carry out snuffing:
	deal 100000 damage to the noun.


Armageddon is an action out of world. Understand "Armageddon" and "snuff all" as Armageddon.

Carry out Armageddon:
	say "BOOM!";
	repeat with the patient running through monsters begin;
		remove the patient from play;
	end repeat;
	
	
Becoming skillful is an action out of world. Understand "Merlin" as becoming skillful.

Carry out becoming skillful:
	say "You learn every first level skill.";
	repeat through the Table of Player Skills begin;
		if the lev entry is 1, change the have entry to 1;
	end repeat.
	
	
Replenishing is an action out of world. Understand "Arthur" as replenishing.

Carry out replenishing:
	say "Sure, cheater!";
	now the blood of the player is 20;
	now the zeal of the player is 10.


Gaboodling is an action out of world. Understand "excite" as gaboodling.

Carry out gaboodling:
	increase the excitement of the player;
	say "You are now [the excitement of the player].".


Gabeedling is an action out of world. Understand "deexcite" as gabeedling.

Carry out gabeedling:
	decrease the excitement of the player;
	say "You are now [the excitement of the player].".


Getting to wherever is an action out of world. Understand "Floop" as getting to wherever.

Carry out getting to wherever:
	move the player to the Captain's Office.
	